;**********************************************************************
;****	PIC12F1822 rtc eXgvO					쐬 2011/06/28
;****	t@C	: pic_rtc.asm						XV 2013/06/06
;****	J[	: 12f1822.lkr
;****	AZu	: MPASM Ver5.41
;**********************************************************************
	LIST		P=12F1822		; list directive to define processor
	#INCLUDE	P12F1822.INC	; processor specific variable definitions
	RADIX		DEC
	ERRORLEVEL -302				; suppress message 302 from list file
    __CONFIG	_CONFIG1, _FOSC_INTOSC & _WDTE_SWDTEN & _PWRTE_ON & _MCLRE_OFF & _BOREN_ON
    __CONFIG	_CONFIG2, _PLLEN_OFF & _LVP_OFF

;**********************************************************************
;****	include
	#include	"calc32.inc"
	#include	"Timer1RTC.inc"
	#include	"SP521P.inc"
	#include	"IntenalTemp.inc"

;**********************************************************************
;****	o[W
#define VERSION	0x0106				; Ver 1.06

#define	FALSE	0
#define	TRUE	1
#define	bank0	movlb	0
#define	bank1	movlb	1

;**********************************************************************
;****	oNLWX^ (16byte)
SHR_VAR		UDATA_SHR
mWRK0		res		1				; Byte work0
mWRK1		res		1				; Byte work1
mWRK2		res		1				; Byte work2
mWRK3		res		1				; Byte work3
mWRK4		res		1				; Byte work4
mWRK5		res		1				; Byte work5
mWRK6		res		1				; Byte work6
mWRK7		res		1				; Byte work7

;****	t@Cłg悤ɃO[o
	global	mWRK0, mWRK1, mWRK2, mWRK3, mWRK4, mWRK5, mWRK6, mWRK7

;**********************************************************************
;****	f[^WX^ (oN0)
DAT_VAR		UDATA

;****	XCb` f[^
mSWTH		res		1				; XCb`f[^
mLESW		res		1				; ÕXCb`f[^
mCTSW		res		1				; XCb`pJE^

;****	ADC̎s
mADCF		res		1				; ADCtO
mACNT		res		2				; ADCpJE^

;****	[hf[^
#define	TIMEMODE	0				; ԕ\[h
#define	DATEMODE	1				; \[h
#define	VDDMODE		2				; dd\[h
#define	TEMPMODE	3				; x\[h
#define	ENDMODE		4				; ŏI[htO
mMDDT		res		1				; [hf[^
mMDSW		res		1				; XCb``FbNp

;**********************************************************************
;****	PORTA Input/Output 
T1OSI		equ		5				; 32.768kHz in
T1OSO		equ		4				; 32.768kHz out
SW1in		equ		3				; XCb`1
SW0in		equ		2				; XCb`0

;**********************************************************************
;****	ZbgxN^
RESET_VECTOR	CODE	0x000		; processor reset vector
		nop
		goto	Startup				; go to beginning of program
		retlw	low  VERSION
		retlw	high VERSION		; o[W̏

;**********************************************************************
;**** 荞݃xN^
INT_VECTOR		CODE	0x004		; interrupt vector location
		goto	Interrupt

;**********************************************************************
PROG			CODE				; program area
;**********************************************************************
;****	X^[gAbv ()
Startup
		banksel	OSCCON 
		movlw	b'01111010'			; Internal Clock 16MHz
		movwf	OSCCON				; OSC set
		banksel	ANSELA
		clrf	ANSELA				; digital I/O
		banksel	WDTCON 
		clrwdt						; EHb`hbN^C} NA
		movlw	b'00010011'			; 512mS
		movwf	WDTCON				; EHb`hbN^C} N
		bank0						; oN0
		call	init_SP521P			; LCD
		call	init_Timer1			; A^CNbN
		call	initTemp			; x
		bsf		INTCON, GIE			; 荞݋

		call	Waiting				; U҂
		clrf	mMDDT				; v\[h
		clrf	mMDSW				; [hXCb` NA
		clrf	mSWTH				; XCb` NA

;**********************************************************************
;****	C[v	 1bԂ64NĊes܂B
main
		clrwdt						; EHb`hbN^C} NA
		call	ModeSelect			; [hI
		call	showclock			; \
		call	showdate			; \
		call	showVdd				; dd\
		call	showTemp			; x\
		call	powerdown			; L[͏X[v
		bra		main				; C[v

;**********************************************************************
;****	荞ݏ	X[vN RTC  LCD ̏܂B
Interrupt
		banksel	PIR1
		btfss	PIR1, TMR1IF
		bra		Interrupt_exit
		call	Timer1_isr			; 16mS荞
		call	SP521P_isr			; LCD\
Interrupt_exit
		retfie

;**********************************************************************
;****	Tu[`
;**********************************************************************
;****	荞݋N҂ (32.768kHz̈蔭U܂)
Waiting
		clrf	mWRK7
		movlw	15
		movwf	mWRK6				; el͓Ă߂܂
Wait
		clrwdt						; EHb`hbN^C} NA
		call	SP521P_isr			; LCD\
		movlw	200
		movwf	mWRK5
		nop
		decfsz	mWRK5, F
		bra		$-2
		decfsz	mWRK7, F
		bra		Wait
		decfsz	mWRK6, F
		bra		Wait
		call	ClearDisp			; LCD
		return

;**********************************************************************
;****	[hZbg
ModeSelect
		btfsc	mSWTH, 5			; SW1 
		bra		ModeSelect_setup
		btfss	mMDSW, 1			; OĂ?
		bra		ModeSelect_exit
		btfsc	mSWTH, 1			; ꂽ?
		bra		ModeSelect_exit
		call	ClearDisp			; LCD
		bsf		mADCF, 0			; ADCN
;		clrf	(mACNT+0)			; ADCNJE^0
;		clrf	(mACNT+1)			; ADCNJE^0
		incf	mMDDT, F			; [hύX
		movlw	ENDMODE				; ŏI[h
		subwf	mMDDT, W
		btfsc	STATUS, C
		clrf	mMDDT				; v[h
		bra		ModeSelect_exit
ModeSelect_setup
		call	ClearDisp			; LCD
		movlw	TIMEMODE
		subwf	mMDDT, W
		btfsc	STATUS,	Z
		bra		ModeSelect_settime
		movlw	DATEMODE
		subwf	mMDDT, W
		btfsc	STATUS,	Z
		bra		ModeSelect_setdate
		movlw	VDDMODE
		subwf	mMDDT, W
		btfsc	STATUS,	Z
		bra		ModeSelect_setcomp
ModeSelect_settemp
		call	SetTemp				; x␳(Cƕʃ[v)
		bra		ModeSelect_exit
ModeSelect_setcomp
		call	Compensation		; i/x␳(Cƕʃ[v) 2013/06/02 ǉ
		bra		ModeSelect_exit
ModeSelect_setdate
		call	SetDate				; (Cƕʃ[v)
		bra		ModeSelect_exit
ModeSelect_settime
		call	SetTime				; (Cƕʃ[v)
		clrf	mMDDT				; v[h
ModeSelect_exit
		movf	mSWTH, W
		movwf	mMDSW
		return

;**********************************************************************
;****	\	: RTCf[^ǂݏoĕ\
showclock
		movlw	TIMEMODE
		subwf	mMDDT, W
		btfss	STATUS, Z
		return
		call	Read_RTC			; RTC̓Ǐo
		btfsc	mSWTH, 0
		bra		show_Second			; SW0ĂƂ
show_time
		movf	mHOUR, W
		call	DispHour			; \
		movf	mMINT, W
		call	DispMinute			; \
		bra		show_colon
show_Second
		call	DispHourOFF			; \
		movf	mSECD, W
		call	DispSecond			; b\
show_colon
		movf	mCOLN, W
		call	DispColon			; R\
		return

;**********************************************************************
;****	\	: RTCf[^ǂݏoĕ\
showdate
		movlw	DATEMODE
		subwf	mMDDT, W
		btfss	STATUS, Z
		return
		call	Read_RTC			; RTC̓Ǐo
		btfsc	mSWTH, 0
		bra		_show_year			; SW0ĂƂ
		call	_show_date			; \
_show_mont
		movf	mMONT, W
		call	DispHour			; \
		return
_show_date
		movf	mDATE, W
		call	DispMinute			; \
		return
_show_year
		call	DispHourOFF			; \
		movf	mYEAR, W
		call	DispSecond			; N\
		return


;**********************************************************************
;****	dd̕\	: d100{ɂĕԂĂ܂
showVdd
		btfss		mADCF, 0
		return
		call		GetVdd			; VDD̎擾 mWRK0-mWRK1  ߂l
		movlw		VDDMODE
		subwf		mMDDT, W
		btfss		STATUS, Z
		bra			showLobat
		movlw		2				; 2ڂɃhbg
		call		DispNum			; l100{Ȃ̂ł̂܂ܕ\
		return
showLobat
		mov16f32	mWRK0, m_A32
	#ifdef	__DEBUG
		movlf32		260, m_B32		; 2.60V fobN
	else
		movlf32		200, m_B32		; 2.00V [X
	endif
		call		Cmp32
		btfss		STATUS, C
		movlw		TRUE			; Low
		btfsc		STATUS, C
		movlw		FALSE			; High
		call		DispLobat		; [obe\/\
		return

;**********************************************************************
;****	x̕\		: x+40100{ĕԂĂ܂
showTemp
		btfss		mADCF, 0
		return
		movlw		TEMPMODE
		subwf		mMDDT, W
		btfss		STATUS, Z
		return
showTemp_Setup
		movlw		FALSE
		call		DispMinus		; }CiX\
		call		GetTemp			; x擾 (15mS|)
		movlf32		400, m_B32		; ADCf[^ m_A32ɎcĂ
		call		Cmp32
		btfsc		STATUS, C
		bra			showTemp_Disp
		movlw		TRUE
		call		DispMinus		; }CiX\
		movff		m_A32, m_B32
		movlf32		400, m_A32
showTemp_Disp
		call		Sub32
		mov32f16	m_A32, mWRK0	; ߂l[N
		movlw		1				; 1ڂɃhbg
		call		DispNum			; l\
		return

;**********************************************************************
;****	XCb`͏
;****	[N		: mWRK0
;****	߂l	: mSWTH - 0:SW0, 1:SW1, 4:SW0_repeat, 5:SW1_long
_InpSwitch
		movf	PORTA, W
		movwf	mWRK0				; XCb`
		clrf	mSWTH
Inp_SW0
		btfsc	mWRK0, SW0in
		bra		Inp_SW1
		btfsc	mLESW, SW0in
		goto	Inp_SW1
		bsf		mSWTH, 0			; SW0 ON
		bsf		mSWTH, 4			; SW0 ON (repeat)
Inp_SW1
		btfsc	mWRK0, SW1in
		bra		Inp_LESW
		btfsc	mLESW, SW1in
		bra		Inp_LESW
		bsf		mSWTH, 1			; SW1 ON
Inp_LESW
		movwf	mLESW
Inp_SW0_Repeat
		movlw	0x10
		andwf	mSWTH, W
		btfsc	STATUS, Z
		bra		Inp_SW1_long		; SW0͉ĂȂ
		incf	mCTSW, F
		movf	mCTSW, W
		sublw	96					; 1.5b
		btfss	STATUS, Z
		return
		bcf		mSWTH, 4			; SW0 Repeat
		movlw	80					; 0.2bZbg
		movwf	mCTSW
		return
Inp_SW1_long
		movlw	0x02
		andwf	mSWTH, W
		btfsc	STATUS, Z
		bra		Inp_OFF				; SW1͉ĂȂ
		incf	mCTSW, F
		movf	mCTSW, W
		sublw	96					; 1.5b
		btfss	STATUS, Z
		return
		bsf		mSWTH, 5			; SW1 long
		decf	mCTSW, F
		return
Inp_OFF
		clrf	mCTSW
		return

;**********************************************************************
;****	XCb`閘҂(s[gΉ)
_SW_Repeat
		call	powerdown_switch	; XCb`͑҂
		movlw	0x12
		andwf	mSWTH, W			; SW0-RepeatSW1
		btfss	STATUS, Z
		bra		_SW_Repeat			; ꂽׂ
		return

;**********************************************************************
;****	XCb`ꖘ҂
_SW_Break
		call	powerdown_switch	; XCb`͑҂
		subwf	mSWTH, W
		btfss	STATUS, Z
		bra		_SW_Break			; SăXCb`ꂽׂ
		return

;**********************************************************************
;****	A/DstO
_AdcExecFlag
		clrf	mADCF				; ADCNtOOFF
		incf	(mACNT+0), F		; ADCNJE^+1
		movlw	64
		subwf	(mACNT+0), W
		btfss	STATUS, C
		return						; ADC͊JnȂ
		clrf	(mACNT+0)			; ADCNJE^0(1b)
		incf	(mACNT+1), F		; ADCNJE^+1
	#ifdef	__DEBUG
		movlw	2					; 2bZbg(fobN)
	else
		movlw	15					; 15bZbg
	endif
		subwf	(mACNT+1), W
		btfss	STATUS, C
		return						; ADC͊JnȂ
		clrf	(mACNT+1)			; ADCNJE^0
		bsf		mADCF, 0			; ADCNtOON
		return						; ADC͊Jn

;**********************************************************************
;****	p[_E
powerdown
		call	_AdcExecFlag		; ADCtO
powerdown_switch
		call	_InpSwitch			; L[͏
powerdown_sleep
		banksel	WDTCON
		bcf		WDTCON, SWDTEN		; EHb`hbN^C} ~ (ȓd͉)
		sleep						; X[v
		nop
		bsf		WDTCON, SWDTEN		; EHb`hbN^C} N
		bank0						; oN0
		return
		
;**********************************************************************
;****	ݒ 	(CƂ͕ʂɓƎ[vœ삵܂)
#define	wMODE	mWRK7
#define	wCHNG	mWRK6
SetTime
		call	Read_RTC			; RTC̓Ǐo
		clrf	wMODE				; Mode 0
		clrf	wCHNG				; ύX 0
		bra		SetTime_hour_show	; \
SetTime_SWOFF
		call	_SW_Repeat			; XCb`܂ő҂
SetTime_SWON
		call	powerdown			; XCb`͑҂
		btfss	mSWTH, 4			; SW0(s[gt)ꂽ?
		bra		SetTime_SW1
		movf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTime_hour		; i߂
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTime_minute		; i߂
		bra		SetTime_second		; bi߂
SetTime_SW1
		btfss	mSWTH, 1			; SW1 ꂽ?
		bra		SetTime_SWON		; ĂȂ
		incf	wMODE, F
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTime_minute_show	; ֈړ
		movlw	2
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTime_second_show	; bֈړ
		movf	wCHNG, F
		btfss	STATUS, Z
		call	Write_Times			; RTC ݒ(ύXLꍇ)
		call	_SW_Break			; SẴXCb`܂ő҂
		return
;****	ύX
SetTime_hour
		incf	wCHNG, F
		incf	mHOUR, F			; +1
		movlw	24
		subwf	mHOUR, W
		btfsc	STATUS, C
		clrf	mHOUR				; 0
SetTime_hour_show
		movf	mHOUR, W
		call	DispHour			; \
		movlw	FALSE
		call	DispColon			; R\
		call	DispMinuteOFF		; \
		movf	mHOUR, W
		sublw	11
		btfsc	STATUS, C
		call	Disp_AM				; AM
		btfss	STATUS, C
		call	Disp_PM				; PM
		bra		SetTime_SWOFF
;****	ύX
SetTime_minute
		incf	wCHNG, F
		incf	mMINT, F			; +1
		movlw	60
		subwf	mMINT, W
		btfsc	STATUS, C
		clrf	mMINT				; 0
SetTime_minute_show
		movf	mMINT, W
		call	DispMinute			; \
		movlw	FALSE
		call	DispColon			; R\
		call	DispHourOFF			; \
		bra		SetTime_SWOFF
;****	bύX
SetTime_second
		incf	wCHNG, F
		incf	mSECD, F			; +1b
		movlw	60
		subwf	mSECD, W
		btfsc	STATUS, C
		clrf	mSECD				; 0b
SetTime_second_show
		movf	mSECD, W
		call	DispSecond			; \
		movlw	TRUE
		call	DispColon			; R\
		call	DispHourOFF			; \
		bra		SetTime_SWOFF
		
;**********************************************************************
;****	ݒ 	(CƂ͕ʂɓƎ[vœ삵܂)
SetDate
		call	Read_RTC			; RTC̓Ǐo
		clrf	wMODE				; Mode 0
		clrf	wCHNG				; ύX 0
		bra		SetDate_day_show	; \
SetDate_SWOFF
		call	_SW_Repeat			; XCb`܂ő҂
SetDate_SWON
		call	powerdown			; XCb`͑҂
		btfss	mSWTH, 4			; SW0(s[gt)ꂽ?
		bra		SetDate_SW1
		movf	wMODE, W
		btfsc	STATUS, Z
		bra		SetDate_day			; i߂
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetDate_mont		; i߂
		bra		SetDate_year		; Ni߂
SetDate_SW1
		btfss	mSWTH, 1			; SW1 ꂽ?
		bra		SetDate_SWON		; ĂȂ
		incf	wMODE, F
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetDate_mont_show	; ֈړ
		movlw	2
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetDate_year_show	; Nֈړ
		movf	wCHNG, F
		btfss	STATUS, Z
		call	Write_Days			; RTC ݒ(ύXLꍇ)
		call	_SW_Break			; SẴXCb`܂ő҂
		return
;****	ύX
SetDate_day
		incf	wCHNG, F
		incf	mDATE, F			; +1
		movlw	32
		subwf	mDATE, W
		btfss	STATUS, Z
		bra		SetDate_day_show
		movlw	1
		movwf	mDATE				; 1
SetDate_day_show
		call	DispHourOFF			; \
		call	_show_date			; \
		bra		SetDate_SWOFF		; I
;****	ύX
SetDate_mont
		incf	wCHNG, F
		incf	mMONT, F			; +1
		movlw	13
		subwf	mMONT, W
		btfss	STATUS, Z
		bra		SetDate_mont_show
		movlw	1
		movwf	mMONT				; 1
SetDate_mont_show
		call	_show_mont			; \
		call	DispMinuteOFF		; \
		bra		SetDate_SWOFF		; I
;****	NύX
SetDate_year
		incf	wCHNG, F
		incf	mYEAR, F			; +1N
		movlw	100
		subwf	mYEAR, W
		btfsc	STATUS,	Z
		clrf	mYEAR				; 00N
SetDate_year_show
		call	DispHourOFF			; \
		call	_show_year			; N\
		bra		SetDate_SWOFF		; I

;**********************************************************************
;****	i/x ␳ 	(CƂ͕ʂɓƎ[vœ삵܂)	2013/06/02 ǉ
#define	wMIUB	mWRK5
Compensation
		clrf	wMODE				; Mode 0
		bra		Comper_Add_show		; -␳\
Comper_SWOFF
		call	_SW_Repeat			; XCb`܂ő҂
Comper_SWON
		call	powerdown			; XCb`͑҂
		btfss	mSWTH, 4			; SW0(s[gt)ꂽ?
		bra		Comper_SW1
Comper_SW0
		movf	wMODE, W
		btfsc	STATUS, Z
		bra		Comper_Add			; iݕ␳(x点)
		bra		Comper_Sub			; x␳(i܂)
Comper_SW1
		btfss	mSWTH, 1			; SW1 ꂽ?
		bra		Comper_SWON			; ĂȂ
		incf	wMODE, F
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		Comper_Sub_show		; +␳\
		call	Comper_Show
		call	Write_Comper		; ␳lEEPROMɏ
		movlw	FALSE
		call	DispPuls			; vX\
		call	_SW_Break			; SẴXCb`܂ő҂
		bsf		mADCF, 0			; ADCN
		return
;****	iݕ␳
Comper_Add
		call	Progress_Comp		; 10.03bx点
Comper_Add_show
		call	Comper_Show
		movlw	TRUE
		call	DispMinus			; }CiX\
		bra		Comper_SWOFF
;****	x␳
Comper_Sub
		call	Dlay_Comp			; 10.03bi܂
Comper_Sub_show
		call	Comper_Show
		movlw	TRUE
		call	DispPuls			; vX\
		bra		Comper_SWOFF
;****	␳l\
Comper_Show
		call	Get_Comper
		movwf	wMIUB
		btfsc	wMIUB, 7			; ␳l}CiX̎
		sublw	0					; ␔ɂB
		movwf	mWRK0
		clrf	mWRK1
		movlw	0
		call	DispNum
		movf	wMIUB, F
		btfsc	STATUS, Z
		return						; ␳l0̎
		btfsc	wMIUB, 7			; ␳l}CiX̎
		call	DispBar				; }CiX\
		return

;**********************************************************************
;****	x␳ 	(CƂ͕ʂɓƎ[vœ삵܂)
SetTemp
		clrf	wMODE				; Mode 0
		clrf	wCHNG				; ύX 0
		bra		SetTemp_Add_show	; \ύX
SetTemp_SWOFF
		call	_SW_Repeat			; XCb`܂ő҂
SetTemp_SWON
		call	powerdown			; XCb`͑҂
		btfss	mSWTH, 4			; SW0(s[gt)ꂽ?
		bra		SetTemp_SW1
SetTemp_SW0
		movf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTemp_Add			; x\グ
		bra		SetTemp_Sub			; x\
SetTemp_SW1
		btfss	mSWTH, 1			; SW1 ꂽ?
		bra		SetTemp_SWON		; ĂȂ
		incf	wMODE, F
		movlw	1
		subwf	wMODE, W
		btfsc	STATUS, Z
		bra		SetTemp_Sub_show	; -␳
		movf	wCHNG, F
		btfss	STATUS, Z
		call	SetupTemp			; ␳lۑ
		movlw	FALSE
		call	DispPuls			; vX\
		call	showTemp_Setup		; x̓ǂݏo
		call	_SW_Break			; SẴXCb`܂ő҂
		bsf		mADCF, 0			; ADCN
		return
;****	{x␳
SetTemp_Add
		call	AddTemp				; 0.5グ
SetTemp_Add_show
		call	showTemp_Setup		; x̓ǂݏo
		movlw	TRUE
		call	DispPuls			; vX\
		incf	wCHNG, F
		bra		SetTemp_SWOFF
;****	|x␳
SetTemp_Sub
		call	SubTemp				; 0.5
SetTemp_Sub_show
		call	showTemp_Setup		; x̓ǂݏo
		movlw	FALSE
		call	DispPuls			; vX\
		movlw	TRUE
		call	DispMinus			; }CiX\
		incf	wCHNG, F
		bra		SetTemp_SWOFF

;**********************************************************************
		end

