;**********************************************************************
;****	PICxv/dd						쐬 2011/07/02
;****	t@C	: IntenalTemp.asm					XV 2011/07/21
;****	AZu	: MPASM Ver5.41
;****	gPIC16pɐVK쐬
;**********************************************************************
#define		__INTERNAL_THERMOMETOR_
#include	"IntenalTemp.inc"
#include	"calc32.inc"
#include	"pic_eeprom.inc"

;**********************************************************************
#define	FALSE	0
#define	TRUE	1
#define	bank0	movlb	0
#define	bank1	movlb	1

#define	Step	13200				; 0.00132*10000*1000 (0.1)
#define	Offset	65900000			; 0.659*10000*10000  (-40)

;**********************************************************************
;****	f[^WX^ (oN0)
DAT_VAR		UDATA
m_VDD		res		2				; dd*1000
mOFST		res		4				; ␳l

;**********************************************************************
;****	EEPROM f[^
DEEPROM		CODE
eOFST	de	low  (Offset%0x10000)	; 
		de	high (Offset%0x10000)	; Offsetl
		de	low  (Offset/0x10000)	; (ۑp)
		de	high (Offset/0x10000)	; 

;**********************************************************************
PROG		CODE					; program area
;**********************************************************************
;****	x/dd
initTemp
		global		initTemp
		movlw		low eOFST
		call		LongReadEEPROM	; Offsetl̓ǂݏo
		movff32		mWRK0, mOFST
		return

;**********************************************************************
;****	x␳lۑ
SetupTemp
		global		SetupTemp
		movff32		mOFST, mWRK0
		movlw		low eOFST
		call		LongWriteEEPROM	; Offsetl̏
		return

;**********************************************************************
;****	x␳l0.5Z
AddTemp
		global		AddTemp
		movff32		mOFST, m_A32
		movlf32		(Step*5), m_B32
		call		Add32			; ␳l
		movff32		m_A32, mOFST
		return

;**********************************************************************
;****	x␳l0.5Z
SubTemp
		global		SubTemp
		movff32		mOFST, m_A32
		movlf32		(Step*5), m_B32
		call		Sub32			; ␳l
		movff32		m_A32, mOFST
		return

;**********************************************************************
;****	x		(VDDɈˑ)
;****	߂l		: mWRK0(), mWRK1() 16rbg
GetTemp
		global		GetTemp
		banksel		FVRCON
		movlw		b'00100000'		; Temp ON, VDD-2Vt(Low Range)
		movwf		FVRCON
		banksel		ADCON0
		movlw		b'11010000'		; Right, Fosc/16, AVDD
		movwf		ADCON1
		movlw		b'01110100'		; select-Temp 
		movwf		ADCON0
		movlw		64
		movwf		mWRK0			; mWRK0 = 64
		clrw
		movwf32		m_A32			; m_A32 = 0
GetTemp_loop1
		bsf			ADCON0, ADON	; ADC ON
		clrf		mWRK1
		decfsz		mWRK1, F		; ANCW^C(192uS)
		bra			$-1
		bsf			ADCON0, ADGO	; ADC Jn
		btfsc		ADCON0, ADGO
		bra			$-1				; I҂[v
		bcf			ADCON0, ADON	; ADC OFF
		mov16f32	ADRESL, m_B32	; AiOl擾
		call		Add32			; Z
		decfsz		mWRK0, F		; 64(I[o[TvO)
		bra			GetTemp_loop1	; ((192uS+20uS)*64=14mS)
		clrf		ADCON0			; ADC OFF
		banksel		FVRCON
		clrf		FVRCON			; FVR OFF
		bank0						; oN0
		movlw		3
		movwf		mWRK0
GetTemp_loop2						; 64ZADCl
		lsrf		(m_A32+1), F	; ʂ0ɂ
		rrf			(m_A32+0), F	; 3bitEVtg
		decfsz		mWRK0, F		; ADC13bitɂȂ
		bra			GetTemp_loop2
		movlf32		10000, m_B32
		call		Mul32			; ADCl10000{ɂ
		movlf32		8191, m_B32		; n=13 : 2^13-1 = 8191
		call		Div32			; m_A32 = ADC/(2^n-1)
		movff32		m_A32, m_B32
		movlf32		10000, m_A32	; 110000{ɂĂ
		call		Sub32			; m_A32 = 1-(ADC/(2^n-1))
		mov16f32	m_VDD, m_B32	; VDD1000{Ȃ̂
		call		Mul32			; 5{VDD/2*10000ɂȂ
		movlf32		5, m_B32
		call		Mul32			; m_A32 = (VDD/2)*m_A32
		movff32		m_A32, m_B32	; ʂ m_B32ֈڂ
		movff32		mOFST, m_A32
		call		Sub32           ; m_A32 = 0.659-m_B32
		movlf32		Step, m_B32
		call		Div32			; m_A32 = m_A32/0.00132
		mov32f16	m_A32, mWRK0	; (x+40)*10̒l߂l
		return

;**********************************************************************
;****	dd
;****	߂l		: mWRK0(), mWRK1() 16rbg
GetVdd
		global		GetVdd
		banksel		FVRCON
		movlw		b'10000001'		; FVR ON, 1.024V 
		movwf		FVRCON
		banksel		ADCON0
		movlw		b'11010000'		; Right, Fosc/16, AVDD
		movwf		ADCON1
		movlw		b'01111101'		; select-FVR, ADC ON 
		movwf		ADCON0
		movlw		16
		movwf		mWRK0			; mWRK0 = 16
		clrw
		movwf32		m_A32			; m_A32 = 0
GetVdd_loop
		movlw		5
		movwf		mWRK1
		decfsz		mWRK1, F		; ANCW^C(3uS)
		bra			$-1
		bsf			ADCON0, ADGO	; ADC Jn
		btfsc		ADCON0, ADGO
		bra			$-1				; I҂[v
		mov16f32	ADRESL, m_B32	; AiOl擾
		call		Add32			; Z
		decfsz		mWRK0, F		; 16(I[o[TvO)
		bra			GetVdd_loop		; (400uS)
		clrf		ADCON0			; ADC OFF
		banksel		FVRCON
		clrf		FVRCON			; FVR OFF
		bank0						; oN0
		lsrf		(m_A32+1), F	; 16Z
		rrf			(m_A32+0), F	; ʂ0ɂ
		lsrf		(m_A32+1), F	; 2bitEVtg
		rrf			(m_A32+0), F	; 12bitADC
		movff32		m_A32, m_B32	; ʂ m_B32ֈڂ
		movlf32		4193280, m_A32	; 1.024V*(2^12-1)*1000
		call		Div32			; dlϊ
		mov32f16	m_A32, m_VDD	; dl*1000{
		movlf32		10, m_B32		;    
		call		Div32			; dl*100{
		mov32f16	m_A32, mWRK0	; ߂l
		return

;**********************************************************************
		end