;**********************************************************************
;****	SP521P LCD Display							쐬 2011/07/02
;****	t@C	: SP521P.asm						XV 2013/06/02
;****	AZu	: MPASM Ver5.41
;****	gPIC16pɐVK쐬
;**********************************************************************
#define		__SP521P_LCD_DISPLAY_
#include	"SP521P.inc"
#include	"calc32.inc"

;**********************************************************************
#define	FALSE	0
#define	TRUE	1
#define	bank0	movlb	0
#define	bank1	movlb	1

;**********************************************************************
;****	f[^WX^ (oN0)
DAT_VAR		UDATA

;****	SP521P f[^
mLCD0		res		1				; LCD0
mLCD1		res		1				; LCD1
mLCD2		res		1				; LCD2
mLCD3		res		1				; LCD3
mSDAT		res		1				; Shift Data
mSCNT		res		1				; Shift Count

;**********************************************************************
PROG		CODE					; program area
;**********************************************************************
;****	SP521P \
;**********************************************************************
;****	7ZO\ZOg
#define _A	b'10000000'
#define _B	b'01000000'
#define _C	b'00100000'
#define _D	b'00010000'
#define _E	b'00001000'
#define _F	b'00000100'
#define _G	b'00000010'
;****	7ZO\`
#define	FT0	_A+_B+_C+_D+_E+_F
#define	FT1	_B+_C
#define	FT2	_A+_B+_D+_E+_G
#define	FT3	_A+_B+_C+_D+_G
#define	FT4	_B+_C+_F+_G
#define	FT5	_A+_C+_D+_F+_G
#define	FT6	_A+_C+_D+_E+_F+_G
#define	FT7	_A+_B+_C
#define	FT8	_A+_B+_C+_D+_E+_F+_G
#define	FT9	_A+_B+_C+_D+_F+_G
#define	FTA	_A+_B+_C+_E+_F+_G
#define	FTb	_C+_D+_E+_F+_G
#define	FTC	_A+_D+_E+_F
#define	FTd	_B+_C+_D+_E+_G
#define	FTE	_A+_D+_E+_F+_G
#define	FTF	_A+_E+_F+_G
#define	FTP	_A+_B+_E+_F+_G
#define	FTBAR		_G

#define	COL_bit		mLCD0, 0
#define	LOBAT_bit	mLCD0, 1
#define	K_bit		mLCD0, 2
#define	PULS_bit	mLCD0, 3
#define	MINUS_bit	mLCD0, 4
#define	COM_bit		mLCD0, 5
#define	NC_bit		mLCD0, 6
#define	BP_bit		mLCD0, 7
#define BPLAIN		0x80

;**********************************************************************
;****	`f[^
;****			: W l(0-9,A-F)
_NumFont
		andlw	0x0F				; 0`15ɂ
		brw							; e[uWv
_disp_table
		retlw	FT0					; 0\f[^
		retlw	FT1					; 1\f[^
		retlw	FT2					; 2\f[^
		retlw	FT3					; 3\f[^
		retlw	FT4					; 4\f[^
		retlw	FT5					; 5\f[^
		retlw	FT6					; 6\f[^
		retlw	FT7					; 7\f[^
		retlw	FT8					; 8\f[^
		retlw	FT9					; 9\f[^
		retlw	FTA					; A\f[^
		retlw	FTb					; b\f[^
		retlw	FTC					; C\f[^
		retlw	FTd					; d\f[^
		retlw	FTE					; E\f[^
		retlw	FTF					; F\f[^

;**********************************************************************
;****	1/10Z (Z̑ւ)
;****			: W 鐔
;****	߂l	: mWRK0 1/10 / mWRK1 ]
_div10
		clrf	mWRK0
_div10_Check
		movwf	mWRK1
		sublw	9
		btfss	STATUS, C
		bra		_div10_dec			; 9傫Ƃ
		movf	mWRK0, W			; 1/10
		return
_div10_dec
		incf	mWRK0, F			; 
		movlw	10
		subwf	mWRK1, W			; ]
		bra		_div10_Check

;**********************************************************************
;****	LCD\ (ZOgf[^] / 荞)
;****			: W ZOgf[^
_LCD_Movement
		btfsc	BP_bit				; BP(obNv[)1甽]
		xorlw	0xFF				; _f[^ɕϊ
		movwf	mSDAT
		movlw	8
		movwf	mSCNT				; 8(1bit)[v
_LCD_Move_loop
		lslf	mSDAT, F			; f[^փVtg
		banksel	LATA				; oN؂芷
		btfsc	STATUS, C
		bsf		LATA, LCDDAT		; f[^rbg High
		btfss	STATUS, C
		bcf		LATA, LCDDAT		; f[^rbg Low
		nop
		bsf		LATA, LCDCLK		; ]NbN High
		nop
		bcf		LATA, LCDCLK		; ]NbN Low
		bank0						; oN0
		decfsz	mSCNT, F
		bra		_LCD_Move_loop
		return

;**********************************************************************
;****	LCD\ (ZOgf[^ / 荞)
_LCD_display
		movf	mLCD0, W
		call	_LCD_Movement
		movf	mLCD1, W
		call	_LCD_Movement
		movf	mLCD2, W
		call	_LCD_Movement
		movf	mLCD3, W
		call	_LCD_Movement
		banksel	LATA				; oN؂芷
		bsf		LATA, LCDLAH		; b`NbN High
		nop
		bcf		LATA, LCDLAH		; b`NbN Low
		bank0						; oN0
		bcf		STATUS, C
		btfsc	BP_bit				; BP(obNv[)̏
		bSf		STATUS, C			; C(L[) ֈڂ
		banksel	LATA				; oN؂芷
		btfsc	STATUS, C
		bsf		LATA, LCDDAT		; BP(obNv[)High ɂ
		btfss	STATUS, C
		bcf		LATA, LCDDAT		; BP(obNv[)Low ɂ
		bank0						; oN0
		return

;**********************************************************************
;****	\
;****			: W ̎` / mWRK0 l
;****	[N		: mWRK1
;****	߂l	: W V`
_disp_num
		andlw	0x01				; 悸̓NA
		movwf	mWRK1
		movf	mWRK0, W			; ߂
		sublw	9
		btfss	STATUS, C
		bra		_disp_num_exit		; \
		movf	mWRK0, W			; ߂
		call	_NumFont
		iorwf	mWRK1, F			; (0-9)
_disp_num_exit
		movf	mWRK1, W			; ߂
		return


;**********************************************************************
;****	SP521P
init_SP521P
		global	init_SP521P
		banksel	TRISA				; oN؂芷
		bcf		TRISA, LCDDAT		; f[^o
		bcf		TRISA, LCDCLK		; NbNo
		banksel	LATA				; oN؂芷
		bcf		LATA, LCDDAT		; f[^low
		bcf		LATA, LCDCLK		; NbNlow
		bank0						; oN0
		movlw	0x1F
		movwf	mLCD0				; 3bit'0'
		movlw	0xFF				; ͑S'1'
		movwf	mLCD1
		movwf	mLCD2
		movwf	mLCD3
		call	_LCD_display		; LCD\
		return

;**********************************************************************
;****	LCD\ (荞ݓŖ16mSɌĂяo)
SP521P_isr
		global	SP521P_isr
		movlw	BPLAIN				; Back plain
		xorwf	mLCD0, F			; BP_bit𔽓]
		call	_LCD_display		; LCD\(𗬓_)	
		return

;**********************************************************************
;****	S\NA
ClearDisp
		global	ClearDisp
		movlw	0xE0				; 3rbg͕ύXȂB
		andwf	mLCD0, F
		clrf	mLCD1
		clrf	mLCD2
		clrf	mLCD3
		return

;**********************************************************************
;****	\
;****			: mWRK0(), mWRK1() 16rbg / W _ʒu
;****	[N		: mWRK2
DispNum
		global		DispNum
		movwf		mWRK2
		mov16f32	mWRK0, m_A32
		movlf32		2000, m_B32
		call		Cmp32			; ő 1999 ܂
		btfsc		STATUS, C
		retlw		FALSE			; Num >= 2000
DispNum_3
		call		DispNum_set
		movwf		mLCD3			; V`
		mov32fw		m_A32
		btfss		STATUS, Z		; 0ȏȂ
		bra			DispNum_2		; \ɍs
		movlw		1
		subwf		mWRK2, W
		btfss		STATUS, C
		bra			DispNum_2clr	; \
DispNum_2
		call		DispNum_set
		movwf		mLCD2			; V`
		mov32fw		m_A32
		btfss		STATUS, Z		; 0ȏȂ
		bra			DispNum_1		; \ɍs
		movlw		2
		subwf		mWRK2, W
		btfss		STATUS, C
		bra			DispNum_1clr	; \
DispNum_1
		call		DispNum_set
		movwf		mLCD1			; V`
		mov32fw		m_A32
		btfss		STATUS, Z
		bsf			K_bit			; 1 
		btfsc		STATUS, Z
		bcf			K_bit			; 0 
DispNum_dot
		decf		mWRK2, F
		btfsc		STATUS, Z
		bsf			mLCD3, 0		; 1ڂɃhbg\
		btfss		STATUS, Z
		bcf			mLCD3, 0
		decf		mWRK2, F
		btfsc		STATUS, Z
		bsf			mLCD2, 0		; 2ڂɃhbg\
		btfss		STATUS, Z
		bcf			mLCD2, 0
		decf		mWRK2, F
		btfsc		STATUS, Z
		bsf			mLCD1, 0		; 3ڂɃhbg\
		btfss		STATUS, Z
		bcf			mLCD1, 0
		retlw		TRUE
DispNum_2clr
		clrf		mLCD2			;  NA
DispNum_1clr
		clrf		mLCD1			;  NA
		bcf			K_bit			;  NA
		bra			DispNum_dot
DispNum_set							; 
		movlf32		10, m_B32
		call		Div32			; 1/10
		mov32f8		m_B32, mWRK0	; ]擾
		clrw
		call		_disp_num		; `̎擾
		return

;**********************************************************************
;****	AM(ߑO)\
Disp_AM
		global	Disp_AM
		movlw	FTA
		movwf	mLCD3				; A 
		return

;**********************************************************************
;****	PM(ߌ)\
Disp_PM
		global	Disp_PM
		movlw	FTP
		movwf	mLCD3				; P 
		return

;**********************************************************************
;****	\
DispHourOFF
		global	DispHourOFF
		movlw	10
		movwf	mWRK0
		movf	mLCD1, W
		call	_disp_num
		movwf	mLCD1				;  NA
		bcf		K_bit				;  NA
		return

;**********************************************************************
;****	(b)\
DispMinuteOFF
DispSecondOFF
		global	DispMinuteOFF, DispSecondOFF
		movlw	10
		movwf	mWRK0
		movf	mLCD3, W
		call	_disp_num
		movwf	mLCD3				;  NA
		movlw	10
		movwf	mWRK0
		movf	mLCD2, W
		call	_disp_num
		movwf	mLCD2				;  NA
		return

;**********************************************************************
;****	\
;****			: W l
;****	[N		: mWRK0 / mWRK1
DispHour
		global	DispHour
		movwf	mWRK0
		sublw	23
		btfss	STATUS, C
		retlw	FALSE				; 23傫
		movlw	13
		subwf	mWRK0, W
		btfss	STATUS, C
		goto	DispHour_x0
		movlw	12
		subwf	mWRK0, F			; 24ԕ\12ԕ\
DispHour_x0
		movf	mWRK0, W
		call	_div10				; 1/10
		movf	mWRK0, F
		btfss	STATUS, Z
		bsf		K_bit				;  Zbg
		btfsc	STATUS, Z
		bcf		K_bit				;  NA
		movf	mWRK1, W
		movwf	mWRK0
		movf	mLCD1, W
		call	_disp_num			; 
		movwf	mLCD1
		retlw	TRUE

;**********************************************************************
;****	(b)\
;****			: W l
;****	[N		: mWRK0 / mWRK1 /mWRK3
DispMinute
DispSecond
		global	DispMinute, DispSecond
		movwf	mWRK0
		sublw	99
		btfss	STATUS, C
		retlw	FALSE				; 99(b)傫(2011/08/09)
		movf	mWRK0, W
		call	_div10				; 1/10
		movf	mWRK1, W
		movwf	mWRK3
		movf	mLCD2, W
		call	_disp_num			; 
		movwf	mLCD2
		movf	mWRK3, W
		movwf	mWRK0
		movf	mLCD3, W
		call	_disp_num			; 
		movwf	mLCD3
		retlw	TRUE

;**********************************************************************
;****	R̕\/\
;****			: W ON/OFF
DispColon
		global	DispColon
		sublw	TRUE
		btfss	STATUS, Z
		bcf		COL_bit				; \
		btfsc	STATUS, Z
		bsf		COL_bit				; \
		return

;**********************************************************************
;****	vX̕\/\
;****			: W ON/OFF
;****	[N		: mWRK0
DispPuls
		global	DispPuls
		movwf	mWRK0
		sublw	TRUE
		btfss	STATUS, Z
		bcf		PULS_bit			; \
		btfsc	STATUS, Z
		bsf		PULS_bit			; \
		movf	mWRK0, W
;		bra		DispMinus
		
;**********************************************************************
;****	}CiX̕\/\
;****			: W ON/OFF
DispMinus
		global	DispMinus
		sublw	TRUE
		btfss	STATUS, Z
		bcf		MINUS_bit			; \
		btfsc	STATUS, Z
		bsf		MINUS_bit			; \
		return

;**********************************************************************
;****	LOBAT̕\/\
;****			: W ON/OFF
DispLobat
		global	DispLobat
		sublw	TRUE
		btfss	STATUS, Z
		bcf		LOBAT_bit			; \
		btfsc	STATUS, Z
		bsf		LOBAT_bit			; \
		return

;**********************************************************************
;****	3ڂ̃o[\/\			; 2013/06/02 ǉ
;****			: W ON/OFF
DispBar
		global	DispBar
		clrf	mLCD1				; \
		sublw	TRUE
		btfss	STATUS, Z
		return
		movlw	FTBAR
		movwf	mLCD1				; \
		return

;**********************************************************************
		end

 
