;**********************************************************************
;****	Timrt1 A^CNbN							쐬 2011/07/02
;****	t@C	: Timer1RTC.asm						XV 2013/06/02
;****	AZu	: MPASM Ver5.41
;****	gPIC16pɐVK쐬
;**********************************************************************
#define		__TIMER1_REALTIMECLOCK_
#include	"Timer1RTC.inc"
#include	"calc32.inc"
#include	"pic_eeprom.inc"

;**********************************************************************
#define	FALSE	0
#define	TRUE	1
#define	bank0	movlb	0
#define	bank1	movlb	1

#define	COUNT	512					; 32.768kHz / 64
#define	RTCNT	(0x10000-COUNT)		; Timer1 Restart Count

;**********************************************************************
;****	f[^WX^ (oN0)
DAT_VAR		UDATA

;****	Timer1 f[^ (RTCJE^)
mMSEC	res		1					; TubJEg
mFSEC	res		1					; 0.5btO
mXSEC	res		1					; bJEg(0-59)
mXMIN	res		1					; JEg(0-59)
mXHOR	res		1					; JEg(0-23)
mXWEK	res		1					; TJEg(0-6)0:j-6:yj
mXDAY	res		1					; JEg(1-31)
mXMNT	res		1					; JEg(1-12)
mXYER	res		1					; NJEg(0-99)

mCOLN	res		1					; Ǐo 0.5btO
mSECD	res		1					; Ǐo bJEg(0-59)
mMINT	res		1					; Ǐo JEg(0-59)
mHOUR	res		1					; Ǐo JEg(0-23)
mWEEK	res		1					; Ǐo TJEg(0-6)
mDATE	res		1					; Ǐo JEg(1-31)
mMONT	res		1					; Ǐo JEg(1-12)
mYEAR	res		1					; Ǐo NJEg(0-99)

;****	ԕ␳ (2013/06/02ǉ)
mINVL	res		2					; 荞݊Ԋuf[^
mCMPR	res		2					; ␳f[^
mCCNT	res		1					; ␳pJEg

	global	mCOLN, mSECD, mMINT, mHOUR, mWEEK, mDATE, mMONT, mYEAR

;**********************************************************************
;****	EEPROM f[^
DEEPROM		CODE
eCMPR		de	low  RTCNT			; 
			de	high RTCNT			; 

;**********************************************************************
PROG			CODE				; program area
;**********************************************************************
;****	Timer1 A^CNbN
;**********************************************************************
;****	ꌎ̓
;****			: W l(1`12)
_Days
		andlw	0x0F				; 0`15ɂ
		brw							; e[uWv
_Days_table
		retlw	0					; 0
		retlw	31					; 1
		retlw	28					; 2
		retlw	31					; 3
		retlw	30					; 4
		retlw	31					; 5
		retlw	30					; 6
		retlw	31					; 7
		retlw	31					; 8
		retlw	30					; 9
		retlw	31					; 10
		retlw	30					; 11
		retlw	31					; 12
		retlw	0					; 13
		retlw	0					; 14
		retlw	0					; 15

;**********************************************************************
;***	
_write_times
		clrf	mMSEC				; 0
		movlw	FALSE
		movwf	mFSEC				; 0.5b
		movf	mSECD, W
		movwf	mXSEC				; b
		movf	mMINT, W
		movwf	mXMIN				; 
		movf	mHOUR, W
		movwf	mXHOR				; 
		return

;**********************************************************************
;***	
_write_days
		movf	mWEEK, W
		movwf	mXWEK				; T
		movf	mDATE, W
		movwf	mXDAY				; 
		movf	mMONT, W
		movwf	mXMNT				; 
		movf	mYEAR, W
		movwf	mXYER				; N
		return

;**********************************************************************
;****	JEg ( 邤N4N̂)
_inc_RTC
;****	second
		incf	mXSEC, F			; +1b
		movf	mXSEC, W
		sublw	59
		btfsc	STATUS, C
		return
		clrf	mXSEC				; 0b
;****	minute
		incf	mXMIN, F			; +1
		movf	mXMIN, W
		sublw	59
		btfsc	STATUS, C
		return
		clrf	mXMIN				; 0
;****	hour
		incf	mXHOR, F			; +1
		movf	mXHOR, W
		sublw	23
		btfsc	STATUS, C
		return
		clrf	mXHOR				; 0
;****	week
		incf	mXWEK, F			; +j
		movf	mXWEK, W
		sublw	7
		btfss	STATUS, C
		clrf	mXWEK				; j
;****	day							 -- (2011/08/09 tC) --
		incf	mXDAY, F			; +1
		movf	mXMNT, W			; W
		call	_Days				; J̖擾
		addlw	1					; 1𑫂ď
		subwf	mXDAY, W 			; (2011/08/09C)
		btfss	STATUS, C
		return						; ȊO͖߂
		movlw	2
		subwf	mXMNT, W			; 2?
		btfss	STATUS, Z
		bra		_clr_day			; 2ȊO͌ߏ
		movlw	0x03
		andwf	mXYER, W
		btfss	STATUS, Z
		bra		_clr_day			; 邤NȊO͌ߏ
		movlw	30					; 29+1
		subwf	mXDAY, W			; 邤?
		btfss	STATUS, Z
		return						; 28Ȃ߂
_clr_day
		clrf	mXDAY
		incf	mXDAY, F			; 1
;****	mont
		incf	mXMNT, F			; +1
		movf	mXMNT, W
		sublw	12					; 12?
		btfsc	STATUS, C
		return
		clrf	mXMNT
		incf	mXMNT, F			; 1
;****	year
		incf	mXYER, F			; +1N
		movf	mXYER, W
		sublw	100					; 100N?
		btfsc	STATUS, Z			; -- (2013/01/21 C)
		clrf	mXYER				; 00N
		return						; -- (ȂC܂B) --


;**********************************************************************
;****	^C}1 (RTCl)
init_Timer1
		global	init_Timer1
;****	␳ǉ (2013/06/02)
		movlw	eCMPR
		call	WordReadEEPROM
		movff16	mWRK0, mCMPR		; ␳f[^ǂݏo
		clrf	mCCNT				; ␳JE^̏
		movlw	high RTCNT
		movwf	(mINVL+1)
		clrf	(mINVL+0)			; 荞݊Ԋuf[^l
init_TMR1
		movwf	TMR1H
		clrf	TMR1L				; TMR1 = 荞݊Ԋuf[^
		movlw	b'10001101'
		movwf	T1CON				; 32.768kHz / 1:1Pre / ON
init_Timer1_rtc
		clrf	mMSEC				; 0
		movlw	FALSE
		movwf	mFSEC				; 0.5b
		; knmnk({W)
		movlw	18
		movwf	mXSEC				; 18b
		movlw	46
		movwf	mXMIN				; 46
		movlw	14
		movwf	mXHOR				; 14
		movlw	5
		movwf	mXWEK				; j
		movlw	11
		movwf	mXDAY				; 11
		movlw	3
		movwf	mXMNT				; 3
		movlw	11
		movwf	mXYER				; 11N (2011N)
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		banksel	PIR1
		bcf		PIR1, TMR1IF		; Timer1 荞݃tONA
		bank0
		bsf		INTCON, PEIE		; ӊ荞݋
		return
		
;**********************************************************************
;****	^C}1荞
Timer1_isr
		global	Timer1_isr
		movf	(mINVL+1), W
		movwf	TMR1H				; Timer1HZbg
		movf	(mINVL+0), W
		movwf	TMR1L				; Timer1LZbg
		bcf		PIR1, TMR1IF		; Timer1 荞݃tONA

		movlw	high RTCNT			; 0.015625b荞ݐݒ
		movwf	(mINVL+1)
		clrf	(mINVL+0)			; 񊄂荞݊Ԋuf[^

		incf	mMSEC, F
		movlw	32
		subwf	mMSEC, W
		btfss	STATUS, C
		return						; 0.5b
		clrf	mMSEC
		movlw	0x01
		xorwf	mFSEC, F			; 0.5btO]
		btfss	STATUS, Z
		return						; 1b
		call	_inc_RTC			; 1bJEg
;****	␳ǉ						; 2013/06/02
		incf	mCCNT, F
		movlw	90					; 90b(1960␳)
		subwf	mCCNT, W
		btfss	STATUS, Z
		return 						; 90b
		clrf	mCCNT				; JEgNA
		movf	(mCMPR+1), W
		movwf	(mINVL+1)
		movf	(mCMPR+0), W
		movwf	(mINVL+0)			; 񊄂荞݊Ԋuf[^(␳l)
		return
		
;**********************************************************************
;****	iݕ␳(JnJEg炵Ēx点)	; 2013/06/06 ύX
Progress_Comp
		global	Progress_Comp
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		movlw	1					; -1(11/32.768kHz*960=0.029b)
		subwf	(mCMPR+0), F
		movlw	0
		subwfb	(mCMPR+1), F		; (g)
		movlw	(high RTCNT)-1		; 0xFD
		subwf	(mCMPR+1), W
		btfss	STATUS, Z
		bra		Progress_Comp_exit
		movlw	0x9C				; -100
		subwf	(mCMPR+0), W
		btfsc	STATUS, Z
		incf	(mCMPR+0), F		; Min 0xFD9D
Progress_Comp_exit
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
;****	x␳ (JnJEg𑝂₵Đi܂	; 2013/06/06 ύX
Dlay_Comp
		global	Dlay_Comp
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		movlw	1					; +1(11/32.768kHz*960=0.029b)
		addwf	(mCMPR+0), F
		movlw	0
		addwfc	(mCMPR+1), F		; (g)
		movlw	high RTCNT			; 0xFE
		subwf	(mCMPR+1), W
		btfss	STATUS, Z
		bra		Dlay_Comp_exit
		movlw	0x64				; +100
		subwf	(mCMPR+0), W
		btfsc	STATUS, Z
		decf	(mCMPR+0), F		; Max 0xFE63
Dlay_Comp_exit
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
;****	␳l̓ǂݏo					; 2013/06/02 ǉ
Get_Comper
		global	Get_Comper
		movf	(mCMPR+0), W
		return

;**********************************************************************
;****	␳l̏					; 2013/06/06 ǉ
Write_Comper
		global	Write_Comper
		movff16	mCMPR, mWRK0
		movlw	eCMPR
		call	WordWriteEEPROM
		return

;**********************************************************************
;****	Ǐo
;****	߂l	: mCOLN, mSECD, mMINT, mHOUR, mWEEK, mDATE, mMONT, mYEAR
Read_RTC
		global	Read_RTC
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		movf	mFSEC, W
		movwf	mCOLN				; 0.5b
		movf	mXSEC, W
		movwf	mSECD				; b
		movf	mXMIN, W
		movwf	mMINT				; 
		movf	mXHOR, W
		movwf	mHOUR				; 
		movf	mXWEK, W
		movwf	mWEEK				; T
		movf	mXDAY, W
		movwf	mDATE				; 
		movf	mXMNT, W
		movwf	mMONT				; 
		movf	mXYER, W
		movwf	mYEAR				; N
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
;****	RTCݒ
;****			: mSECD, mMINT, mHOUR, mWEEK, mDATE, mMONT, mYEAR
Write_RTC
		global	Write_RTC
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		call	_write_times
		call	_write_days
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
;****	ݒ
;****			: mSECD, mMINT, mHOUR
Write_Times
		global	Write_Times
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		call	_write_times
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
;****	ݒ
;****			: mWEEK, mDATE, mMONT, mYEAR
Write_Days
		global	Write_Days
		banksel	PIE1
		bcf		PIE1, TMR1IE		; Timer1 荞݋֎~
		bank0
		call	_write_days
		banksel	PIE1
		bsf		PIE1, TMR1IE		; Timer1 荞݋
		bank0
		return

;**********************************************************************
		end