;**********************************************************************
;****	PICEEPROM vO						쐬 2011/07/12
;****	t@C	: pic_eeprom.asm					XV 2011/07/12
;****	AZu	: MPASM Ver5.41
;****	gPIC16pɐVK쐬
;**********************************************************************
#define		__PIC_INTERNAL_EEPROM_
#include	"pic_eeprom.inc"

;**********************************************************************
#define	FALSE	0
#define	TRUE	1
#define	bank0	movlb	0
#define	bank1	movlb	1

;**********************************************************************
PROG		CODE					; program area
;**********************************************************************
;****	EEPROM Long Ǐo
;****			: W = EEPROM Address
;****	߂l	: mWRK0() - mWRK3() = EEPROM Data
LongReadEEPROM
		global	LongReadEEPROM
		call	ReadEEPROM
		movwf	mWRK0
		banksel	EEADRL
		call	NextReadEEPROM
		movwf	mWRK1
		banksel	EEADRL
		call	NextReadEEPROM
		movwf	mWRK2
		banksel	EEADRL
		call	NextReadEEPROM
		movwf	mWRK3
		return

;**********************************************************************
;****	EEPROM Long 
;****			: W = EEPROM Address : mWRK0() - mWRK3() = EEPROM Data
LongWriteEEPROM
		global	LongWriteEEPROM
		call	WriteEEPROM
		banksel	EEADRL
		movf	mWRK1, W
		call	NextWriteEEPROM
		banksel	EEADRL
		movf	mWRK2, W
		call	NextWriteEEPROM
		banksel	EEADRL
		movf	mWRK3, W
		call	NextWriteEEPROM
		return

;**********************************************************************
;****	EEPROM Word Ǐo
;****			: W = EEPROM Address
;****	߂l	: mWRK0()/mWRK1() = EEPROM Data
WordReadEEPROM
		global	WordReadEEPROM
		call	ReadEEPROM
		movwf	mWRK0
		banksel	EEADRL
		call	NextReadEEPROM
		movwf	mWRK1
		return

;**********************************************************************
;****	EEPROM Word 
;****			: W = EEPROM Address : mWRK0()/mWRK1() = EEPROM Data
WordWriteEEPROM
		global	WordWriteEEPROM
		call	WriteEEPROM
		banksel	EEADRL
		movf	mWRK1, W
		call	NextWriteEEPROM
		return

;**********************************************************************
;****	EEPROM Byte Ǐo
;****			: W = EEPROM Address
;****	߂l	: W = EEPROM Data
ReadEEPROM
		global	ReadEEPROM
		banksel	EEADRL
		movwf	EEADRL				; Data Memory Address
NextReadEEPROM
		bcf		EECON1, CFGS		; Deselect Config space
		bcf		EECON1, EEPGD		; Point to DATA memory
		bsf		EECON1, RD			; EE Read
		movf	EEDATL, W			; W = EEDATL
		incf	EEADRL, F			; Data Memory Address +1
		bank0
		return

;**********************************************************************
;****	EEPROM Byte 
;****			: W = EEPROM Address : mWRK0 = EEPROM Data
WriteEEPROM
		global	WriteEEPROM
		banksel	EEADRL
		movwf	EEADRL				; Data Memory Address
		movf	mWRK0, W
NextWriteEEPROM
		movwf	EEDATL				; Data Memory Value to write
		bcf		EECON1, CFGS		; Deselect Config space
		bcf		EECON1, EEPGD		; Point to DATA memory
		bsf		EECON1, WREN		; Enable writes
		movf	INTCON, W
		movwf	mWRK0				; Strore Interrupts
		bcf		INTCON, GIE			; Disable INTs.
		movlw	0x55
		movwf	EECON2				; Write 0x55	
		movlw	0x0AA
		movwf	EECON2				; Write 0xAA
		bsf		EECON1, WR			; Set WR bit to begin write
		btfsc	mWRK0, GIE
		bsf		INTCON, GIE			; Restore Interrupts
		bcf		EECON1, WREN		; Disable writes
		btfsc	EECON1, WR			; Wait for write to complete
		bra		$-2					; Done
		incf	EEADRL, F			; Data Memory Address +1
		bank0
		return

;**********************************************************************
		end