/*******************************************************************
 PIC12F1288 Timrt1 Real Time Clock			Create Date	2011/06/21
 file name	: timrt1rtcp.c					Last UpDate	2011/06/26
 Complier   : HI-TECH C Ver 9.82

 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include "timer1rtc.h"

/** Define *********************************************************/
#if   defined(INTFRQ1)
	#define INTFRQ	1			// 1b1񊄂荞
#elif defined(INTFRQ2)
	#define INTFRQ	2			// 1b2񊄂荞
#elif defined(INTFRQ4)
	#define INTFRQ	4			// 1b4񊄂荞
	#define	USE_MSEC
#elif defined(INTFRQ8)
	#define INTFRQ	8			// 1b8񊄂荞
	#define	USE_MSEC
#elif defined(INTFRQ16)
	#define INTFRQ	16			// 1b16񊄂荞
	#define	USE_MSEC
#elif defined(INTFRQ32)
	#define INTFRQ	32			// 1b32񊄂荞
	#define	USE_MSEC
#elif defined(INTFRQ64)
	#define INTFRQ	64			// 1b64񊄂荞
	#define	USE_MSEC
#endif

/** Variables ******************************************************/
struct RTCDATA RTC;				// f[^
#if defined(USE_MSEC)
unsigned char msec;				// ~b(荞݂̃JEg)	
#endif
#if defined(RTC_FULL_MODE)
const static unsigned char Days[] =	// Ђƌ̓
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
#endif

/** Private Function ***********************************************/
// JEg ( 邤N4N̂)
static void _inc_RTC(void)
{
	if (++RTC.second < 60) return;
	RTC.second = 0;
	if (++RTC.minute < 60) return;
	RTC.minute = 0;
	if (++RTC.hour < 24) return;
	RTC.hour = 0;
#if defined(RTC_FULL_MODE)
	if (++RTC.week >= 7) RTC.week = 0;
	if(++RTC.date <= Days[RTC.mont]) return;
	if (RTC.mont == 2&&(RTC.year&0x03)==0) return;	// 邤N
	else RTC.date = 1;
	if (++RTC.mont <= 12) return;
	RTC.mont = 1;
	RTC.year++;
#endif
}

/** Function *******************************************************/
// ^C}[1 (RTCl)
void init_Timer1(void)
{
	TMR1H = 0xFF;
	TMR1L = 0x00;
	T1CON = 0b10001101;
#if defined(USE_MSEC)
	msec = 0;
#endif
	RTC.colon = TRUE;
	// knmnk({W)
	RTC.second = 18;
	RTC.minute = 46;
	RTC.hour   = 14;
#if defined(RTC_FULL_MODE)
	RTC.week   = 5;
	RTC.date   = 11;			// 
	RTC.mont   = 3;				// Ă(2011/06/30)
	RTC.year   = 2011;
#endif
	PIE1bits.TMR1IE = 1;
	PIR1bits.TMR1IF = 0;
	INTCONbits.PEIE = 1;
}
/*******************************************************************/
// ^C}[1荞
void Timer1_isr(void)
{
#if   defined(INTFRQ1)
	TMR1H |= 0x80;				// 1b荞ݍĐݒ
#elif defined(INTFRQ2)
	TMR1H |= 0xC0;				// 0.5b荞ݍĐݒ
#elif defined(INTFRQ4)
	TMR1H |= 0xE0;				// 0.25b荞ݍĐݒ
#elif defined(INTFRQ8)
	TMR1H |= 0xF0;				// 0.125b荞ݍĐݒ
#elif defined(INTFRQ16)
	TMR1H |= 0xF8;				// 0.0625b荞ݍĐݒ
#elif defined(INTFRQ32)
	TMR1H |= 0xFC;				// 0.03125b荞ݍĐݒ
#elif defined(INTFRQ64)
	TMR1H |= 0xFE;				// 0.015625b荞ݍĐݒ
#endif
// 荞݃tONA
	PIR1bits.TMR1IF = 0;
// 1bԊu
#if   defined(INTFRQ1)
	RTC.colon = TRUE; 
	_inc_RTC();
// 0.5bԊu
#elif defined(INTFRQ2)
	RTC.colon = !RTC.colon;
	if (RTC.colon) _inc_RTC();
// 0.5bԊu
#else
	if (++msec >=(INTFRQ/2)) {
		msec = 0;
		RTC.colon = !RTC.colon;
		if (RTC.colon) _inc_RTC();
	}
#endif
}
/*******************************************************************/
// Ǐo
void Read_RTC(struct RTCDATA *rtc)
{
	PIE1bits.TMR1IE = 0;		// 荞݋֎~
	rtc->colon  = RTC.colon;
	rtc->second = RTC.second;
	rtc->minute = RTC.minute;
	rtc->hour   = RTC.hour;
#if defined(RTC_FULL_MODE)
	rtc->week   = RTC.week;
	rtc->date   = RTC.date;
	rtc->mont   = RTC.mont;
	rtc->year   = RTC.year;
#endif
	PIE1bits.TMR1IE = 1;		// 荞݊Jn
}
/*******************************************************************/
// ݒ
void Write_RTC(struct RTCDATA *rtc)
{
	PIE1bits.TMR1IE = 0;		// 荞݋֎~
#if defined(USE_MSEC)
	msec = 0;
#endif
	RTC.colon  = TRUE;
	RTC.second = rtc->second;
	RTC.minute = rtc->minute;
	RTC.hour   = rtc->hour;
#if defined(RTC_FULL_MODE)
	RTC.week   = rtc->week;
	RTC.date   = rtc->date;
	RTC.mont   = rtc->mont;
	RTC.year   = rtc->year;
#endif
	PIE1bits.TMR1IE = 1;		// 荞݊Jn
}
/*******************************************************************/
// b킹
void Adjust_RTC(void)
{
	PIE1bits.TMR1IE = 0;		// 荞݋֎~
#if defined(USE_MSEC)
	msec =0;
#endif
	RTC.colon  = TRUE;
	if (RTC.second < 30) {
		RTC.second = 0;			// 0b`29b
	}
	else {
		RTC.second = 59;		// 30b`59b
		_inc_RTC();
	}		
	PIE1bits.TMR1IE = 1;		// 荞݊Jn
}
/**	end of file	****************************************************/