/*******************************************************************
 PIC12F1288 LCD SP521P display				Create Date	2011/06/21
 file name	: sp521p.c						Last UpDate	2011/06/26
 Complier   : HI-TECH C Ver 9.82
 LCD driver : 74HC595(8-bit Shift Register/Latch)*4

 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include "sp521p.h"

/** Define *********************************************************/
// 7ZO\ZOg
#define _A	0b10000000
#define _B	0b01000000
#define _C	0b00100000
#define _D	0b00010000
#define _E	0b00001000
#define _F	0b00000100
#define _G	0b00000010
// 7ZO\`
#define	FT0	_A+_B+_C+_D+_E+_F
#define	FT1	_B+_C
#define	FT2	_A+_B+_D+_E+_G
#define	FT3	_A+_B+_C+_D+_G
#define	FT4	_B+_C+_F+_G
#define	FT5	_A+_C+_D+_F+_G
#define	FT6	_A+_C+_D+_E+_F+_G
#define	FT7	_A+_B+_C
#define	FT8	_A+_B+_C+_D+_E+_F+_G
#define	FT9	_A+_B+_C+_D+_F+_G

/** Variables ******************************************************/
// `f[^
static unsigned char _NumFont[] =
	{ FT0, FT1, FT2, FT3, FT4, FT5, FT6, FT7, FT8, FT9};
// LCDZOgf[^(LCD0)
union _LCD0 {
	unsigned char  byte;
	struct {
		unsigned	COL		: 1;
		unsigned	LOBAT	: 1;
		unsigned	K		: 1;
		unsigned	PULS	: 1;
		unsigned	MINUS	: 1;
		unsigned	com		: 1;
	} bits;
};
// LCDZOgf[^(LCD1`3)
union _LCDx {
	unsigned char  byte;
	struct {
		unsigned	DP		: 1;
		unsigned	G		: 1;
		unsigned	F		: 1;
		unsigned	E		: 1;
		unsigned	D		: 1;
		unsigned	C		: 1;
		unsigned	B		: 1;
		unsigned	A		: 1;
	} bits;
};
union	_LCD0 LCD0;
union	_LCDx LCD1, LCD2, LCD3;

/** Private Function ***********************************************/
// 1/10Z (Z̑ւ)
int  _div10(int *s)
{
	int d = 0;
	while (*s >= 10) {
		d++;
		*s -= 10;
	}
	return d;
}

/*******************************************************************/
// LCD\ (ZOgf[^])
void _LCD_Movement(unsigned char dat)
{
	int i;
	if (LCD0.bits.com) dat = ~dat;		// _f[^ɕϊ
	for (i=0; i<8; i++) {
		if (0x80 & dat)	LCDDAT = 1;		// f[^rbg High
		else			LCDDAT = 0;		// f[^rbg Low
		dat =  dat << 1;
		LCDCLK = 1;						// ]NbN High
		LCDCLK = 0;						// ]NbN Low
	}
}

/*******************************************************************/
// LCD\ (ZOgf[^)
void _LCD_display(void)
{
	_LCD_Movement(LCD0.byte);
	_LCD_Movement(LCD1.byte);
	_LCD_Movement(LCD2.byte);
	_LCD_Movement(LCD3.byte);
	LCDLAH = 1;							// b`NbN High
	LCDLAH = 0;							// b`NbN Low
	if (LCD0.bits.com)	LCDDAT = 1;		// common High
	else				LCDDAT = 0;		// common Low
}

/*******************************************************************/
// \()
void _disp_num(int n, unsigned char * lcdseg)
{
	*lcdseg &= 0x01;				// 悸̓NA
	if (0<=n && n <=9)
		*lcdseg |= _NumFont[n];		// `(2011/6/30)
}

/** Function *******************************************************/
// SP521P
void init_SP521P(void)
{
	LCDPIN();
	LCDCLK = 0;
	LCDDAT = 0;
	LCD0.byte = 0xFF;
	LCD1.byte = 0xFF;
	LCD2.byte = 0xFF;
	LCD3.byte = 0xFF;
	_LCD_display();
}

/*******************************************************************/
// LCD\ (荞ݓŖ16mSɌĂяo)
void SP521P_isr(void)
{
	LCD0.bits.com = !LCD0.bits.com; // 𗬓_
	_LCD_display();
}

/*******************************************************************/
// S\NA
void ClearDisp(void)
{
	LCD0.byte &= 0xE0;
	LCD1.byte  = 0;
	LCD2.byte  = 0;
	LCD3.byte  = 0;
}

/*******************************************************************/
// \
BOOL DispNum(int num, BOOL zero)
{
	int s, d;
	if (num>1999) return FALSE;
	s = num;
	d = _div10(&s);
					_disp_num( s, &LCD3.byte);
	s = num = d;
	d = _div10(&s);
	if (num>0)		_disp_num( s, &LCD2.byte);
	else if (zero)	_disp_num( 0, &LCD2.byte);
	else			_disp_num(10, &LCD2.byte);
	s = num = d;
	d = _div10(&s);
	if (num>0)		_disp_num( s, &LCD1.byte);
	else if (zero)	_disp_num( 0, &LCD1.byte);
	else			_disp_num(10, &LCD1.byte);
	s = num = d;
	d = _div10(&s);
	if (d)	LCD0.bits.K = 1;
	else	LCD0.bits.K = 0;
	return TRUE;
}

/*******************************************************************/
// _\
void DispDot(int dot)
{
	if (dot==1)	LCD1.bits.DP = 1;
	else		LCD1.bits.DP = 0;
	if (dot==2)	LCD2.bits.DP = 1;
	else		LCD2.bits.DP = 0;
	if (dot==3)	LCD3.bits.DP = 1;
	else		LCD3.bits.DP = 0;
}

/*******************************************************************/
// \
void DispHourOFF(void)
{
	_disp_num(10, &LCD1.byte);
	LCD0.bits.K = 0;
}

/*******************************************************************/
// (b)\
void DispMinuteOFF(void)
{
	_disp_num(10, &LCD3.byte);
	_disp_num(10, &LCD2.byte);
}

/*******************************************************************/
// \
BOOL DispHour(int hour)
{
	int s;
	if (hour>23) return FALSE;
	if (hour>12) hour -= 12;
	s = hour;
	_div10(&s);
	_disp_num(s, &LCD1.byte);
	if (hour>9) LCD0.bits.K = 1;
	else		LCD0.bits.K = 0;
	return TRUE;
}

/*******************************************************************/
// (b)\
BOOL DispMinute(int min)
{
	int d, s = min;
	if (min>59) return FALSE;
	d= _div10(&s);
	_disp_num(s, &LCD3.byte);
	_disp_num(d, &LCD2.byte);
	return TRUE;
}

/*******************************************************************/
// R̕\/\
void DispColon(BOOL on)
{
	if (on) LCD0.bits.COL = 1;
	else	LCD0.bits.COL = 0;
}

/*******************************************************************/
// }CiX̕\/\
void DispMinus(BOOL on)
{
	if (on) LCD0.bits.MINUS = 1;
	else	LCD0.bits.MINUS = 0;
}

/*******************************************************************/
// vX̕\/\
void DispPuls(BOOL on)
{
	if (on) LCD0.bits.PULS = 1;
	else	LCD0.bits.PULS = 0;
	DispMinus(on);
}

/*******************************************************************/
// LOBAT̕\/\
void DispLOBAT(BOOL on)
{
	if (on) LCD0.bits.LOBAT = 1;
	else	LCD0.bits.LOBAT = 0;
}

/**	end of file	****************************************************/