/*******************************************************************
 PIC12F1288 LowBattery Check				Create Date	2011/06/24
 file name	: lowbattery.c					Last UpDate	2011/06/26
 Complier   : HI-TECH C Ver 9.82

 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include "lowbattery.h"

/** Define *********************************************************/
// d̃f[^
#if   defined(LOW2_02V)
	#define LOWVOLT	519		/* 1.024V/(2.02V/1024)	*/
#elif defined(LOW2_00V)
	#define LOWVOLT	524		/* 1.024V/(2.00V/1024)	*/
#elif defined(LOW1_98V)
	#define LOWVOLT	530		/* 1.024V/(1.98V/1024)	*/
#elif defined(LOW1_95V)
	#define LOWVOLT	538		/* 1.024V/(1.95V/1024)	*/
#endif

/** Variables ******************************************************/
static int ltv;

/** Function *******************************************************/
BOOL LowBattery(void)
{
	int adc;
	BOOL r = FALSE;
	FVRCONbits.FVREN = 1;			// FVR ON
	FVRCONbits.ADFVR = 1;			// ADCFVR 1.024V
	ADCON1 = 0b11010000;			// Right: Fosc/16: AVDD
	ADCON0bits.CHS = 0b11111;		// FVR 1.024V
	ADCON0bits.ADON = 1;			// ADC ON
	NOP();
	NOP();
	ADCON0bits.GO = 1;				// ADC GO
	while (ADCON0bits.nDONE) continue;
	adc = ADRES;
	ADCON0bits.ADON = 0;			// ADC OFF
	FVRCONbits.FVREN = 0;			// FVR OFF
	FVRCONbits.ADFVR = 0;			// ADCFVR OFF
	if (adc<=ltv && ltv>LOWVOLT) r = TRUE;
	ltv = adc; 
	return r;
}

/**	end of file	****************************************************/