/*******************************************************************
 pic-logger for 12F1822						Create Date	2011/06/21
 file name	: logger.c						Last UpDate	2011/06/30
 Complier   : HI-TECH C Ver 9.82
 
 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include "GenericTypeDefs.h"
#include "timer1rtc.h"
#include "SP521P.h"
#include "lowbattery.h"

/** Configuration **************************************************/
__CONFIG(FOSC_INTOSC & WDTE_OFF & PWRTE_ON & MCLRE_OFF & BOREN_ON);
__CONFIG(LVP_OFF & PLLEN_OFF);

/** Define *********************************************************/
#define VER		"0.81"			/* t@[EFA o[V */

/** Variables ******************************************************/
unsigned char SWs, LESW;

/** Private Function ***********************************************/
// 16MHz
void osc_16mhz(void)
{								// VDD <= 2.5V
	OSCCONbits.SPLLEN = 0;		// 4xPLL OFF
	OSCCONbits.IRCF = 0b1111;	// 16MHz 
	OSCCONbits.SCS = 0b10;		// internal oscillator
}

/*******************************************************************/
// XCb`͏
void InputSwtich(void)
{
	unsigned char inp;
	inp = PORTA;
	if (!(inp&0x04) && !(LESW&0x04))	SWs |= 0x01;
	else 								SWs &= 0xFE;
	if (!(inp&0x08) && !(LESW&0x08))	SWs |= 0x02;
	else 								SWs &= 0xFD;
	LESW = inp;
}

/*******************************************************************/
// p[_E(L[܂)
void powerdown(void)
{
	InputSwtich();				// XCb`̎擾
	SLEEP();					// X[v
}

/*******************************************************************/
// \(p)
void _showhour(unsigned char hour)
{
	DispColon(FALSE);
	DispDot(0);
	DispMinuteOFF();
	DispHour(hour);
}

/*******************************************************************/
// \(p)
void _showminute(unsigned char minute)
{
	DispColon(FALSE);
	DispDot(0);
	DispHourOFF();
	DispMinute(minute);
}

/*******************************************************************/
// b\(p)
void _showsecond(unsigned char second)
{
	DispColon(TRUE);
	DispDot(0);
	DispHourOFF();
	DispMinute(second);
}

/*******************************************************************/
// p
void SetTime(void)
{
	struct RTCDATA rtc;
	int mode = 0;
	BOOL check = FALSE;
	unsigned char ltsw;
	Read_RTC(&rtc);
	ltsw = SWs;
	_showhour(rtc.hour);
	while (1) {
		if (SWs&0x01 && !(ltsw&0x01)) {	// XCb`1
			check = TRUE;
			if (mode==0) {				// 
				if (++rtc.hour>23) rtc.hour=0;	
				_showhour(rtc.hour);
			}
			else if (mode==1) {			// 
				if (++rtc.minute>59) rtc.minute=0;
				_showminute(rtc.minute);
			}
			else if (mode==2) {			// b
				if (++rtc.second>59) rtc.second=0;
				_showsecond(rtc.second);
			}
		}
		if (SWs&0x02 && !(ltsw&0x02)) {	// XCb`2
			if (++mode>=3) break;
			else if (mode==2) _showsecond(rtc.second);
			else if (mode==1) _showminute(rtc.minute);
		}
		ltsw = SWs;
		powerdown();			// XCb`̓͑҂
	}
	if (check) {
		rtc.colon = TRUE;
		Write_RTC(&rtc);
	}
	while (SWs) powerdown();	// XCb`ꂽƂ҂
}

/*******************************************************************/
// \
void showclock(void)
{
	struct RTCDATA rtc;
	Read_RTC(&rtc);
	if (SWs&0x01) {					// XCb`1ꂽ
		DispHourOFF();
		DispMinute(rtc.second);		// b\
	}
	else {
		DispHour(rtc.hour);			// \
		DispMinute(rtc.minute);		// \
	}
	DispColon(rtc.colon);
	if (SWs&0x02) SetTime();		// XCb`2ꂽ
}

/*******************************************************************/
// 荞݋N҂ (32.768kHz̈蔭U܂)
void Waiting(void)
{
	int i, t;
	for (i=0; i<2000; i++) {
		for (t=0; t<50; t++) NOP();
		SP521P_isr();			// LCDN\
	}
	ClearDisp();				// LCD\NA
}

/*******************************************************************/
// [obe\
void showLOBAT(void)
{
	DispLOBAT(LowBattery());	// dĎ
}

/** Function *******************************************************/
// C
void main(void)
{
	osc_16mhz();				// 16MHz
	init_SP521P();				// LCD
	init_Timer1();				// A^CNbN(Timer1)̏
	ANSELA = 0;					// fW^͐ݒ
	InputSwtich();				// XCb`̏
	INTCONbits.GIE = 1;			// 荞݊Jn
	Waiting();					// 荞݋N҂
	while (1) {
		showclock();			// v\
		showLOBAT();			// [obe\
		powerdown();			// X[v
	}
}

/*******************************************************************/
// 荞ݏ
interrupt void Interrupt(void)
{
	if (PIR1bits.TMR1IF) {
		Timer1_isr();			// A^C̊荞ݏ
		SP521P_isr();			// LCD\
	}
}

/**	end of file	****************************************************/