#include <p18cxxx.h>
#include "eeprom.h"

/********************************************************************
* eeprom ǂݏo
********************************************************************/
#if defined (EEP_V1)		//	128 byte EEPROM
unsigned char Read_eeprom( unsigned int badd )
{
	EEADR = (badd & 0x07f);
	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.RD = 1;
	Nop();					// Nop may be required for latency at high frequencies
	Nop();					// Nop may be required for latency at high frequencies
	return ( EEDATA );		// return with read byte 
}

#elif defined (EEP_V2)		// 256 byte EEPROM
unsigned char Read_eeprom( unsigned int badd )
{
	EEADR = (badd & 0x0ff);
	EECON1bits.EEPGD = 0;
  	EECON1bits.CFGS = 0;
	EECON1bits.RD = 1;
	Nop();					// Nop may be required for latency at high frequencies
	Nop();					// Nop may be required for latency at high frequencies
	return ( EEDATA );		// return with read byte
}

#elif defined (EEP_V3)		// 1024 byte EEPROM	
unsigned char Read_eeprom( unsigned int badd )
{
	EEADRH = (badd >> 8) & 0x03;
	EEADR = (badd & 0x0ff);
	EECON1bits.EEPGD = 0;
  	EECON1bits.CFGS = 0;
	EECON1bits.RD = 1;
	Nop();					// Nop may be required for latency at high frequencies
	Nop();					// Nop may be required for latency at high frequencies
	return ( EEDATA );		// return with read byte 
}
#endif

/********************************************************************
* 2x荞ݑΉ eeprom ݏ
********************************************************************/
#if defined (EEP_V1)		// 128 byte EEPROM
void Write_eeprom( unsigned int badd,unsigned char bdata )
{
	unsigned char oldIntcon;
	oldIntcon = INTCON;
	EEADR = (badd & 0x07f);
	EEDATA = bdata;
  	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.WREN = 1;
	INTCON = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	while(EECON1bits.WR);	// Wait till the write completion
	INTCON = oldIntcon;
	EECON1bits.WREN = 0;
}

#elif defined (EEP_V2)		// 256 byte EEPROM
void Write_eeprom( unsigned int badd,unsigned char bdata )
{
	unsigned char oldIntcon;
	oldIntcon = INTCON;
	EEADR = (badd & 0x0ff);
  	EEDATA = bdata;
  	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.WREN = 1;
	INTCON = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	while(EECON1bits.WR);	//Wait till the write completion
	INTCON = oldIntcon;
	EECON1bits.WREN = 0;
}

#elif defined (EEP_V3)		// 1024 byte EEPROM	
void Write_eeprom( unsigned int badd,unsigned char bdata )
{
	unsigned char oldIntcon;
	oldIntcon = INTCON;
	EEADRH = (badd >> 8) & 0x03;
	EEADR = (badd & 0x0ff);
	EEDATA = bdata;
  	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.WREN = 1;
	INTCON = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	while(EECON1bits.WR);	//Wait till the write completion
	INTCON = oldIntcon;
	EECON1bits.WREN = 0;
}
#endif
