/*****************************************************************************/
/**	PIC12F683 software serial					Create Date	2011/04/11		**/
/**	file name	: serial.c						Last UpDate	2011/05/23		**/
/** Complier    : HI-TECH C Ver 9.81										**/
/**																			**/
/**	TAB size = 4															**/
/*****************************************************************************/
/** Inclides *******************************************************/
#include	<htc.h>
#include	<conio.h>
#include	"serial.h"

/** Define *********************************************************/
// ^C}2̐ݒl
#if BRATE < 9600
	#define TIMER2_VALUE (FOSC/(4*4*BRATE))
#else
	#define TIMER2_VALUE (FOSC/(4*BRATE))
#endif

// PX^[grbg + 8f[^rbg + 2Xgbvrbg
#define TRANSMIT_NUM_BITS	12	
// MXe[g
enum receiver_state {
	RS_NOTHING,
	RS_STARTBIT,
	RS_DATA0BIT, RS_DATA1BIT, RS_DATA2BIT, RS_DATA3BIT,
	RS_DATA4BIT, RS_DATA5BIT, RS_DATA6BIT, RS_DATA7BIT,
	RS_STOPBIT 
};

/** Variables ******************************************************/
static unsigned char	sendbuffer;
static unsigned char	receivebuffer;
static bit 				receivebufferfull;
static unsigned char	send_bitno;				
static unsigned char	receivestate;
static unsigned char	rxshift;
static bit				tx_next_bit;

/*******************************************************************
 * 
 *******************************************************************/
void init_serial(void)
{
	receivestate = RS_NOTHING;
	IOC = 0;
	RxIntr = 1;
	INTCONbits.GPIF = 0;
	INTCONbits.GPIE = 1;

#if BRATE < 9600
	T2CON = 0x0C;			// 1:4 Prescaler, TMR2ON
#else
	T2CON = 0x04;			// 1:1 Prescaler, TMR2ON
#endif
	TMR2 = 0;
	PR2  = TIMER2_VALUE;
	PIR1bits.TMR2IF = 0;
	PIE1bits.TMR2IE = 1;
	INTCONbits.PEIE = 1;
	INTCONbits.GIE  = 1;
}

/*******************************************************************
 * ꕶM
 *******************************************************************/
void putc(char c)
{
	while(send_bitno) continue;
	tx_next_bit = 0;
	sendbuffer = c;
	send_bitno = TRANSMIT_NUM_BITS;
}

/*******************************************************************
 * ő16M
 *******************************************************************/
void puts(const char *s)
{
	int i;
	for (i=0;i<16;i++) {
		if (*s=='\0') break;
		putc(*s);
		s++;
	}
}

/*******************************************************************
 * ꕶM
 *******************************************************************/
char getc(void)
{
	while(!receivebufferfull) continue;
	receivebufferfull = 0;
	return receivebuffer;
}

/*******************************************************************
 * MmF
 *******************************************************************/
bit kbhit(void)
{
	return receivebufferfull;
}

/*******************************************************************
 * 荞ݑM
 *******************************************************************/
interrupt void serial_isr(void)
{
	unsigned char work;
	work = RxData;
	// MX^[grbgo
	if (GPIF) {
		if ((receivestate == RS_NOTHING) && !work) {
			TMR2 = TIMER2_VALUE/5;
			receivestate++;
			INTCONbits.GPIE = 0;
			PIR1bits.TMR2IF = 0;
		}
		INTCONbits.GPIF = 0;
		return;
	}
	PIR1bits.TMR2IF = 0;
	// M
	if (receivestate != RS_NOTHING) {
		if ((receivestate == RS_STARTBIT) && work) {
			receivestate = RS_NOTHING;
			INTCONbits.GPIE = 1;
		}
		else if ((receivestate >= RS_DATA0BIT) &&
				 (receivestate <= RS_DATA7BIT)){
			rxshift = (rxshift >> 1) | (work << 7); // M
		}
		else if (receivestate == RS_STOPBIT) {
			receivebuffer = rxshift;
			receivebufferfull = 1;
			receivestate = RS_NOTHING;
			INTCONbits.GPIE = 1;
		}
		if (receivestate != RS_NOTHING) receivestate++;
	}
	// M
	else if (send_bitno) {
		TxData = tx_next_bit;					// M
		tx_next_bit = sendbuffer & 1;
		sendbuffer = (sendbuffer >> 1) | 0x80;
		send_bitno--;
	}
}

/**	end of file	****************************************************/