/*******************************************************************
 pic-logger for 12F683						Create Date	2011/04/11
 file name	: logger.c						Last UpDate	2011/06/05
 Complier    : HI-TECH C Ver 9.81
 
 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include <conio.h>
#include "serial.h"

/** Configuration **************************************************/
__CONFIG(FOSC_INTOSCIO & WDTE_OFF & PWRTE_ON & MCLRE_OFF & BOREN_ON);

/** Define *********************************************************/
#define NAME	"pic-logger\r"		/* Hardware Name		*/
#define HVER	"D3\r"				/* Hardware Version		*/
#define ADCB	10					/* ADC 10-bit binary	*/
#define SMPL	32					/* Sample of number		*/
#define SADD	3					/* Addition of sample	*/
#define MAXCH	4					/* Max Channel			*/

#ifndef _XTAL_FREQ
 // Unless already defined assume 8MHz system frequency
 // This definition is required to calibrate __delay_us() and __delay_ms()
#define _XTAL_FREQ FOSC
#endif

/** Variables ******************************************************/
static unsigned char AdcChannel;
static unsigned char OverSample;
static unsigned char Average;
static unsigned short OverData;
static unsigned short Adc0[SADD];
static unsigned short Adc1[SADD];
static unsigned short Adc2[SADD];
static unsigned short Adc3[SADD];

/** Private Prototypes *********************************************/
void AnalogToDigital(void);
void Sample_ModeChange(void);
void ADC_Bits(void);
void Number_Sample(void);
void Channel_Number(void);
void Hardware_Name(void);
void Hardware_Version(void);
void Write_Ground(void);
void Read_Ground(void);
void Write_Reference(void);
void Read_Reference(void);
void Write_VoltData(void);
void Read_VoltData(void);
void Send_AnalogData(void);
char* AdcToHex(unsigned short dat, char *p);
unsigned short ReadADC(unsigned char channel);
int ReadAdcToNext(unsigned short *adc, unsigned char nextchannel);
void SendADC(unsigned short adcDt, int adcCh);
unsigned short Sampling(unsigned short *p);

/*******************************************************************
 * C[v
 * éAVÃR}h󂯂ď܂B
 *******************************************************************/
void main(void){
	char rdt;
	OSCCON = 0b01110001;		// Fosc 8MHz I
	TRISIO = 0b00011111;		// GPIO5:Output GPIO4-0:Input
	ANSEL  = 0b00101111;		// Fosc/32 AN0-3 AiOI
	ADCON0 = 0b10000000;		// 10bittH[}bgI VDDI
	asm("CLRWDT");				// EHb`hbN^C}NA
	OPTION_REGbits.PSA = 0;		// PSA:Timer0
	WDTCONbits.WDTPS = 0b1000;	// 1:8192 (32kHz)
	WDTCONbits.SWDTEN = 1;		// EHb`hbN^C} ON
	init_serial();				// \tgEFAVȀ
	AdcChannel = 0;				// AiO`l̏
	OverSample = 0;				// I[o[Tv̏
	Average = 0;				// ω̏
	OverData = 0;				// I[o[Tvpf[^̏

	ReadAdcToNext(NULL, AdcChannel);	// ADCJn;

	while(1){
		asm("CLRWDT");			// EHb`hbN^C}NA
		AnalogToDigital();		// ADCf[^ϊ
		if (kbhit()) {
			rdt = getc();		// ꕶM
			putc(rdt);			// GR[obN
			switch(rdt) {
			case 's' : Send_AnalogData();	break;	// f[^M
			case 'a' : ADC_Bits();			break;	// ADCqbgM
			case 'n' : Number_Sample();		break;	// I[o[TvM
			case 'c' : Channel_Number();	break;	// `lo^M
			case 'G' : Write_Ground();		break;	// Ohx
			case 'g' : Read_Ground();		break;	// OEhx̑M
			case 'R' : Write_Reference();	break;	// t@Xx
			case 'r' : Read_Reference();	break;	// t@Xx̑M
			case 'D' : Write_VoltData();	break;	// t@Xd̏
			case 'd' : Read_VoltData();		break;	// t@Xd̑M
			case 'h' : Hardware_Name();		break;	// n[hEFAl[̑M
			case 'v' : Hardware_Version();	break;	// n[hEFAo[W̑M
			default  : break;
			}
		}
	}
}

/*******************************************************************
 * ADCϊf[^̒~
 *******************************************************************/
void AnalogToDigital(void)
{
	unsigned short dat;
	if ( ReadAdcToNext(&dat, AdcChannel) ) return;
	OverData += dat;			// I[o[Tvf[^
	OverSample++;
	if ( OverSample == SMPL-1 ) {
		AdcChannel++;
		if (AdcChannel == MAXCH) AdcChannel = 0;
		return;
	}
	else if (OverSample == SMPL) {
		OverSample = 0;
		if (AdcChannel == 1)		Adc0[Average] = OverData;
		else if (AdcChannel == 2)	Adc1[Average] = OverData;
		else if (AdcChannel == 3)	Adc2[Average] = OverData;
		else if (AdcChannel == 0) {	Adc3[Average] = OverData;
			Average++;
			if (Average == SADD) Average = 0;
		}
		OverData = 0;
	}
}

/*******************************************************************
 * ADC̃rbg̑M
 *******************************************************************/
void ADC_Bits(void)
{
	char num[5];
	AdcToHex(ADCB, num);
	puts(num);					// ADC 10bit
	putc('\r');
}

/*******************************************************************
 * ADC̃TvȎM
 *******************************************************************/
void Number_Sample(void)
{
	char num[5];
	AdcToHex( SMPL, num);
	puts(num);					// 32
	putc('\r');
}

/*******************************************************************
 * ADC̃`lo^̑M
 *******************************************************************/
void Channel_Number(void)
{
	puts("0004abcd\r");			// 4channel, AN0, AN1, AN2, AN3
}

/*******************************************************************
 * n[hEFAl[̑M
 *******************************************************************/
void Hardware_Name(void)
{
	puts(NAME);					// Hardware Name
}

/*******************************************************************
 * n[hEFAo[W̑M
 *******************************************************************/
void Hardware_Version(void)
{
	puts(HVER);					// Hardware Version
}

/*******************************************************************
 * 0V(OEh)x̕ۑ
 *******************************************************************/
void Write_Ground(void)
{
	eeprom_write(0,(Sampling(Adc0)>>8) & 0xFF);
	eeprom_write(1, Sampling(Adc0)     & 0xFF);
	eeprom_write(2,(Sampling(Adc1)>>8) & 0xFF);
	eeprom_write(3, Sampling(Adc1)     & 0xFF);
	eeprom_write(4,(Sampling(Adc2)>>8) & 0xFF);
	eeprom_write(5, Sampling(Adc2)     & 0xFF);
	eeprom_write(6,(Sampling(Adc3)>>8) & 0xFF);
	eeprom_write(7, Sampling(Adc3)     & 0xFF);
	puts("OK\r");
}

/*******************************************************************
 * 0V(OEh)x̑M
 *******************************************************************/
void Read_Ground(void)
{
	SendADC(((eeprom_read(0)<<8)+eeprom_read(1)), 0);
	SendADC(((eeprom_read(2)<<8)+eeprom_read(3)), 1);
	SendADC(((eeprom_read(4)<<8)+eeprom_read(5)), 2);
	SendADC(((eeprom_read(6)<<8)+eeprom_read(7)), 3);
	putc('\r');
}

/*******************************************************************
 * t@Xx̕ۑ
 *******************************************************************/
void Write_Reference(void)
{
	eeprom_write( 8,(Sampling(Adc0)>>8) & 0xFF);
	eeprom_write( 9, Sampling(Adc0)     & 0xFF);
	eeprom_write(10,(Sampling(Adc1)>>8) & 0xFF);
	eeprom_write(11, Sampling(Adc1)     & 0xFF);
	eeprom_write(12,(Sampling(Adc2)>>8) & 0xFF);
	eeprom_write(13, Sampling(Adc2)     & 0xFF);
	eeprom_write(14,(Sampling(Adc3)>>8) & 0xFF);
	eeprom_write(15, Sampling(Adc3)     & 0xFF);
	puts("OK\r");
}

/*******************************************************************
 * t@Xx̑M
 *******************************************************************/
void Read_Reference(void)
{
	SendADC(((eeprom_read( 8)<<8)+eeprom_read( 9)), 0);
	SendADC(((eeprom_read(10)<<8)+eeprom_read(11)), 1);
	SendADC(((eeprom_read(12)<<8)+eeprom_read(13)), 2);
	SendADC(((eeprom_read(14)<<8)+eeprom_read(15)), 3);
	putc('\r');
}

/*******************************************************************
 * t@Xd̎MƏ
 *******************************************************************/
void Write_VoltData(void)
{
	char volt[4];
	volt[0] = getc();
	volt[1] = getc();
	volt[2] = getc();
	volt[3] = getc();
	eeprom_write(16, volt[0]);
	eeprom_write(17, volt[1]);
	eeprom_write(18, volt[2]);
	eeprom_write(19, volt[3]);
	puts("OK\r");
}

/*******************************************************************
 * t@Xd̑M
 *******************************************************************/
void Read_VoltData(void)
{
	putc(eeprom_read(16));
	putc(eeprom_read(17));
	putc(eeprom_read(18));
	putc(eeprom_read(19));
	putc('\r');
}

/*******************************************************************
 * ADCf[^̑M
 *******************************************************************/
void Send_AnalogData(void)
{
	SendADC(Sampling(Adc0), 0);
	SendADC(Sampling(Adc1), 1);
	SendADC(Sampling(Adc2), 2);
	SendADC(Sampling(Adc3), 3);
	putc('\r');
}

/*******************************************************************
 * ADCϊ(ǂݏo)
 *******************************************************************/
unsigned short ReadADC(unsigned char channel)
{
	ADCON0bits.CHS  = channel;
	ADCON0bits.ADON = 1;
	__delay_us(5);
	ADCON0bits.GO   = 1;
	while(ADCON0bits.nDONE) continue;
	ADCON0bits.ADON = 0;
	return ((ADRESH<<8)+ADRESL);
}

/*******************************************************************
 * ADCϊ (ǂݏoƎADϊJn)
 *******************************************************************/
int ReadAdcToNext(unsigned short *adc, unsigned char nextchannel)
{
	if ( ADCON0bits.nDONE ) return (0);
	ADCON0bits.ADON = 0;
	if (adc != NULL) *adc = ((ADRESH<<8)+ADRESL);
	ADCON0bits.CHS  = nextchannel;
	ADCON0bits.ADON = 1;
	__delay_us(5);
	ADCON0bits.GO   = 1;
	return (1);
}

/*******************************************************************
 * ADCf[^̕ϊ
 *******************************************************************/
char* AdcToHex(unsigned short dat, char *p)
{
	const static char hex[] = "0123456789ABCDEF";
	*(p++) = hex[(dat>>12)&0x0F];
	*(p++) = hex[(dat>> 8)&0x0F];
	*(p++) = hex[(dat>> 4)&0x0F];
	*(p++) = hex[(dat    )&0x0F];
	*p = '\0';
	return p;
}

/*******************************************************************
 * ADCf[^̑M(wb_t)
 *******************************************************************/
void SendADC(unsigned short adcDat, int adcCh)
{
	char adcHex[5];
	int i;
	AdcToHex(adcDat, adcHex);
	putc('a'+adcCh);
	puts(adcHex);
}

/*******************************************************************
 * ADC̃TvOf[^
 *******************************************************************/
unsigned short Sampling(unsigned short *p)
{
	long add;
	int i;
	add = 0;
	for (i=0; i<SADD; i++) add += (long)*(p+i);
	return (unsigned short)(add/SADD);
}

/**	end of file	****************************************************/