/*******************************************************************
 PIC16F1937 IntenalTemp						Create Date	2013/02/19
 file name	: IntenalTemp.c					Last UpDate	2013/02/28
 Complier   : HI-TECH C Ver 9.83

 TAB size = 4
/** Inclides *******************************************************/
#include <htc.h>
#include "IntenalTemp.h"

/** Define *********************************************************/
#ifndef _XTAL_FREQ
 // Unless already defined assume 16MHz system frequency
 // This definition is required to calibrate __delay_us() and __delay_ms()
 #define _XTAL_FREQ 16000000
#endif

#define	VF_VDD	0b00
#define	VF_PREF	0b10
#define	VF_FVR	0b11
#define	VF_VSS	0b0
#define	VF_NREF	0b1

#define	AN0		0b00000
#define	AN1		0b00001
#define	AN2		0b00010
#define	AN3		0b00011
#define	AN4		0b00100
#define	AN5		0b00101
#define	AN6		0b00110
#define	AN7		0b00111
#define	AN8		0b01000
#define	AN9		0b01001
#define	AN10	0b01010
#define	AN11	0b01011
#define	AN12	0b01100
#define	AN13	0b01101
#define	AN_TEMP	0b11101
#define	AN_DAC	0b11110
#define	AN_FVR	0b11111

/** Variables ******************************************************/
//volatile union calibration mCalibTemp;
volatile float mCalibTemp;

/** Function *******************************************************/
int _GoADC13(int vref, int ch)
{
	int i, t, gie;
	long int adc = 0;
	ADCON1 = 0b11010000;				// Right: Fosc/16
	ADCON1bits.ADPREF = vref;			// VF_VDD or VF_PREF or VF_FVR
	ADCON0bits.CHS = ch;				// ADC Channel Select
	for (i=0; i<64; i++) {
		gie = INTCONbits.GIE;			// Disable Interrput
		INTCONbits.GIE = 0;
		ADCON0bits.ADON = 1;			// ADC ON
		__delay_us(200);
		ADCON0bits.GO = 1;				// ADC GO
		INTCONbits.GIE = gie;			// Restart Interrput
		while (ADCON0bits.nDONE) continue;
		ADCON0bits.ADON = 0;			// ADC OFF
		adc += ADRES;
	}
	return (int)(adc>>3);
}

float CheckVdd(void)
{
	int i, adc;
	FVRCONbits.FVREN = 1;				// FVR ON
	FVRCONbits.ADFVR = 1;				// ADCFVR 1.024V
	adc = _GoADC13(VF_VDD, AN_FVR);		// ADC Vref:VDD ch:FVR
	FVRCONbits.FVREN = 0;				// FVR OFF
	FVRCONbits.ADFVR = 0;				// ADCFVR OFF
	return (8387.584/adc);				// (1.024V*8191)/adc
}

float CheckTemp(void)
{
	int i;
	float dat;
	FVRCONbits.TSEN = 1;				// Temp ON
	FVRCONbits.TSRNG = 0;				// Temp Low Range
	dat	= _GoADC13(VF_VDD, AN_TEMP);	// ADC Vref:VDD ch:TEMP
	FVRCONbits.TSEN = 0;				// Temp OFF
	dat = 1.000 - (dat / 8191.0);
	dat = 0.659 - (dat*(CheckVdd()/2.0));
	dat = (dat/0.00132)-40.0;
	if (mCalibTemp == NOCALIBRETION) mCalibTemp = 25.0 - dat;
	return (dat + mCalibTemp);
}

void SetCalibretion(float dat)
{
	mCalibTemp = dat;
}

float GetCalibretion(void)
{
	return mCalibTemp;
}


/**	end of file	****************************************************/
