/*******************************************************************
 PIC16F1937 LCD T361002 display				Create Date	2013/02/12
 file name	: t361002.c						Last UpDate	2013/02/28
 Complier   : HI-TECH C Ver 9.83
 LCD driver : PIC16F1937(1/3multiplex, 1/3LCD Bias, Type-A Waveforms)

 TAB size = 4
/** Inclides *******************************************************/
#define	_LCD_T361002_
#include <htc.h>
#include <stdlib.h>
#include <math.h>
#include "t361002.h"

/** Define *********************************************************/
// LCD T36102 Mapping 01-25pin
#define	G2		LCDDATA1bits.SEG13COM0
#define	F2		LCDDATA1bits.SEG14COM0
#define	A2		LCDDATA1bits.SEG15COM0
#define	B2		LCDDATA0bits.SEG5COM0
#define	G3		LCDDATA2bits.SEG21COM0
#define	F3		LCDDATA0bits.SEG0COM0
#define	A3		LCDDATA2bits.SEG22COM0
#define	B3		LCDDATA2bits.SEG23COM0
#define	G4		LCDDATA2bits.SEG20COM0
#define	F4		LCDDATA2bits.SEG19COM0
#define	A4		LCDDATA0bits.SEG2COM0
#define	B4		LCDDATA2bits.SEG18COM0
#define	G5		LCDDATA0bits.SEG1COM0
#define	F5		LCDDATA2bits.SEG17COM0
#define	A5		LCDDATA1bits.SEG8COM0
#define	B5		LCDDATA1bits.SEG9COM0
#define	k_OHM	LCDDATA0bits.SEG3COM0
#define	OHM		LCDDATA1bits.SEG10COM0
#define	mOHM	LCDDATA2bits.SEG16COM0
#define	m_Hz	LCDDATA5bits.SEG16COM1
#define	k_Hz	LCDDATA4bits.SEG10COM1
#define	Hz		LCDDATA3bits.SEG3COM1
#define	C0		LCDDATA4bits.SEG9COM1
// LCD T36102 Mapping 26-50pin
#define	LOWBAT	LCDDATA1bits.SEG12COM0
#define	BAR		LCDDATA0bits.SEG7COM0
#define	AC		LCDDATA6bits.SEG7COM2
#define	BC1		LCDDATA7bits.SEG12COM2
#define	P1		LCDDATA7bits.SEG13COM2
#define	E2		LCDDATA7bits.SEG14COM2
#define	D2		LCDDATA0bits.SEG4COM0
#define	C2		LCDDATA6bits.SEG5COM2
#define	P2		LCDDATA8bits.SEG21COM2
#define	E3		LCDDATA6bits.SEG0COM2
#define	D3		LCDDATA8bits.SEG22COM2
#define	C3		LCDDATA8bits.SEG23COM2
#define	P3		LCDDATA8bits.SEG20COM2
#define	E4		LCDDATA8bits.SEG19COM2
#define	D4		LCDDATA6bits.SEG2COM2
#define	C4		LCDDATA8bits.SEG18COM2
#define	P4		LCDDATA6bits.SEG1COM2
#define	E5		LCDDATA8bits.SEG17COM2
#define	D5		LCDDATA7bits.SEG8COM2
#define	C5		LCDDATA7bits.SEG9COM2
#define	m_AV	LCDDATA6bits.SEG3COM2
#define	AMP		LCDDATA7bits.SEG10COM2
#define	VOL		LCDDATA8bits.SEG16COM2
#define	uA		LCDDATA6bits.SEG4COM2

/** Function *******************************************************/
void init_T361002(void)
{
	// LCDݒ
	LCDCON	= 0b00001010;		// Disable, LFINTOSC, 1/3LMUX
	LCDPS	= 0b00000111;		// Type-A, 1/3Bias, LP1:8 
	LCDREF	= 0b11000000;		// Internal LCD Reference, FVR
	LCDRL	= 0b01010111;		// (low-Pow,9clocks)
	LCDCST	= 0x08;				// Maximum contrast
	LCDSE0	= 0b10111111;		// SEG0-5, SEG7
	LCDSE1	= 0b11110111;		// SEG8-10, SEG12-15
	LCDSE2	= 0b11111111;		// SEG16-23
	// f[^
	LCDDATA0	= 0xFF;			// COM0:SEG0-7   ON
	LCDDATA1	= 0xFF;			// COM0:SEG8-15  ON
	LCDDATA2	= 0xFF;			// COM0:SEG16-23 ON

	LCDDATA3	= 0xFF;			// COM1:SEG0-7   ON
	LCDDATA4	= 0xFF;			// COM1:SEG8-15  ON
	LCDDATA5	= 0xFF;			// COM1:SEG16-23 ON

	LCDDATA6	= 0xFF;			// COM2:SEG0-7   ON
	LCDDATA7	= 0xFF;			// COM2:SEG8-15  ON
	LCDDATA8	= 0xFF;			// COM2:SEG16-23 ON

	LCDCONbits.LCDEN = 1;
}

void lcdClear(void)
{
	LCDDATA0	= 0x00;			// COM0:SEG0-7   OFF
	LCDDATA1	= 0x00;			// COM0:SEG8-15  OFF
	LCDDATA2	= 0x00;			// COM0:SEG16-23 OFF

	LCDDATA3	= 0x00;			// COM1:SEG0-7   OFF
	LCDDATA4	= 0x00;			// COM1:SEG8-15  OFF
	LCDDATA5	= 0x00;			// COM1:SEG16-23 OFF

	LCDDATA6	= 0x00;			// COM2:SEG0-7   OFF
	LCDDATA7	= 0x00;			// COM2:SEG8-15  OFF
	LCDDATA8	= 0x00;			// COM2:SEG16-23 OFF
}

void lcdBar(BOOL on)
{
	if (on)	BAR = 1;
	else	BAR = 0;
}

void lcdAC(BOOL on)
{
	if (on)	AC = 1;
	else	AC = 0;
}

void lcdClearUnit(void)
{
	{ OHM = 0; k_OHM = 0; mOHM = 0; }
	{ m_Hz = 0; k_Hz = 0; Hz = 0; }
	{ C0 =0; }
	{ m_AV = 0; AMP = 0; VOL = 0; uA = 0; }
}

void lcdOHM(void)
{
	lcdClearUnit();
	OHM = 1;
}

void lcdKOHM(void)
{
	lcdClearUnit();
	OHM = 1;
	k_OHM = 1;
}

void lcdMOHM(void)
{
	lcdClearUnit();
	mOHM = 1;
}


void lcdHz(void)
{
	lcdClearUnit();
	Hz = 1;
}

void lcdKHz(void)
{
	lcdClearUnit();
	k_Hz = 1;
	Hz = 1;
}

void lcdMHz(void)
{
	lcdClearUnit();
	m_Hz = 0;
	Hz = 1;
}

void lcdCentigrade(void)
{
	lcdClearUnit();
	C0 = 1;
}

void lcdAmpere(void)
{
	lcdClearUnit();
	AMP = 0;
}

void lcdmAmpere(void)
{
	lcdClearUnit();
	m_AV = 1;
	AMP = 1;
}

void lcduAmpere(void)
{
	lcdClearUnit();
	uA = 1;
}

void lcdVolt(void)
{
	lcdClearUnit();
	VOL = 1;
}

void lcdmVolt(void)
{
	lcdClearUnit();
	m_AV = 1;
	VOL = 1;
}

void _dig1(int n)
{
	if (n == 1) BC1 = 1;
	else		BC1 = 0;
}

void _dig2(int n)
{
	switch(n){
		case 0		: A2=1; B2=1; C2=1; D2=1; E2=1; F2=1; G2=0; break;
		case 1		: A2=0; B2=1; C2=1; D2=0; E2=0; F2=0; G2=0; break;
		case 2		: A2=1; B2=1; C2=0; D2=1; E2=1; F2=0; G2=1; break;
		case 3		: A2=1; B2=1; C2=1; D2=1; E2=0; F2=0; G2=1; break;
		case 4		: A2=0; B2=1; C2=1; D2=0; E2=0; F2=1; G2=1; break;
		case 5		: A2=1; B2=0; C2=1; D2=1; E2=0; F2=1; G2=1; break;
		case 6		: A2=1; B2=0; C2=1; D2=1; E2=1; F2=1; G2=1; break;
		case 7		: A2=1; B2=1; C2=1; D2=0; E2=0; F2=0; G2=0; break;
		case 8		: A2=1; B2=1; C2=1; D2=1; E2=1; F2=1; G2=1; break;
		case 9		: A2=1; B2=1; C2=1; D2=1; E2=0; F2=1; G2=1; break;
		case 0xA	: A2=1; B2=1; C2=1; D2=0; E2=1; F2=1; G2=1; break;
		case 0xb	: A2=0; B2=0; C2=1; D2=1; E2=1; F2=1; G2=1; break;
		case 0xC	: A2=1; B2=0; C2=0; D2=1; E2=1; F2=1; G2=0; break;
		case 0xd	: A2=0; B2=1; C2=1; D2=1; E2=1; F2=0; G2=1; break;
		case 0xE	: A2=1; B2=0; C2=0; D2=1; E2=1; F2=1; G2=1; break;
		case 0xF	: A2=1; B2=0; C2=0; D2=0; E2=1; F2=1; G2=1; break;
		case 20000	: A2=1; B2=0; C2=0; D2=0; E2=0; F2=0; G2=0; break;
		case -20000	: A2=0; B2=0; C2=0; D2=1; E2=0; F2=0; G2=0; break;
		default		: A2=0; B2=0; C2=0; D2=0; E2=0; F2=0; G2=0; break;
	}
}

void _dig3(int n)
{
	switch(n){
		case 0		: A3=1; B3=1; C3=1; D3=1; E3=1; F3=1; G3=0; break;
		case 1		: A3=0; B3=1; C3=1; D3=0; E3=0; F3=0; G3=0; break;
		case 2		: A3=1; B3=1; C3=0; D3=1; E3=1; F3=0; G3=1; break;
		case 3		: A3=1; B3=1; C3=1; D3=1; E3=0; F3=0; G3=1; break;
		case 4		: A3=0; B3=1; C3=1; D3=0; E3=0; F3=1; G3=1; break;
		case 5		: A3=1; B3=0; C3=1; D3=1; E3=0; F3=1; G3=1; break;
		case 6		: A3=1; B3=0; C3=1; D3=1; E3=1; F3=1; G3=1; break;
		case 7		: A3=1; B3=1; C3=1; D3=0; E3=0; F3=0; G3=0; break;
		case 8		: A3=1; B3=1; C3=1; D3=1; E3=1; F3=1; G3=1; break;
		case 9		: A3=1; B3=1; C3=1; D3=1; E3=0; F3=1; G3=1; break;
		case 0xA	: A3=1; B3=1; C3=1; D3=0; E3=1; F3=1; G3=1; break;
		case 0xb	: A3=0; B3=0; C3=1; D3=1; E3=1; F3=1; G3=1; break;
		case 0xC	: A3=1; B3=0; C3=0; D3=1; E3=1; F3=1; G3=0; break;
		case 0xd	: A3=0; B3=1; C3=1; D3=1; E3=1; F3=0; G3=1; break;
		case 0xE	: A3=1; B3=0; C3=0; D3=1; E3=1; F3=1; G3=1; break;
		case 0xF	: A3=1; B3=0; C3=0; D3=0; E3=1; F3=1; G3=1; break;
		case 20000	: A3=1; B3=0; C3=0; D3=0; E3=0; F3=0; G3=0; break;
		case -20000	: A3=0; B3=0; C3=0; D3=1; E3=0; F3=0; G3=0; break;
		default		: A3=0; B3=0; C3=0; D3=0; E3=0; F3=0; G3=0; break;
	}
}

void _dig4(int n)
{
	switch(n){
		case 0		: A4=1; B4=1; C4=1; D4=1; E4=1; F4=1; G4=0; break;
		case 1		: A4=0; B4=1; C4=1; D4=0; E4=0; F4=0; G4=0; break;
		case 2		: A4=1; B4=1; C4=0; D4=1; E4=1; F4=0; G4=1; break;
		case 3		: A4=1; B4=1; C4=1; D4=1; E4=0; F4=0; G4=1; break;
		case 4		: A4=0; B4=1; C4=1; D4=0; E4=0; F4=1; G4=1; break;
		case 5		: A4=1; B4=0; C4=1; D4=1; E4=0; F4=1; G4=1; break;
		case 6		: A4=1; B4=0; C4=1; D4=1; E4=1; F4=1; G4=1; break;
		case 7		: A4=1; B4=1; C4=1; D4=0; E4=0; F4=0; G4=0; break;
		case 8		: A4=1; B4=1; C4=1; D4=1; E4=1; F4=1; G4=1; break;
		case 9		: A4=1; B4=1; C4=1; D4=1; E4=0; F4=1; G4=1; break;
		case 0xA	: A4=1; B4=1; C4=1; D4=0; E4=1; F4=1; G4=1; break;
		case 0xb	: A4=0; B4=0; C4=1; D4=1; E4=1; F4=1; G4=1; break;
		case 0xC	: A4=1; B4=0; C4=0; D4=1; E4=1; F4=1; G4=0; break;
		case 0xd	: A4=0; B4=1; C4=1; D4=1; E4=1; F4=0; G4=1; break;
		case 0xE	: A4=1; B4=0; C4=0; D4=1; E4=1; F4=1; G4=1; break;
		case 0xF	: A4=1; B4=0; C4=0; D4=0; E4=1; F4=1; G4=1; break;
		case 20000	: A4=1; B4=0; C4=0; D4=0; E4=0; F4=0; G4=0; break;
		case -20000	: A4=0; B4=0; C4=0; D4=1; E4=0; F4=0; G4=0; break;
		default		: A4=0; B4=0; C4=0; D4=0; E4=0; F4=0; G4=0; break;
	}
}

void _dig5(int n)
{
	switch(n){
		case 0		: A5=1; B5=1; C5=1; D5=1; E5=1; F5=1; G5=0; break;
		case 1		: A5=0; B5=1; C5=1; D5=0; E5=0; F5=0; G5=0; break;
		case 2		: A5=1; B5=1; C5=0; D5=1; E5=1; F5=0; G5=1; break;
		case 3		: A5=1; B5=1; C5=1; D5=1; E5=0; F5=0; G5=1; break;
		case 4		: A5=0; B5=1; C5=1; D5=0; E5=0; F5=1; G5=1; break;
		case 5		: A5=1; B5=0; C5=1; D5=1; E5=0; F5=1; G5=1; break;
		case 6		: A5=1; B5=0; C5=1; D5=1; E5=1; F5=1; G5=1; break;
		case 7		: A5=1; B5=1; C5=1; D5=0; E5=0; F5=0; G5=0; break;
		case 8		: A5=1; B5=1; C5=1; D5=1; E5=1; F5=1; G5=1; break;
		case 9		: A5=1; B5=1; C5=1; D5=1; E5=0; F5=1; G5=1; break;
		case 0xA	: A5=1; B5=1; C5=1; D5=0; E5=1; F5=1; G5=1; break;
		case 0xb	: A5=0; B5=0; C5=1; D5=1; E5=1; F5=1; G5=1; break;
		case 0xC	: A5=1; B5=0; C5=0; D5=1; E5=1; F5=1; G5=0; break;
		case 0xd	: A5=0; B5=1; C5=1; D5=1; E5=1; F5=0; G5=1; break;
		case 0xE	: A5=1; B5=0; C5=0; D5=1; E5=1; F5=1; G5=1; break;
		case 0xF	: A5=1; B5=0; C5=0; D5=0; E5=1; F5=1; G5=1; break;
		case 20000	: A5=1; B5=0; C5=0; D5=0; E5=0; F5=0; G5=0; break;
		case -20000	: A5=0; B5=0; C5=0; D5=1; E5=0; F5=0; G5=0; break;
		default		: A5=0; B5=0; C5=0; D5=0; E5=0; F5=0; G5=0; break;
	}
}

void _dotpoint(int n)
{
	switch(n){
		case 1	: P1=1; P2=0; P3=0; P4=0; break;
		case 2	: P1=0; P2=1; P3=0; P4=0; break;
		case 3	: P1=0; P2=0; P3=1; P4=0; break;
		case 4	: P1=0; P2=0; P3=0; P4=1; break;
		default	: P1=0; P2=0; P3=0; P4=0; break;
	}
}

BOOL _Number(int num, int dp)
{
	int n;
	if (num >= 20000) {
		num = 20000;
		{ _dig1(num); _dig2(num); _dig3(num); _dig4(num); _dig5(num); }
		_dotpoint(0);
		return FALSE;
	}
	else if (num <= -20000) {
		num = -20000;
		{ _dig1(num); _dig2(num); _dig3(num); _dig4(num); _dig5(num); }
		_dotpoint(0);
		return FALSE;
	}
	lcdBar((num>=0)? FALSE : TRUE);
	n = num = abs(num);
	{
				_dig1(n/10000);
		n=n%10000;
		if (n/1000>0 || num>=10000 || dp==1 || dp==2)
				_dig2(n/1000);
		else	_dig2(-1);
		n=n%1000;
		if (n/100>0 || num>=1000 || dp==1 || dp==2 || dp==3)
				_dig3(n/100);
		else	_dig3(-1);
		n=n%100;
		if (n/10>0 || num>=100 || dp==1 || dp==2 || dp==3 || dp==4)
				_dig4(n/10);
		else	_dig4(-1);
				_dig5(n%10);
	}
	_dotpoint(dp);
	return TRUE;
}

BOOL lcdNumber(int num)
{
	return _Number(num, 0);
}

BOOL lcdfNumber(float dat)
{
	float f;
	f = fabs(dat);
	if		(f < 19.999)	{ return _Number((int)(dat*1000), 2); }
	else if (f < 199.99)	{ return _Number((int)(dat*100), 3); }
	else if (f < 1999.9)	{ return _Number((int)(dat*10), 4); }
	else					{ return _Number((int)(dat*1), 5); }
}

BOOL lcdtNumber(float dat)
{
	float f;
	f = fabs(dat);
	if (f < 1999.9)	{ return _Number((int)(dat*10), 4); }
	else			{ return _Number((int)(dat*1), 5); }
}

/**	end of file	****************************************************/
