;==============================================================================;
;==	usbdesc.inc										Last Update 2015/02/22
;==															Saka Softwares
;==============================================================================;
;== usbhiddrv.asm で生成されるデバイスディスクプリタです。
;== 必要に応じて各データを変更してください。
;== 注意. HID Bootloader としてマイクロチップ社製と互換があり個人的に使用するので
;==		 ベンダーID,プロダクトIDをそのまま使用しています。
;==		 もし 製品等使用される場合には変更する必要があります。
;==============================================================================;
	radix	dec

;== Define ====================================================================;
#define POW_DEFAULT		0x80			; Default Value (Bit 7 is set)
#define POW_SELF		0x40			; Self-powered (Supports if set)
#define POW_RWU			0x20			; Remote Wakeup (Supports if set)

#define CFG_ATTRIBUTES	POW_DEFAULT		; 必要に応じて修正する

; 各エンドポイントのバッファサイズ
#define EP0_BUF_SIZE	8				; EP0のデータバッファサイズ
#define EP1_BUF_SIZE	64				; EP1のデータバッファサイズ

; 各デスクプリタのサイズ
#define DEVDSC_SIZE		0x12			; デバイス デスクプリタ
#define CFGDSC_SIZE		0x09			; コンフィグ デスクプリタ
#define IFDSC_SIZE		0x09			; インターフェース デスクプリタ
#define HIDDSC_SIZE		0x09			; HID デスクプリタ
#define EPDSC_SIZE		0x07			; エイドポイント デスクプリタ
#define LANGDSC_SIZE	0x04			; 言語 ディスクリプタ

#define DSC_DEV			0x01			; デバイス ディスクプリタ タイプ
#define DSC_CFG			0x02			; コンフィグ ディスクプリタ タイプ
#define DSC_STR			0x03			; ストリング ディスクプリタ タイプ
#define DSC_INTF		0x04			; インターフェース ディスクプリタ タイプ
#define DSC_EP			0x05			; エンドポイント ディスクプリタ タイプ
#define DSC_DQ			0x06			; Device Qualitier
#define DSC_OSC			0x07			; Other Speed Configuratiln

#define EP_CTRL			0x00			; コントロール転送
#define EP_ISO			0x01			; アイソクロナス転送
#define EP_BULK			0x02			; バルク転送
#define EP_INT			0x03			; インターラプト転送

;==============================================================================;
; HID
#define HID_INTF_ID		0x00
#define HID_NUM_OF_DSC	1

; Class-Specific Requests
#define GET_REPORT		0x01
#define GET_IDLE		0x02
#define GET_PROTOCOL	0x03
#define SET_REPORT		0x09
#define SET_IDLE		0x0A
#define SET_PROTOCOL	0x0B

; Class Descriptor Types
#define DSC_HID			0x21
#define DSC_RPT			0x22
#define DSC_PHY			0x23

; Protocol Selection
#define BOOT_PROTOCOL	0x00
#define RPT_PROTOCOL	0x01

; HID Interface Class Code
#define HID_INTF				0x03

; HID Interface Class SubClass Codes
#define BOOT_INTF_SUBCLASS		0x01

; HID Interface Class Protocol Codes
#define HID_PROTOCOL_NONE		0x00
#define HID_PROTOCOL_KEYBOARD	0x01
#define HID_PROTOCOL_MOUSE		0x02

;==============================================================================;
#define CFGDSC01_SIZE	(CFGDSC01_END - CFGDSC01)	; コンフィグ (トータル)
#define HIDRPT01_SIZE	(HIDRPT01_END - HIDRPT01)	; HID レポート (可変)

;==============================================================================;
DSC_CODE	CODE_PACK
;==============================================================================;
; Device Descriptor
DEVDSC01
	db	DEVDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_DEV					; DEVICE descriptor type
	dw	0x0200					; USB Spec Release Number in BCD format
	db	0x00					; Class Code
	db	0x00					; Subclass code
	db	0x00					; Protocol code
	db	EP0_BUF_SIZE			; Max packet size for EP0
	dw	0x04D8					; Vendor ID  (Microchip)
	dw	0x003C					; Product ID (HID Bootloader)
	dw	0x0002					; Device release number in BCD format
	db	0x01					; Manufacturer string index
	db	0x02					; Product string index
	db	0x00					; Device serial number string index
	db	0x01					; Number of possible configurations

;==============================================================================;
; Configuration Descriptor
CFGDSC01
	db	CFGDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_CFG					; ONFIGURATION descriptor type
	dw	CFGDSC01_SIZE			; Total length of data for this cfg
	db	1						; Number of interfaces in this cfg
	db	1						; Index value of this configuration
	db	0						; Configuration string index
	db	CFG_ATTRIBUTES			; Attributes
	db	50						; Max power consumption (2X mA)
; Interface Descriptor
IFDSC01
	db	IFDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_INTF				; INTERFACE descriptor type
	db	0						; Interface Number
	db	0						; Alternate Setting Number
	db	2						; Number of endpoints in this intf
	db	HID_INTF				; Class code
	db	0						; Subclass code, no subclass
	db	0						; Protocol code, no protocol
	db	0						; Interface string index
; HID Class-Specific Descriptor
HIDDSC01
	db	HIDDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_HID					; HID descriptor type
	dw	0x0111					; HID Spec Release Number in BCD format
	db	0x00					; Country Code (0x00 for Not supported)
	db	HID_NUM_OF_DSC			; Number of class descriptors
	db	DSC_RPT					; Report descriptor type
	dw	HIDRPT01_SIZE			; Size of the report descriptor
; Endpoint Descriptor
EP1iDSC01
	db	EPDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_EP					; Endpoint descriptor type
	db	0x81					; Endpoint Address
	db	EP_INT					; Endpoint Attributes
	dw	EP1_BUF_SIZE			; Endpoint Max Packet Size
	db	1						; Interval Times (ms)
EP1oDSC01
	db	EPDSC_SIZE				; Size of this descriptor in bytes
	db	DSC_EP					; Endpoint descriptor typ
	db	0x01					; Endpoint Address
	db	EP_INT					; Endpoint Attributes
	dw	EP1_BUF_SIZE			; Endpoint Max Packet Size
	db	1						; Interval Times (ms)
CFGDSC01_END

;==============================================================================;
; String descriptors language ID Descriptor
LANGDSC
	db	LANGDSC_SIZE			; Size of this descriptor in bytes
	db	DSC_STR					; String descriptor typ
	dw	0x0409					; language (English)

; Manufacturer string Descriptor
#define MFGDSC01_SIZE	(MFGDSC01_END - MFGDSC01)
MFGDSC01
	db	MFGDSC01_SIZE				; Size of this descriptor in bytes
	db	DSC_STR						; String descriptor typ
	dw	'M','i','c','r','o','c','h','i','p',' '
	dw	'T','e','c','h','n','o','l','o','g','y',' ','I','n','c','.'
MFGDSC01_END

; Product string Descriptor
#define PRDDSC01_SIZE	(PRDDSC01_END - PRDDSC01)
PRDDSC01
	db	PRDDSC01_SIZE				; Size of this descriptor in bytes
	db	DSC_STR						; String descriptor typ
	dw	'H','I','D',' ','U','S','B',' ','B','o','o'
	dw	't','l','o','a','d','e','r'
PRDDSC01_END

;==============================================================================;
; HID Report Descriptor
HIDRPT01
	db 0x06, 0x00, 0xFF		; Usage Page = 0xFF00 (Vendor Defined Page 1)
	db 0x09, 0x01			; Usage (Vendor Usage 1)
	db 0xA1, 0x01			; Collection (Application)
	db 0x19, 0x01			; Usage Minimum 
	db 0x29, 0x40			; Usage Maximum // 64 input usages total (0x01 to 0x40)
	db 0x15, 0x00			; Logical Minimum (data bytes in the report may have minimum value = 0x00)
	db 0x26, 0xFF, 0x00		; Logical Maximum (data bytes in the report may have maximum value = 0x00FF = unsigned 255)
	db 0x75, 0x08			; Report Size: 8-bit field size
	db 0x95, 0x40			; Report Count: Make sixty-four 8-bit fields (the next time the parser hits an "Input", "Output", or "Feature" item)
	db 0x81, 0x00			; Input (Data, Array, Abs): Instantiates input packet fields based on the above report size, count, logical min/max, and usage.
	db 0x19, 0x01			; Usage Minimum 
	db 0x29, 0x40			; Usage Maximum //64 output usages total (0x01 to 0x40)
	db 0x91, 0x00			; Output (Data, Array, Abs): Instantiates output packet fields.  Uses same report size and count as "Input" fields, since nothing new/different was specified to the parser since the "Input" item.
	db 0xC0					; End Collection
HIDRPT01_END

;== end of file ===============================================================;
