;==============================================================================;
;== bootloader.inc									Last Update 2018/02/11
;==															Saka Softwares
;==============================================================================;
;== Define ====================================================================;
;==	ユーザープログラム開始アドレス設定 (1つを選択する)
	#define BOOTLOADER_2KBYTE	; スタートアドレス 0x0800 (純正のVer1.02 対応)
;;	#define BOOTLOADER_4KBYTE	; スタートアドレス 0x1000 (純正のVer1.02対応 同一アドレス)
;==============================================================================;
#ifdef _HID_BOOTLOADER
	extern	Main_Reset				; main.asm
#else
	extern	BootlodarInit			; ブートローダー初期化
	extern	BootlodarTasks			; ブートローダー実行部
#endif
;== Vector remapping ==========================================================;
	#define BOOTLOADER_ENTRY_ADDRESS	0x001C	; ブートローダーエントリーアドレス
#ifdef	 BOOTLOADER_2KBYTE
	#define REMAPPED_RESET_VECTOR		0x800	; アプリ用リセットアドレス
	#define APP_SIGNATURE_ADDRESS		0x806	; ブートサインアドレス
	#define REMAPPED_HIGH_ISR_VECTOR	0x808	; アプリ用高割り込みアドレス
	#define APP_VERSION_ADDRESS			0x816	; アプリ用バージョンアドレス
	#define REMAPPED_LOW_ISR_VECTOR		0x818	; アプリ用低割り込みアドレス
#endif
#ifdef	 BOOTLOADER_4KBYTE
	#define REMAPPED_RESET_VECTOR		0x1000	; アプリ用リセットアドレス
	#define APP_SIGNATURE_ADDRESS		0x1006	; ブートサインアドレス
	#define REMAPPED_HIGH_ISR_VECTOR	0x1008	; アプリ用高割り込みアドレス
	#define APP_VERSION_ADDRESS			0x1016	; アプリ用バージョンアドレス
	#define REMAPPED_LOW_ISR_VECTOR		0x1018	; アプリ用低割り込みアドレス
#endif
	#define APP_SIGNATURE_VALUE			0x600D	; ブートサインコード
	#define APP_SIGN_ADRL				0x06
	#define APP_SIGN_ADRH				0x07	; リセットアドレスから相対位置
	#define APP_VER_ADRL				0x16
	#define APP_VER_ADRH				0x17	; リセットアドレスから相対位置

;== end of file ===============================================================;
