;==============================================================================;
;==	usbhiddrv.inc									Last Update 2015/11/18
;==															Saka Softwares
;==============================================================================;
#ifdef _PIC18F_USB_DRIVER
;	HID-bootloaderは、コントロール通信でセットアップパケット以外の受信はありません。

#else
	extern	USBDeviceInit				; USBモジュールの初期化
	extern	USBDeviceTasks				; USBタスク処理
	extern	HIDRxIsBusy					; データ(EP1)受信中か調べる
	extern	HIDTxIsBusy					; データ(EP1)送信中か調べる
	extern	HIDRxReport					; データ(EP1)受信処理
	extern	HIDTxReport					; データ(EP1)送信処理

	extern	PIPE0o, PIPE0i				; パイプ0
	extern	PIPE1o, PIPE1i				; パイプ1

	#define mHIDTxADRL	mPI1iADRL		; 送信元アドレス(Low)
	#define mHIDTxADRH	mPI1iADRH		; 送信元アドレス(high)
	#define mHIDTxADRU	mPI1iADRU		; 送信元アドレス(upper / ROMのみ)
	#define mHIDTxCNT	mPI1iCNT		; 送信数
	#define mHIDTxFLAG	mPI1iFLAG		; 送信フラグ(パイプフラグを使用)
	#define mHIDTxBUF	mPI1iBUF		; 送信バッファ

	#define mHIDRxADRL	mPI1oADRL		; 受信先アドレス(low)
	#define mHIDRxADRH	mPI1oADRH		; 受信先アドレス(high)
	#define mHIDRxCNT	mPI1oCNT		; 受信数
	#define mHIDRxFLAG	mPI1oFLAG		; 受信フラグ(パイプフラグを使用)
	#define mHIDRxBUF	mPI1oBUF		; 受信バッファ
#endif

;== Define ====================================================================;
; USB 状態フラグ
#define DETACHED_STATE			0		; ケーブル未接続状態
#define ATTACHED_STATE			1		; ゲーブル接続状態
#define POWERED_STATE			2		; USB電源投入状態
#define DEFAULT_STATE			3		; USB初期状態
#define ADR_PENDING_STATE		4		; USB アドレス書込待ち状態
#define ADDRESS_STATE			5		; USB アドレス設定状態
#define CONFIGURED_STATE		6		; USB 設定終了状態 (USB動作中)

; エンドポイント対応のバッファ名
#define		mPI0oBUF	bmRequestType	; EP0 OUTバッファ
#define		mPI0iBUF	BD1BUF			; EP0 INバッファ
#define		mPI1oBUF	BD2BUF			; EP1 OUTバッファ
#define		mPI1iBUF	BD3BUF			; EP1 INバッファ
; パイプのレジスタ化
; Pipeの相対アドレス
#define		PIFLAG		0				; パイプフラグ
#define		PICNT		1				; 送信予定数
#define		PIADRL		2				; 転送元アドレス(Low)
#define		PIADRH		3				; 転送元アドレス(High)
#define		PIADRU		4				; 転送元アドレス(Upper)
; Pipe0 Out (受信)
#define		mPI0oFLAG	(PIPE0o+PIFLAG) ; パイプフラグ
#define		mPI0oCNT	(PIPE0o+PICNT)	; 受信予定数
#define		mPI0oADRL	(PIPE0o+PIADRL) ; 転送先アドレス(Low)
#define		mPI0oADRH	(PIPE0o+PIADRH) ; 転送先アドレス(High)
#define		mPI0oADRU	(PIPE0o+PIADRU) ; 転送先アドレス(Upper)
; Pipe0 In (送信)
#define		mPI0iFLAG	(PIPE0i+PIFLAG) ; パイプフラグ
#define		mPI0iCNT	(PIPE0i+PICNT)	; 送信予定数
#define		mPI0iADRL	(PIPE0i+PIADRL) ; 転送元アドレス(Low)
#define		mPI0iADRH	(PIPE0i+PIADRH) ; 転送元アドレス(High)
#define		mPI0iADRU	(PIPE0i+PIADRU) ; 転送元アドレス(Upper)
; Pipe1 Out (受信)
#define		mPI1oFLAG	(PIPE1o+PIFLAG) ; パイプフラグ
#define		mPI1oCNT	(PIPE1o+PICNT)	; 受信予定数
#define		mPI1oADRL	(PIPE1o+PIADRL) ; 転送先アドレス(Low)
#define		mPI1oADRH	(PIPE1o+PIADRH) ; 転送先アドレス(High)
#define		mPI1oADRU	(PIPE1o+PIADRU) ; 転送先アドレス(Upper)
; Pipe1 In (送信)
#define		mPI1iFLAG	(PIPE1i+PIFLAG) ; パイプフラグ
#define		mPI1iCNT	(PIPE1i+PICNT)	; 送信予定数
#define		mPI1iADRL	(PIPE1i+PIADRL) ; 転送元アドレス(Low)
#define		mPI1iADRH	(PIPE1i+PIADRH) ; 転送元アドレス(High)
#define		mPI1iADRU	(PIPE1i+PIADRU) ; 転送元アドレス(Upper)
; パイプフラグ
bPIRAM		EQU 0						; RAMフラグ			0:ROM / 1:RAM
bPINCPY		EQU 1						; 転送不要フラグ		0:Copy / l:No Copy
bPIBUSY		EQU 7						; ビジーフラグ		0:空き / 1:処理中
#define		fPIROM		0x00			; データはROM上に有る
#define		fPIRAM		0x01			; データはRAM上に有る
#define		fPINCPY		0x02			; データは送信バッファ上だけに有りコピー不要
#define		fPIBUSY		0x80			; 処理中

;==============================================================================;
;== USB Chapter 9 Protocol
; bmRequestType Definitions
#define MK_TRDIR		b'10000000'		;
#define MK_TYPE			b'01100000'		;
#define MK_RCPT			b'00011111'		;
#define HOST_TO_DEVICE		0x00		; transfer direction - host to device transfer
#define DEVICE_TO_HOST		0x80		; transfer direction - device to host transfer
#define TYPE_STANDARD		0x00		; type - standard
#define TYPE_CLASS			0x20		; type - class
#define TYPE_VENDOR			0x40		; type - vendor
#define RCPT_DEV			0x00		; recipient - device
#define RCPT_INTF			0x01		; recipient - interface
#define RCPT_EP				0x02		; recipient - endpoint
#define RCPT_OTH			0x03		; recipient - other
; bRequest (Standard Device Request)
#define GET_STATUS			0x00		; GET STATUS
#define CLEAR_FEATURE		0x01		; CLEAR FEATURE
#define SET_FEATURE			0x03		; SET FEATURE
#define SET_ADDRESS			0x05		; SET ADDRESS
#define GET_DESCRIPTOR		0x06		; GET DESCRIPTOR
#define SET_DESCRIPTOR		0x07		; SET DESCRIPTOR
#define GET_CONFIGURATION	0x08		; GET CONFIGURATION
#define SET_CONFIGURATION	0x09		; SET CONFIGURATION
#define GET_INTERFACE		0x0A		; GET INTERFACE
#define SET_INTERFACE		0x0B		; SET INTERFACE
#define SYNCH_FRAME			0x0C		; SYNCH FRAME

#define bConfigValue	(wValue+0)
#define bDscIndex		(wValue+0)
#define bDscType		(wValue+1) 

#define bAltID			(wValue+0) 
#define bIntfID			(wIndex+0) 

;== end of file ===============================================================;
