;==============================================================================;
;==	PicConfig.inc									Last Update 2021/02/19
;==															Saka Softwares
;==============================================================================;
;== PIC18Non_Jの各コンフィグを載せています。
;== コンフィグワードは、MPLAB X IDEの生成機能を使っています。
;== ([Window]-[PIC Memory Views]-[Configuration Bits]からできます。)
;== ユーザープログラムのコンフィグワードと合わせる必要があります。
;== (勿論USBが使用できることが前提です。)
;== ウォッチドックタイマを有効にしました。 初期値は1024（約4秒）にしてあります。
;== mpasm (v5.77) では、	PIC18(L)F2xK50/45K50 の nLPBOR が ON にできないので
;== 注意してください。
;==============================================================================;
#ifdef __18F13K50
	list p=PIC18F13K50
	#include "p18f13k50.inc"
	; CONFIG1L
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= OFF			; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HS			; オシレータ選択ビット
	CONFIG	PLLEN		= ON			; 4 X PLL イネーブルビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 30			; ブラウンアウト リセット電圧ビット
	; CONFIG2H
	CONFIG	WDTEN		= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	HFOFST		= OFF			; HFINTOSC 高速起動ビット
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= ON			; ブートブロック サイズ選択ビット(1kW boot block size)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18LF13K50
	list p=PIC18LF13K50
	#include "p18lf13k50.inc"
	; CONFIG1L
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= OFF			; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HS			; オシレータ選択ビット
	CONFIG	PLLEN		= ON			; 4 X PLL イネーブルビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 30			; ブラウンアウト リセット電圧ビット
	; CONFIG2H
	CONFIG	WDTEN		= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	HFOFST		= OFF			; HFINTOSC 高速起動ビット
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= ON			; ブートブロック サイズ選択ビット(1kW boot block size)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F14K50
	list p=PIC18F14K50
	#include "p18f14k50.inc"
	; CONFIG1L
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= OFF			; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HS			; オシレータ選択ビット
	CONFIG	PLLEN		= ON			; 4 X PLL イネーブルビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 30			; ブラウンアウト リセット電圧ビット
	; CONFIG2H
	CONFIG	WDTEN		= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	HFOFST		= OFF			; HFINTOSC 高速起動ビット
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= ON			; ブートブロック サイズ選択ビット(2kW boot block size)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18LF14K50
	list p=PIC18LF14K50
	#include "p18lf14k50.inc"
	; CONFIG1L
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= OFF			; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HS			; オシレータ選択ビット
	CONFIG	PLLEN		= ON			; 4 X PLL イネーブルビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 30			; ブラウンアウト リセット電圧ビット
	; CONFIG2H
	CONFIG	WDTEN		= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	HFOFST		= OFF			; HFINTOSC 高速起動ビット
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= ON			; ブートブロック サイズ選択ビット(2kW boot block size)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F24K50
	list p=PIC18F24K50
	#include "p18f24k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18LF24K50
	list p=PIC18LF24K50
	#include "p18lf24k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F25K50
	list p=PIC18F25K50
	#include "p18f25k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18LF25K50
	list p=PIC18LF25K50
	#include "p18lf25k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F45K50
	list p=PIC18F45K50
	#include "p18f45k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18LF45K50
	list p=PIC18LF45K50
	#include "p18lf45k50.inc"
	#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	; CONFIG1L
	CONFIG	PLLSEL		= PLL3X			; PLL 倍率選択ビット x3
	CONFIG	CFGPLLEN	= ON			; PLL イネーブルビット
	CONFIG	CPUDIV		= NOCLKDIV		; CPU システムクロック選択ビット
	CONFIG	LS48MHZ		= SYS48X8		; USB ロースピード用クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= INTOSCIO		; オシレータ選択ビット
	CONFIG	PCLKEN		= OFF			; プライマリ クロック イネーブルビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	nPWRTEN		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOREN		= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 285			; ブラウンアウト リセット電圧ビット
	CONFIG	nLPBOR		= OFF			; ローパワー ブラウンアウト リセット イネーブルビット
	; CONFIG2H
	CONFIG	WDTEN		= SWON			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= RC1			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	T3CMX		= RB5			; Timer3 Clock Input MUX bit
	CONFIG	SDOMX		= RC7			; SDO Output MUX bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; ICPORT イネーブルビット (44-PIN TQFPのみ)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F2450
	list p=PIC18F2450
	#include "p18f2450.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 43			; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= BB2K			; ブートブロック サイズ選択ビット(2kW boot block size)
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F4450
	list p=PIC18F4450
	#include "p18f4450.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 43			; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	BBSIZ		= BB2K			; ブートブロック サイズ選択ビット(2kW boot block size)
	CONFIG	ICPRT		= OFF			; Dedicated In-Circuit Debug/Programming Port
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット
	CONFIG	CP1			= OFF			; コード保護ビット
	; CONFIG5HL
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット
	CONFIG	WRT1		= OFF			; 書き込み保護ビット
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット
	; CONFIG7HL
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F2455
	list p=PIC18F2455
	#include "p18f2455.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG5H
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	; CONFIG6L
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F2458
	list p=PIC18F2458
	#include "p18f2458.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG5H
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	; CONFIG6L
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F2550
	list p=PIC18F2550
	#include "p18f2550.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	; CONFIG2L
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F2553
	list p=PIC18F2553
	#include "p18f2553.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	; CONFIG2L
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F4455
	list p=PIC18F4455
	#include "p18f4455.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; Dedicated In-Circuit Debug/Programming Port
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F4458
	list p=PIC18F4458
	#include "p18f4458.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; Dedicated In-Circuit Debug/Programming Port
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F4550
	list p=PIC18F4550
	#include "p18f4550.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; Dedicated In-Circuit Debug/Programming Port
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif
#ifdef __18F4553
	list p=PIC18F4553
	#include "p18f4553.inc"
	; CONFIG1L
	CONFIG	PLLDIV		= 5				; PLL プリスケーラー選択ビット
	CONFIG	CPUDIV		= OSC1_PLL2		; CPU システムクロック選択ビット
	CONFIG	USBDIV		= 2				; USB クロック選択ビット
	; CONFIG1H
	CONFIG	FOSC		= HSPLL_HS		; オシレータ選択ビット
	CONFIG	FCMEN		= OFF			; フェイルセーフ クロック モニタ イネーブルビット
	CONFIG	IESO		= OFF			; 内部/ 外部オシレータ切り換えビット
	; CONFIG2L
	CONFIG	PWRT		= OFF			; パワーアップ タイマ イネーブルビット (無効)
	CONFIG	BOR			= ON			; ブラウンアウト リセット イネーブルビット
	CONFIG	BORV		= 3				; ブラウンアウト リセット電圧ビット
	CONFIG	VREGEN		= ON			; USB 電圧レギュレータ イネーブルビット
	; CONFIG2H
	CONFIG	WDT			= OFF			; ウォッチドッグ タイマ イネーブルビット
	CONFIG	WDTPS		= 1024			; ウォッチドッグ タイマ ポストスケーラ選択ビット
	; CONFIG3H
	CONFIG	CCP2MX		= OFF			; CCP2 MUX bit
	CONFIG	PBADEN		= OFF			; PORTB A/D Enable bit
	CONFIG	LPT1OSC		= OFF			; Low-Power Timer 1 Oscillator Enable bit
	CONFIG	MCLRE		= OFF			; MCLR ピン イネーブルビット
	; CONFIG4L
	CONFIG	STVREN		= ON			; スタックフル/ アンダーフロー リセット イネーブルビット
	CONFIG	LVP			= OFF			; 単電源ICSP イネーブルビット
	CONFIG	ICPRT		= OFF			; Dedicated In-Circuit Debug/Programming Port
	CONFIG	XINST		= OFF			; 拡張命令セットイネーブルビット (ENHCPU)
	; CONFIG5L
	CONFIG	CP0			= OFF			; コード保護ビット 0
	CONFIG	CP1			= OFF			; コード保護ビット 1
	CONFIG	CP2			= OFF			; コード保護ビット 2
	CONFIG	CP3			= OFF			; コード保護ビット 3
	; CONFIG5H
	CONFIG	CPB			= OFF			; ブートブロック コード保護ビット
	CONFIG	CPD			= OFF			; EEPROM コード保護ビット
	; CONFIG6L
	CONFIG	WRT0		= OFF			; 書き込み保護ビット 0
	CONFIG	WRT1		= OFF			; 書き込み保護ビット 1
	CONFIG	WRT2		= OFF			; 書き込み保護ビット 2
	CONFIG	WRT3		= OFF			; 書き込み保護ビット 3
	; CONFIG6H
	CONFIG	WRTC		= OFF			; コンフィグレーション レジスタ書き込み保護ビット
	CONFIG	WRTB		= OFF			; ブートブロック書き込み保護ビット
	CONFIG	WRTD		= OFF			; EEPROM 書き込み保護ビット
	; CONFIG7L
	CONFIG	EBTR0		= OFF			; テーブル読み出し保護ビット 0
	CONFIG	EBTR1		= OFF			; テーブル読み出し保護ビット 1
	CONFIG	EBTR2		= OFF			; テーブル読み出し保護ビット 2
	CONFIG	EBTR3		= OFF			; テーブル読み出し保護ビット 3
	; CONFIG7H
	CONFIG	EBTRB		= OFF			; ブートブロック テーブル読み出し保護ビット
#endif

;== end of file ===============================================================;
