// OyaMapPage.cpp : t@C
//

#include "stdafx.h"
#include "afxdialogex.h"
#include "OyaConv.h"
#include "OyaMapPage.h"
#include "KeyCode.h"
#include "KeyModifyDlg.h"

// COyaMapPage _CAO

IMPLEMENT_DYNAMIC(COyaMapPage, CDialogEx)

COyaMapPage::COyaMapPage(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_OYAMAP_VIEW, pParent)
	, m_cwFocus(NULL)
	, m_nShift(0)
	, m_nOya(0)
	, m_bModify(false)
{

}

COyaMapPage::~COyaMapPage()
{
}

void COyaMapPage::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON57, m_cbShiftL);
	DDX_Control(pDX, IDC_BUTTON58, m_cbShiftR);
	DDX_Control(pDX, IDC_BUTTON61, m_cbOyaL);
	DDX_Control(pDX, IDC_BUTTON62, m_cbOyaR);
}


BEGIN_MESSAGE_MAP(COyaMapPage, CDialogEx)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON2, &COyaMapPage::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &COyaMapPage::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &COyaMapPage::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &COyaMapPage::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &COyaMapPage::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &COyaMapPage::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &COyaMapPage::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON9, &COyaMapPage::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &COyaMapPage::OnBnClickedButton10)
	ON_BN_CLICKED(IDC_BUTTON11, &COyaMapPage::OnBnClickedButton11)
	ON_BN_CLICKED(IDC_BUTTON12, &COyaMapPage::OnBnClickedButton12)
	ON_BN_CLICKED(IDC_BUTTON13, &COyaMapPage::OnBnClickedButton13)
	ON_BN_CLICKED(IDC_BUTTON28, &COyaMapPage::OnBnClickedButton28)
	ON_BN_CLICKED(IDC_BUTTON39, &COyaMapPage::OnBnClickedButton39)
	ON_BN_CLICKED(IDC_BUTTON40, &COyaMapPage::OnBnClickedButton40)
	ON_BN_CLICKED(IDC_BUTTON49, &COyaMapPage::OnBnClickedButton49)
	ON_BN_CLICKED(IDC_BUTTON50, &COyaMapPage::OnBnClickedButton50)
	ON_BN_CLICKED(IDC_BUTTON51, &COyaMapPage::OnBnClickedButton51)
	ON_BN_CLICKED(IDC_BUTTON52, &COyaMapPage::OnBnClickedButton52)
	ON_BN_CLICKED(IDC_BUTTON30, &COyaMapPage::OnBnClickedButton30)
	ON_BN_CLICKED(IDC_BUTTON46, &COyaMapPage::OnBnClickedButton46)
	ON_BN_CLICKED(IDC_BUTTON44, &COyaMapPage::OnBnClickedButton44)
	ON_BN_CLICKED(IDC_BUTTON32, &COyaMapPage::OnBnClickedButton32)
	ON_BN_CLICKED(IDC_BUTTON19, &COyaMapPage::OnBnClickedButton19)
	ON_BN_CLICKED(IDC_BUTTON33, &COyaMapPage::OnBnClickedButton33)
	ON_BN_CLICKED(IDC_BUTTON34, &COyaMapPage::OnBnClickedButton34)
	ON_BN_CLICKED(IDC_BUTTON35, &COyaMapPage::OnBnClickedButton35)
	ON_BN_CLICKED(IDC_BUTTON24, &COyaMapPage::OnBnClickedButton24)
	ON_BN_CLICKED(IDC_BUTTON36, &COyaMapPage::OnBnClickedButton36)
	ON_BN_CLICKED(IDC_BUTTON37, &COyaMapPage::OnBnClickedButton37)
	ON_BN_CLICKED(IDC_BUTTON38, &COyaMapPage::OnBnClickedButton38)
	ON_BN_CLICKED(IDC_BUTTON48, &COyaMapPage::OnBnClickedButton48)
	ON_BN_CLICKED(IDC_BUTTON47, &COyaMapPage::OnBnClickedButton47)
	ON_BN_CLICKED(IDC_BUTTON25, &COyaMapPage::OnBnClickedButton25)
	ON_BN_CLICKED(IDC_BUTTON26, &COyaMapPage::OnBnClickedButton26)
	ON_BN_CLICKED(IDC_BUTTON17, &COyaMapPage::OnBnClickedButton17)
	ON_BN_CLICKED(IDC_BUTTON20, &COyaMapPage::OnBnClickedButton20)
	ON_BN_CLICKED(IDC_BUTTON31, &COyaMapPage::OnBnClickedButton31)
	ON_BN_CLICKED(IDC_BUTTON21, &COyaMapPage::OnBnClickedButton21)
	ON_BN_CLICKED(IDC_BUTTON23, &COyaMapPage::OnBnClickedButton23)
	ON_BN_CLICKED(IDC_BUTTON45, &COyaMapPage::OnBnClickedButton45)
	ON_BN_CLICKED(IDC_BUTTON18, &COyaMapPage::OnBnClickedButton18)
	ON_BN_CLICKED(IDC_BUTTON43, &COyaMapPage::OnBnClickedButton43)
	ON_BN_CLICKED(IDC_BUTTON22, &COyaMapPage::OnBnClickedButton22)
	ON_BN_CLICKED(IDC_BUTTON42, &COyaMapPage::OnBnClickedButton42)
END_MESSAGE_MAP()


// COyaMapPage bZ[W nh[

// qEBhE̐
BOOL COyaMapPage::Create(int IDD_VIEW, CWnd* pParentWnd, int nShift)
{
	m_nShift = nShift;
	return CDialogEx::Create(IDD_VIEW, pParentWnd);
}

// 
BOOL COyaMapPage::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	m_cb04.OyaLColorButton(IDC_BUTTON30, this);	// A
	m_cb05.OyaLColorButton(IDC_BUTTON46, this);	// B
	m_cb06.OyaLColorButton(IDC_BUTTON44, this);	// C
	m_cb07.OyaLColorButton(IDC_BUTTON32, this);	// D
	m_cb08.OyaLColorButton(IDC_BUTTON19, this);	// E
	m_cb09.OyaLColorButton(IDC_BUTTON33, this);	// F
	m_cb0A.OyaLColorButton(IDC_BUTTON34, this);	// G
	m_cb0B.OyaRColorButton(IDC_BUTTON35, this);	// H
	m_cb0C.OyaRColorButton(IDC_BUTTON24, this);	// I
	m_cb0D.OyaRColorButton(IDC_BUTTON36, this);	// J
	m_cb0E.OyaRColorButton(IDC_BUTTON37, this);	// K
	m_cb0F.OyaRColorButton(IDC_BUTTON38, this);	// L
	m_cb10.OyaRColorButton(IDC_BUTTON48, this);	// M
	m_cb11.OyaRColorButton(IDC_BUTTON47, this);	// N
	m_cb12.OyaRColorButton(IDC_BUTTON25, this);	// O
	m_cb13.OyaRColorButton(IDC_BUTTON26, this);	// P
	m_cb14.OyaLColorButton(IDC_BUTTON17, this);	// Q
	m_cb15.OyaLColorButton(IDC_BUTTON20, this);	// R
	m_cb16.OyaLColorButton(IDC_BUTTON31, this);	// S
	m_cb17.OyaLColorButton(IDC_BUTTON21, this);	// T
	m_cb18.OyaRColorButton(IDC_BUTTON23, this);	// U
	m_cb19.OyaLColorButton(IDC_BUTTON45, this);	// V
	m_cb1A.OyaLColorButton(IDC_BUTTON18, this);	// W
	m_cb1B.OyaLColorButton(IDC_BUTTON43, this);	// X
	m_cb1C.OyaRColorButton(IDC_BUTTON22, this);	// Y
	m_cb1D.OyaLColorButton(IDC_BUTTON42, this);	// Z

	m_cb1E.OyaLColorButton(IDC_BUTTON2, this);	// 1
	m_cb1F.OyaLColorButton(IDC_BUTTON3, this);	// 2
	m_cb20.OyaLColorButton(IDC_BUTTON4, this);	// 3
	m_cb21.OyaLColorButton(IDC_BUTTON5, this);	// 4
	m_cb22.OyaLColorButton(IDC_BUTTON6, this);	// 5
	m_cb23.OyaRColorButton(IDC_BUTTON7, this);	// 6
	m_cb24.OyaRColorButton(IDC_BUTTON8, this);	// 7
	m_cb25.OyaRColorButton(IDC_BUTTON9, this);	// 8
	m_cb26.OyaRColorButton(IDC_BUTTON10, this);	// 9
	m_cb27.OyaRColorButton(IDC_BUTTON11, this);	// 0

	m_cb2D.OyaRColorButton(IDC_BUTTON12, this);	// -
	m_cb2E.OyaRColorButton(IDC_BUTTON13, this);	// ^
	m_cb30.OyaRColorButton(IDC_BUTTON28, this);	// [
	m_cb33.OyaRColorButton(IDC_BUTTON39, this);	// ;
	m_cb34.OyaRColorButton(IDC_BUTTON40, this);	// :
	m_cb36.OyaRColorButton(IDC_BUTTON49, this);	// ,
	m_cb37.OyaRColorButton(IDC_BUTTON50, this);	// .
	m_cb38.OyaRColorButton(IDC_BUTTON51, this);	// /
	m_cb39.OyaRColorButton(IDC_BUTTON52, this);	// _

	BYTE* pMap;
	switch (m_nShift){
	case OYAMAP_SHIFT_LEFT:
		pMap = (BYTE*)Left_Shift_Table;
		m_nOya = 0x108;
		m_cbOyaL.EnableWindow(TRUE);
		m_cb33.SetRedFreme();	// ;
		m_cb34.SetRedFreme();	// :
		m_cb38.SetRedFreme();	// /
		break;
	case OYAMAP_SHIFT_RIGHT:
		pMap = (BYTE*)Right_Shift_Table;
		m_nOya = 0x142;
		m_cbOyaR.EnableWindow(TRUE);
		m_cb14.SetRedFreme();	// Q
		m_cb1D.SetRedFreme();	// Z
		break;
	default :
		pMap = (BYTE*)Non_Shift_Table;
		m_nOya = 0x0CE;
		break;
	}
	for (int i = 0; i < 58; i++) {
		m_ucKeyMap[i] = *(pMap + i);
	}
	SetAllKeyName();
	SetTimer(2, 10, NULL);
	return TRUE;
}

// y[W\
void COyaMapPage::ShowTabPage(int nPage, int nNewPage)
{
	if (nPage != nNewPage) {
		ShowWindow(SW_HIDE);
	}
	else {
		ShowWindow(SW_SHOW);
		SetFocus();
	}
}

// ^C} (tH[JX̎擾)
void COyaMapPage::OnTimer(UINT_PTR nIDEvent)
{
	CWnd* cwFocus = GetFocus();
	int i = IDC_BUTTON1;
	while (i++) {
		CWnd* cwDlgItem = GetDlgItem(i);
		if (cwDlgItem == NULL) break;
		if (cwDlgItem == cwFocus) {
			m_cwFocus = cwFocus;
			break;
		}
	}
	CDialogEx::OnTimer(nIDEvent);
}

// L[ԍL[擾
CString COyaMapPage::GetKeyName(BYTE key)
{
	CKeyCode kc;
	if (m_ucKeyMap[key] == D_C) {
		return kc.UsbCodeToN109Name(key);
	}
	if (m_ucKeyMap[key] != N_C && m_ucKeyMap[key] != N_L) {
		return kc.KanaCodeToName(m_ucKeyMap[key]);
	}
	return _T("");
}

// SẴL[t
void COyaMapPage::SetAllKeyName()
{
	m_cb04.SetWindowTextW( GetKeyName(0x04) );	// A
	m_cb05.SetWindowTextW( GetKeyName(0x05) );	// B
	m_cb06.SetWindowTextW( GetKeyName(0x06) );	// C
	m_cb07.SetWindowTextW( GetKeyName(0x07) );	// D
	m_cb08.SetWindowTextW( GetKeyName(0x08) );	// E
	m_cb09.SetWindowTextW( GetKeyName(0x09) );	// F
	m_cb0A.SetWindowTextW( GetKeyName(0x0A) );	// G
	m_cb0B.SetWindowTextW( GetKeyName(0x0B) );	// H
	m_cb0C.SetWindowTextW( GetKeyName(0x0C) );	// I
	m_cb0D.SetWindowTextW( GetKeyName(0x0D) );	// J
	m_cb0E.SetWindowTextW( GetKeyName(0x0E) );	// K
	m_cb0F.SetWindowTextW( GetKeyName(0x0F) );	// L
	m_cb10.SetWindowTextW( GetKeyName(0x10) );	// M
	m_cb11.SetWindowTextW( GetKeyName(0x11) );	// N
	m_cb12.SetWindowTextW( GetKeyName(0x12) );	// O
	m_cb13.SetWindowTextW( GetKeyName(0x13) );	// P
	m_cb14.SetWindowTextW( GetKeyName(0x14) );	// Q
	m_cb15.SetWindowTextW( GetKeyName(0x15) );	// R
	m_cb16.SetWindowTextW( GetKeyName(0x16) );	// S
	m_cb17.SetWindowTextW( GetKeyName(0x17) );	// T
	m_cb18.SetWindowTextW( GetKeyName(0x18) );	// U
	m_cb19.SetWindowTextW( GetKeyName(0x19) );	// V
	m_cb1A.SetWindowTextW( GetKeyName(0x1A) );	// W
	m_cb1B.SetWindowTextW( GetKeyName(0x1B) );	// X
	m_cb1C.SetWindowTextW( GetKeyName(0x1C) );	// Y
	m_cb1D.SetWindowTextW( GetKeyName(0x1D) );	// Z

	m_cb1E.SetWindowTextW(GetKeyName(0x1E));	// 1
	m_cb1F.SetWindowTextW(GetKeyName(0x1F));	// 2
	m_cb20.SetWindowTextW(GetKeyName(0x20));	// 3
	m_cb21.SetWindowTextW(GetKeyName(0x21));	// 4
	m_cb22.SetWindowTextW(GetKeyName(0x22));	// 5
	m_cb23.SetWindowTextW(GetKeyName(0x23));	// 5
	m_cb24.SetWindowTextW(GetKeyName(0x24));	// 7
	m_cb25.SetWindowTextW(GetKeyName(0x25));	// 8
	m_cb26.SetWindowTextW(GetKeyName(0x26));	// 9
	m_cb27.SetWindowTextW(GetKeyName(0x27));	// 0

	m_cb2D.SetWindowTextW(GetKeyName(0x2D));	// -
	m_cb2E.SetWindowTextW(GetKeyName(0x2E));	// ^
	m_cb30.SetWindowTextW(GetKeyName(0x30));	// [
	m_cb33.SetWindowTextW(GetKeyName(0x33));	// ;
	m_cb34.SetWindowTextW(GetKeyName(0x34));	// :
	m_cb36.SetWindowTextW(GetKeyName(0x36));	// ,
	m_cb37.SetWindowTextW(GetKeyName(0x37));	// .
	m_cb38.SetWindowTextW(GetKeyName(0x38));	// /
	m_cb39.SetWindowTextW(GetKeyName(0x39));	// _
}

// }bvL[}bv֐ݒ
void COyaMapPage::SetKeyMap(BYTE* pMap)
{
	if (pMap != nullptr) {
		for (int i = 0; i < 58; i++) {
			m_ucKeyMap[i] = *(pMap + m_nOya + i);
		}
	}
	SetAllKeyName();
}

// L[}bv}bv֐ݒ
BYTE* COyaMapPage::GetKeyMap(BYTE* pMap)
{
	if (pMap != nullptr) {
		for (int i = 0; i < 58; i++) {
			*(pMap + m_nOya + i) = m_ucKeyMap[i];
		}
	}
	return pMap;
}

// L[R[hI_CAO
BYTE COyaMapPage::SelectKeyCode(int key, CString* kanalisit, CString csel/*=_T("")*/)
{
	CKeyCode kc;
	CKeyModifyDlg dlg;
	if (m_nShift == OYAMAP_NO_SHIFT)		dlg.m_csKeyTopName = _T("ewVtg");
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	dlg.m_csKeyTopName = _T("ewVtg");
	else 									dlg.m_csKeyTopName = _T("ewVtgE");
	dlg.m_psKeyList = kanalisit;
	dlg.m_csSelKey = (csel.IsEmpty())? kc.KanaCodeToName(m_ucKeyMap[key]) : csel;
	dlg.DoModal();
	// XV
	BYTE ret = kc.KanaNameToCode(dlg.m_csSelKey);
	if (ret != m_ucKeyMap[key]) {
		m_ucKeyMap[key] = ret;
		m_bModify = true;
	}
	return ret;
}

// 1L[
void COyaMapPage::OnBnClickedButton2()
{
	CString* keylist;
	CString list1[] = { D1C.moji, 	_T("") };
	CString list2[] = { QUS.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D1C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x1E, keylist, sel);
}

// 2L[
void COyaMapPage::OnBnClickedButton3()
{
	CString* keylist;
	CString list1[] = { D2C.moji, 	_T("") };
	CString list2[] = { SLH.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D2C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x1F, keylist, sel);
}

// 3L[
void COyaMapPage::OnBnClickedButton4()
{
	CString* keylist;
	CString list1[] = { D3C.moji, 	_T("") };
	CString list2[] = { TLD.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D3C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x20, keylist, sel);
}

// 4L[
void COyaMapPage::OnBnClickedButton5()
{
	CString* keylist;
	CString list1[] = { D4C.moji, 	_T("") };
	CString list2[] = { LKK.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D4C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x21, keylist, sel);
}

// 5L[
void COyaMapPage::OnBnClickedButton6()
{
	CString* keylist;
	CString list1[] = { D5C.moji, 	_T("") };
	CString list2[] = { RKK.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D5C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x22, keylist, sel);
}

// 6L[
void COyaMapPage::OnBnClickedButton7()
{
	CString* keylist;
	CString list1[] = { D6C.moji, 	_T("") };
	CString list2[] = { LSB.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D6C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x23, keylist, sel);
}

// 7L[
void COyaMapPage::OnBnClickedButton8()
{
	CString* keylist;
	CString list1[] = { D7C.moji, 	_T("") };
	CString list2[] = { RSB.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D7C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x24, keylist, sel);
}

// 8L[
void COyaMapPage::OnBnClickedButton9()
{
	CString* keylist;
	CString list1[] = { D8C.moji, 	_T("") };
	CString list2[] = { LBT.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D8C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x25, keylist, sel);
}

// 9L[
void COyaMapPage::OnBnClickedButton10()
{
	CString* keylist;
	CString list1[] = { D9C.moji, 	_T("") };
	CString list2[] = { RBT.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D9C.moji;
	}
	else {
		keylist = list2;
	}
	SelectKeyCode(0x26, keylist, sel);
}

// 0L[
void COyaMapPage::OnBnClickedButton11()
{
	CString* keylist;
	CString list1[] = { D0C.moji, 	_T("") };
	CString list2[] = { NxC.moji, 	_T("") };
	CString list3[] = { NxC.moji, 	_T("") };
	CString sel = _T("");
	if (m_nShift == OYAMAP_NO_SHIFT) {
		keylist = list1;
		sel = D0C.moji;
	}
	else if (m_nShift == OYAMAP_SHIFT_LEFT) {
		keylist = list2;
	}
	else {
		keylist = list3;
	}
	SelectKeyCode(0x27, keylist, sel);
}

// -L[
void COyaMapPage::OnBnClickedButton12()
{
	CString* keylist;
	CString list1[] = { MUS.moji, 	_T("") };
	CString list2[] = { NxC.moji, 	_T("") };
	CString list3[] = { NxC.moji, 	_T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x2D, keylist);
}

// ^L[
void COyaMapPage::OnBnClickedButton13()
{
	CString* keylist;
	CString list1[] = { VLN.moji, 	_T("") };
	CString list2[] = { YEN.moji, 	_T("") };
	CString list3[] = { YEN.moji, 	_T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x2E, keylist);
}

// [L[
void COyaMapPage::OnBnClickedButton28()
{
	CString* keylist;
	CString list1[] = { NxC.moji, 	_T("") };
	CString list2[] = { NxC.moji, 	_T("") };
	CString list3[] = { NxC.moji, 	_T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x30, keylist);
}

// ;L[
void COyaMapPage::OnBnClickedButton39()
{
	CString* keylist;
	CString list1[] = { NN_.moji, 	_T("") };
	CString list2[] = { NxC.moji, LKE.moji,	_T("") };
	CString list3[] = { LTU.moji, 	_T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x33, keylist);
	m_cb33.SetWindowTextW(GetKeyName(0x33));
}

// :L[
void COyaMapPage::OnBnClickedButton40()
{
	CString* keylist;
	CString list1[] = { KGR.moji, 	_T("") };
	CString list2[] = { NxC.moji, LKA.moji, _T("") };
	CString list3[] = { NxC.moji, 	_T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x34, keylist);
	m_cb34.SetWindowTextW(GetKeyName(0x34));
}

// ,L[
void COyaMapPage::OnBnClickedButton49()
{
	CString* keylist;
	CString list1[] = { NE_.moji, _T("") };
	CString list2[] = { PE_.moji, _T("") };
	CString list3[] = { MU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x36, keylist);
}

// .L[
void COyaMapPage::OnBnClickedButton50()
{
	CString* keylist;
	CString list1[] = { HO_.moji, _T("") };
	CString list2[] = { BO_.moji, _T("") };
	CString list3[] = { WA_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x37, keylist);
}

// /L[
void COyaMapPage::OnBnClickedButton51()
{
	CString* keylist;
	CString list1[] = { TEN.moji, _T("") };
	CString list2[] = { NxC.moji, LWA.moji, _T("") };
	CString list3[] = { LO_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x38, keylist);
	m_cb38.SetWindowTextW(GetKeyName(0x38));
}

// _L[
void COyaMapPage::OnBnClickedButton52()
{
	CString* keylist;
	CString list1[] = { NxC.moji, _T("") };
	CString list2[] = { NxC.moji, _T("") };
	CString list3[] = { NxC.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x39, keylist);
}

// AL[
void COyaMapPage::OnBnClickedButton30()
{
	CString* keylist;
	CString list1[] = { U__.moji, _T("") };
	CString list2[] = { WO_.moji, _T("") };
	CString list3[] = { VU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x04, keylist);
}

// B
void COyaMapPage::OnBnClickedButton46()
{
	CString* keylist;
	CString list1[] = { HE_.moji, _T("") };
	CString list2[] = { LI_.moji, _T("") };
	CString list3[] = { BE_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x05, keylist);
}

// C
void COyaMapPage::OnBnClickedButton44()
{
	CString* keylist;
	CString list1[] = { SU_.moji, _T("") };
	CString list2[] = { RO_.moji, _T("") };
	CString list3[] = { ZU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x06, keylist);
}

// D
void COyaMapPage::OnBnClickedButton32()
{
	CString* keylist;
	CString list1[] = { TE_.moji, _T("") };
	CString list2[] = { NA_.moji, _T("") };
	CString list3[] = { DE_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x07, keylist);
}

// E
void COyaMapPage::OnBnClickedButton19()
{
	CString* keylist;
	CString list1[] = { TA_.moji, _T("") };
	CString list2[] = { RI_.moji, _T("") };
	CString list3[] = { DA_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x08, keylist);
}

// F
void COyaMapPage::OnBnClickedButton33()
{
	CString* keylist;
	CString list1[] = { KE_.moji, _T("") };
	CString list2[] = { LYU.moji, _T("") };
	CString list3[] = { GE_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x09, keylist);
}

// G
void COyaMapPage::OnBnClickedButton34()
{
	CString* keylist;
	CString list1[] = { SE_.moji, _T("") };
	CString list2[] = { MO_.moji, _T("") };
	CString list3[] = { ZE_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0A, keylist);
}

// H
void COyaMapPage::OnBnClickedButton35()
{
	CString* keylist;
	CString list1[] = { HA_.moji, _T("") };
	CString list2[] = { BA_.moji, _T("") };
	CString list3[] = { MI_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0B, keylist);
}

// I
void COyaMapPage::OnBnClickedButton24()
{
	CString* keylist;
	CString list1[] = { KU_.moji, _T("") };
	CString list2[] = { GU_.moji, _T("") };
	CString list3[] = { RU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0C, keylist);
}

// J
void COyaMapPage::OnBnClickedButton36()
{
	CString* keylist;
	CString list1[] = { TO_.moji, _T("") };
	CString list2[] = { DO_.moji, _T("") };
	CString list3[] = { O__.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0D, keylist);
}

// K
void COyaMapPage::OnBnClickedButton37()
{
	CString* keylist;
	CString list1[] = { KI_.moji, _T("") };
	CString list2[] = { GI_.moji, _T("") };
	CString list3[] = { NO_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0E, keylist);
}

// L
void COyaMapPage::OnBnClickedButton38()
{
	CString* keylist;
	CString list1[] = { I__.moji, _T("") };
	CString list2[] = { PO_.moji, _T("") };
	CString list3[] = { LYO.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x0F, keylist);
}

// M
void COyaMapPage::OnBnClickedButton48()
{
	CString* keylist;
	CString list1[] = { SO_.moji, _T("") };
	CString list2[] = { ZO_.moji, _T("") };
	CString list3[] = { YU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x10, keylist);
}

// N
void COyaMapPage::OnBnClickedButton47()
{
	CString* keylist;
	CString list1[] = { ME_.moji, _T("") };
	CString list2[] = { PU_.moji, _T("") };
	CString list3[] = { NU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x11, keylist);
}

// O
void COyaMapPage::OnBnClickedButton25()
{
	CString* keylist;
	CString list1[] = { TU_.moji, _T("") };
	CString list2[] = { DU_.moji, _T("") };
	CString list3[] = { MA_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x12, keylist);
}

// P
void COyaMapPage::OnBnClickedButton26()
{
	CString* keylist;
	CString list1[] = { CMM.moji, _T("") };
	CString list2[] = { PI_.moji, _T("") };
	CString list3[] = { LE_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x13, keylist);
}

// Q
void COyaMapPage::OnBnClickedButton17()
{
	CString* keylist;
	CString list1[] = { OWR.moji, _T("") };
	CString list2[] = { LA_.moji, _T("") };
	CString list3[] = { NxC.moji, WYI.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x14, keylist);
	m_cb14.SetWindowTextW(GetKeyName(0x14));
}

// R
void COyaMapPage::OnBnClickedButton20()
{
	CString* keylist;
	CString list1[] = { KO_.moji, _T("") };
	CString list2[] = { LYA.moji, _T("") };
	CString list3[] = { GO_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x15, keylist);
}

// S
void COyaMapPage::OnBnClickedButton31()
{
	CString* keylist;
	CString list1[] = { SI_.moji, _T("") };
	CString list2[] = { A__.moji, _T("") };
	CString list3[] = { ZI_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x16, keylist);
}

// T
void COyaMapPage::OnBnClickedButton21()
{
	CString* keylist;
	CString list1[] = { SA_.moji, _T("") };
	CString list2[] = { RE_.moji, _T("") };
	CString list3[] = { ZA_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x17, keylist);
}

// U
void COyaMapPage::OnBnClickedButton23()
{
	CString* keylist;
	CString list1[] = { TI_.moji, _T("") };
	CString list2[] = { DI_.moji, _T("") };
	CString list3[] = { NI_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x18, keylist);
}

// V
void COyaMapPage::OnBnClickedButton45()
{
	CString* keylist;
	CString list1[] = { HU_.moji, _T("") };
	CString list2[] = { YA_.moji, _T("") };
	CString list3[] = { BU_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x19, keylist);
}

// W
void COyaMapPage::OnBnClickedButton18()
{
	CString* keylist;
	CString list1[] = { KA_.moji, _T("") };
	CString list2[] = { E__.moji, _T("") };
	CString list3[] = { GA_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x1A, keylist);
}

// X
void COyaMapPage::OnBnClickedButton43()
{
	CString* keylist;
	CString list1[] = { HI_.moji, _T("") };
	CString list2[] = { HYP.moji, _T("") };
	CString list3[] = { BI_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x1B, keylist);
}

// Y
void COyaMapPage::OnBnClickedButton22()
{
	CString* keylist;
	CString list1[] = { RA_.moji, _T("") };
	CString list2[] = { PA_.moji, _T("") };
	CString list3[] = { YO_.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x1C, keylist);
}

// Z
void COyaMapPage::OnBnClickedButton42()
{
	CString* keylist;
	CString list1[] = { DOT.moji, _T("") };
	CString list2[] = { LU_.moji, _T("") };
	CString list3[] = { NxC.moji, WYE.moji, _T("") };
	if (m_nShift == OYAMAP_NO_SHIFT)		keylist = list1;
	else if (m_nShift == OYAMAP_SHIFT_LEFT)	keylist = list2;
	else									keylist = list3;
	SelectKeyCode(0x1D, keylist);
	m_cb1D.SetWindowTextW(GetKeyName(0x1D));
}

// returnL[̗}~
void COyaMapPage::OnOK()
{
//	CDialogEx::OnOK();
}

// ESCL[̗}~
void COyaMapPage::OnCancel()
{
//	CDialogEx::OnCancel();
}
