#pragma once
#include "afx.h"

/** Typedef *******************************************************************/
typedef	BYTE uint8_t;		// uint8_t == BYTE (PIC XC8ƌ݊̂)

/** define *******************************************************************/
#define MAP_SIZE 512		// L[}bvTCY

/** USB Usage ID **************************************************************/
//		L[		ID		FMT L[gbv
#define	KEY_A		0x04	//[A]L[
#define	KEY_B		0x05	//[B]L[
#define	KEY_C		0x06	//[C]L[
#define	KEY_D		0x07	//[D]L[
#define	KEY_E		0x08	//[E]L[
#define	KEY_F		0x09	//[F]L[
#define	KEY_G		0x0A	//[G]L[
#define	KEY_H		0x0B	//[H]L[
#define	KEY_I		0x0C	//[I]L[
#define	KEY_J		0x0D	//[J]L[
#define	KEY_K		0x0E	//[K]L[
#define	KEY_L		0x0F	//[L]L[
#define	KEY_M		0x10	//[M]L[
#define	KEY_N		0x11	//[N]L[
#define	KEY_O		0x12	//[O]L[
#define	KEY_P		0x13	//[P]L[
#define	KEY_Q		0x14	//[Q]L[
#define	KEY_R		0x15	//[R]L[
#define	KEY_S		0x16	//[S]L[
#define	KEY_T		0x17	//[T]L[
#define	KEY_U		0x18	//[U]L[
#define	KEY_V		0x19	//[V]L[
#define	KEY_W		0x1A	//[W]L[
#define	KEY_X		0x1B	//[X]L[
#define	KEY_Y		0x1C	//[Y]L[
#define	KEY_Z		0x1D	//[Z]L[
#define	KEY_M1		0x1E	//[1]L[
#define	KEY_M2		0x1F	//[2]L[
#define	KEY_M3		0x20	//[3]L[
#define	KEY_M4		0x21	//[4]L[
#define	KEY_M5		0x22	//[5]L[
#define	KEY_M6		0x23	//[6]L[
#define	KEY_M7		0x24	//[7]L[
#define	KEY_M8		0x25	//[8]L[
#define	KEY_M9		0x26	//[9]L[
#define	KEY_M0		0x27	//[0]L[
#define	KEYENTER	0x28	//[ENTER]L[
#define	KEYESC		0x29	//[ESC]L[
#define	KEY_BS		0x2A	//[]L[ (BackSpace)
#define	KEYTAB		0x2B	//[TAB]L[
#define	KEY_SP		0x2C	//[]L[ (Spacebar)
#define	KEYMINUS	0x2D	//[-]L[
#define	KEYHAT		0x2E	//[^]L[
#define	KEY_ATT		0x2F	//[@]L[ *JIS
#define	KEYLSB		0x30	//[[]L[
//
#define	KEYRSB		0x32	//[]]L[
#define	KEYSCLN		0x33	//[;]L[
#define	KEYCLN		0x34	//[:]L[
#define	KEYHAZE		0x35	//[p/Sp]L[
#define	KEYCOMMA	0x36	//[,]L[
#define	KEYPERIOD	0x37	//[.]L[
#define	KEYSLASH	0x38	//[/]L[
#define	KEYEISU		0x39	//[p]L[ (p/CapsLock)
#define	KEY_F1		0x3A	//[F1]L[
#define	KEY_F2		0x3B	//[F2]L[
#define	KEY_F3		0x3C	//[F3]L[
#define	KEY_F4		0x3D	//[F4]L[
#define	KEY_F5		0x3E	//[F5]L[
#define	KEY_F6		0x3F	//[F6]L[
#define	KEY_F7		0x40	//[F7]L[
#define	KEY_F8		0x41	//[F8]L[
#define	KEY_F9		0x42	//[F9]L[
#define	KEY_F10		0x43	//[F10]L[
#define	KEY_F11		0x44	//[F11]L[
#define	KEY_F12		0x45	//[F12]L[
#define	KEYCOPY		0x46	//[COPY]L[ (PreintScreen)
#define	KEYSCRLOCK	0x47	//[ScrollLock]L[
#define	KEYPAUSE	0x48	//[Pause]L[
#define	KEYINSERT	0x49	//[}]L[ (Insert)
#define	KEYHOME		0x4A	//[Home]L[
#define	KEYPUP		0x4B	//[Os]L[ (PageUp)
#define	KEYDELETE	0x4C	//[폜]L[ (Delete)
#define	KEYEND		0x4D	//[END]L[
#define	KEYPDOWN	0x4E	//[s]L[ (PageDown)
#define	KEYRARROW	0x4F	//[]L[
#define	KEYLARROW	0x50	//[]L[
#define	KEYDARROW	0x51	//[]L[
#define	KEYUARROW	0x52	//[]L[
#define	KEYNUMLOCK	0x53	// ([NumLock]L[)
#define	KEY_TSLA	0x54	//[T/]L[
#define	KEY_TAST	0x55	//[T*]L[
#define	KEY_TNUS	0x56	//[T-]L[
#define	KEY_TPLS	0x57	//[T+]L[
#define	KEY_TENT	0x58	//[T Enter]L[
#define	KEY_T1		0x59	//[T1]L[
#define	KEY_T2		0x5A	//[T2]L[
#define	KEY_T3		0x5B	//[T3]L[
#define	KEY_T4		0x5C	//[T4]L[
#define	KEY_T5		0x5D	//[T5]L[
#define	KEY_T6		0x5E	//[T6]L[
#define	KEY_T7		0x5F	//[T7]L[
#define	KEY_T8		0x60	//[T8]L[
#define	KEY_T9		0x61	//[T9]L[
#define	KEY_T0		0x62	//[T0]L[
#define	KEY_TCMA	0x63	//[T.]L[
//
#define	KEYAPL		0x65	//[EXT2]L[ (Application)
//
#define	KEY_TEQU	0x67	//[T=]L[
#define	KEY_F13		0x68	//[F13]L[
#define	KEY_F14		0x69	//[F14]L[
#define	KEY_F15		0x6A	//[F15]L[
#define	KEY_F16		0x6B	//[F16]L[
#define	KEY_F17		0x6C	//[F17]L[
#define	KEY_F18		0x6D	//[F18]L[
#define	KEY_F19		0x6E	//[F19]L[
#define	KEY_F20		0x6F	//[F20]L[
#define	KEY_F21		0x70	//[F21]L[
#define	KEY_F22		0x71	//[F22]L[
#define	KEY_F23		0x72	//[F23]L[
#define	KEY_F24		0x73	//[F24]L[
#define	KEYEXECUTE	0x74	//[s]L[ (Execute)
//
#define	KEYUDLN		0x87	//[_]L[
#define	KEYHIKA		0x88	//[p]L[ (Ђ炪/J^Ji) *oya
#define	KEYYEN		0x89	//[\]L[
#define	KEYXFER		0x8A	//[ϊ]L[
#define	KEYNFER		0x8B	//[ϊ]L[
//
#define	KEYOYAR		0x8E	//[ewE]L[
#define	KEYOYAL		0x8F	//[ew]L[
//
#define	KEYKATA		0x92	//[J^Ji]L[ *JIS
#define	KEYHIRA		0x93	//[Ђ炪]L[ *JIS
//
#define	KEYSYSREQ	0x9A	//[SYSREQ]L[ (SysReq/Attention)
#define	KEYCANCEL	0x9B	//[]L[ (Cansel)
//
#define	KEY_T000	0xB1	//[T000]L[
//
#define	KEYLCTRL	0xE0	//[CTRL]L[()
#define	KEYLSHIFT	0xE1	//[SHIFT]L[()
#define	KEYLALT		0xE2	//[ALT]L[()
#define	KEYLGUI		0xE3	//[EXT1]L[() (GUI)
#define	KEYRCTRL	0xE4	// ([CTRL]L[(E))
#define	KEYRSHIFT	0xE5	// ([SHIFT]L[(E))
#define	KEYRALT		0xE6	// ([ALT]L[(E))
#define	KEYRGUI		0xE7	// ([GUI]L[(E))

/** Romaji Code ***************************************************************/
// [}R[h^LR[h
#define N_L			0x00	// Normal		ʏHID L[R[hƂďo
#define N_C			0x01	// No Code		ĂHID L[R[ho͂Ȃ
#define D_C			0x02	// Dlay Code	莞ԒxHID L[R[hƂďo
							//				(ewVtgL[xĉ鎖l)
/******************************************************************************/
// [}R[h^LR[h 1byte 
#define	kana1code	a__
#define a__			0x04	// 
#define i__			0x05	// 
#define u__			0x06	// 
#define e__			0x07	// 
#define o__			0x08	// 

/******************************************************************************/
// [}R[h^LR[h 2byte 
#define	kana2code	ka_
#define ka_			0x10	// 
#define ki_			0x11	// 
#define ku_			0x12	// 
#define ke_			0x13	// 
#define ko_			0x14	// 

#define sa_			0x15	// 
#define si_			0x16	// 
#define su_			0x17	// 
#define se_			0x18	// 
#define so_			0x19	// 

#define ta_			0x1A	// 
#define ti_			0x1B	// 
#define tu_			0x1C	// 
#define te_			0x1D	// 
#define to_			0x1E	// 

#define na_			0x1F	// 
#define ni_			0x20	// 
#define nu_			0x21	// 
#define ne_			0x22	// 
#define no_			0x23	// 

#define ha_			0x24	// 
#define hi_			0x25	// 
#define hu_			0x26	// 
#define he_			0x27	// 
#define ho_			0x28	// 

#define ma_			0x29	// 
#define mi_			0x2A	// 
#define mu_			0x2B	// 
#define me_			0x2C	// 
#define mo_			0x2D	// 

#define ya_			0x2E	// 
#define yu_			0x2F	// 
#define yo_			0x30	// 

#define ra_			0x31	// 
#define ri_			0x32	// 
#define ru_			0x33	// 
#define re_			0x34	// 
#define ro_			0x35	// 

#define wa_			0x36	// 
#define wo_			0x37	// 
#define nn_			0x38	// 

#define ga_			0x39	// 
#define gi_			0x3A	// 
#define gu_			0x3B	// 
#define ge_			0x3C	// 
#define go_			0x3D	// 

#define za_			0x3E	// 
#define zi_			0x3F	// 
#define zu_			0x40	// 
#define ze_			0x41	// 
#define zo_			0x42	// 

#define da_			0x43	// 
#define di_			0x44	// 
#define du_			0x45	// 
#define de_			0x46	// 
#define do_			0x47	// 

#define ba_			0x48	// 
#define bi_			0x49	// 
#define bu_			0x4A	// 
#define be_			0x4B	// 
#define bo_			0x4C	// 

#define pa_			0x4D	// 
#define pi_			0x4E	// 
#define pu_			0x4F	// 
#define pe_			0x50	// 
#define po_			0x51	// 

#define la_			0x52	// 
#define li_			0x53	// 
#define lu_			0x54	// 
#define le_			0x55	// 
#define lo_			0x56	// 

#define vu_			0x57	// 

/******************************************************************************/
// [}R[h^LR[h 3byte 
#define	kana3code	ltu
#define ltu			0x60	// 

#define lya			0x61	// 
#define lyu			0x62	// 
#define lyo			0x63	// 

#define lka			0x64	// 
#define lke			0x65	// 

#define lwa			0x66	// 
#define wyi			0x67	// 
#define wye			0x68	// 

/******************************************************************************/
// [}R[h^LR[h 1byte L
#define	kigou1code	lkk
#define lkk			0x70	//	u	()
#define rkk			0x71	//	v	(E)
#define kgr			0x72	//	A	(؂)
#define owr			0x73	//	B	(I)
#define ten			0x74	//	E	(_)
#define yen			0x75	//		(~L)
#define hyp			0x76	//	-	(nCt)

/******************************************************************************/
// [}R[h^LR[h [shift]L[t 1byte L
#define	kigou2code	equ
#define equ			0x80	//	=	(CR[)
#define qus			0x81	//	H	(NGX`)
#define tld			0x82	//	`	(`_)
#define lbt			0x83	//	i	(tg vPbc)
#define rbt			0x84	//	j	(Cg vPbc)
#define vln			0x85	//	b	(o[eBJ C)

/******************************************************************************/
// [}R[h^LR[h Spp 1byte L
#define	kigou3code	slh
#define slh			0x90	//	/	(XbV)
#define mus			0x91	//	-	(}CiX)
#define lsb			0x92	//	m	(tg XNGA vPbc)
#define rsb			0x93	//	n	(Cg XNGA vPbc)
#define cmm			0x94	//	C	(J})
#define dot			0x95	//	D	(hbg)

/******************************************************************************/
#define	keyEndcode	0xA0	// [}IR[h

/** Fixed number **************************************************************/
// HID L[R[h 1byte 
const uint8_t kana1[6] /*@ 0x3E00*/ = {
	KEY_A,						//		"a",	
	KEY_I,						//		"i",	
	KEY_U,						//		"u",	
	KEY_E,						//		"e",	
	KEY_O,						//		"o",	
	0x00
};
/******************************************************************************/
// HID L[R[h 2byte 
const uint8_t kana2[73][2] /*@ 0x3E06*/ = {
	{ KEY_K, KEY_A },			//		"ka",	
	{ KEY_K, KEY_I },			//		"ki",	
	{ KEY_K, KEY_U },			//		"ku",	
	{ KEY_K, KEY_E },			//		"ke",	
	{ KEY_K, KEY_O },			//		"ko",		5

	{ KEY_S, KEY_A },			//		"sa",	
	{ KEY_S, KEY_I },			//		"si",	
	{ KEY_S, KEY_U },			//		"su",	
	{ KEY_S, KEY_E },			//		"se",	
	{ KEY_S, KEY_O },			//		"so",		10

	{ KEY_T, KEY_A },			//		"ta",	
	{ KEY_T, KEY_I },			//		"ti",	
	{ KEY_T, KEY_U },			//		"tu",	
	{ KEY_T, KEY_E },			//		"te",	
	{ KEY_T, KEY_O },			//		"to",		15

	{ KEY_N, KEY_A },			//		"na",	
	{ KEY_N, KEY_I },			//		"ni",	
	{ KEY_N, KEY_U },			//		"nu",	
	{ KEY_N, KEY_E },			//		"ne",	
	{ KEY_N, KEY_O },			//		"no",		20

	{ KEY_H, KEY_A },			//		"ha",	
	{ KEY_H, KEY_I },			//		"hi",	
	{ KEY_H, KEY_U },			//		"hu",	
	{ KEY_H, KEY_E },			//		"he",	
	{ KEY_H, KEY_O },			//		"ho",		25

	{ KEY_M, KEY_A },			//		"ma",	
	{ KEY_M, KEY_I },			//		"mi",	
	{ KEY_M, KEY_U },			//		"mu",	
	{ KEY_M, KEY_E },			//		"me",	
	{ KEY_M, KEY_O },			//		"mo",		30

	{ KEY_Y, KEY_A },			//		"ya",	
	{ KEY_Y, KEY_U },			//		"yu",	
	{ KEY_Y, KEY_O },			//		"yo",		33

	{ KEY_R, KEY_A },			//		"ra",	
	{ KEY_R, KEY_I },			//		"ri",	
	{ KEY_R, KEY_U },			//		"ru",	
	{ KEY_R, KEY_E },			//		"re",	
	{ KEY_R, KEY_O },			//		"ro",		38

	{ KEY_W, KEY_A },			//		"wa",	
	{ KEY_W, KEY_O },			//		"wo",	
	{ KEY_N, KEY_N },			//		"nn",		41

	{ KEY_G, KEY_A },			//		"ga",	
	{ KEY_G, KEY_I },			//		"gi",	
	{ KEY_G, KEY_U },			//		"gu",	
	{ KEY_G, KEY_E },			//		"ge",	
	{ KEY_G, KEY_O },			//		"go",		46

	{ KEY_Z, KEY_A },			//		"za",	
	{ KEY_Z, KEY_I },			//		"zi",	
	{ KEY_Z, KEY_U },			//		"zu",	
	{ KEY_Z, KEY_E },			//		"ze",	
	{ KEY_Z, KEY_O },			//		"zo",		51

	{ KEY_D, KEY_A },			//		"da",	
	{ KEY_D, KEY_I },			//		"di",	
	{ KEY_D, KEY_U },			//		"du",	
	{ KEY_D, KEY_E },			//		"de",	
	{ KEY_D, KEY_O },			//		"do",		56

	{ KEY_B, KEY_A },			//		"ba",	
	{ KEY_B, KEY_I },			//		"bi",	
	{ KEY_B, KEY_U },			//		"bu",	
	{ KEY_B, KEY_E },			//		"be",	
	{ KEY_B, KEY_O },			//		"bo",		61

	{ KEY_P, KEY_A },			//		"pa",	
	{ KEY_P, KEY_I },			//		"pi",	
	{ KEY_P, KEY_U },			//		"pu",	
	{ KEY_P, KEY_E },			//		"pe",	
	{ KEY_P, KEY_O },			//		"po",		66

	{ KEY_L, KEY_A },			//		"la",	
	{ KEY_L, KEY_I },			//		"li",	
	{ KEY_L, KEY_U },			//		"lu",	
	{ KEY_L, KEY_E },			//		"le",	
	{ KEY_L, KEY_O },			//		"lo",		71

	{ KEY_V, KEY_U },			//		"vu",	
	{ 0x00, 0x00 }				//					73
};
/******************************************************************************/
// HID L[R[h 3byte 
const uint8_t kana3[10][3] /*@ 0x3E98*/ = {
	{ KEY_L, KEY_T, KEY_U },	//		"ltu",	

	{ KEY_L, KEY_Y, KEY_A },	//		"lya",	
	{ KEY_L, KEY_Y, KEY_U },	//		"lyu",	
	{ KEY_L, KEY_Y, KEY_O },	//		"lyo",	

	{ KEY_L, KEY_K, KEY_A },	//		"lka",	
	{ KEY_L, KEY_K, KEY_E },	//		"lke",	

	{ KEY_L, KEY_W, KEY_A },	//		"lwa",	
	{ KEY_W, KEY_Y, KEY_I },	//		"wyi",	
	{ KEY_W, KEY_Y, KEY_E },	//		"wye",	
	{ 0x00, 0x00, 0x00 }
};
/******************************************************************************/
// HID L[R[h 1byte L
const uint8_t kigou1[8] /*@ 0x3EB6*/ = {
	KEYLSB,						//		"[",	u
	KEYRSB,						//		"]",	v
	KEYCOMMA,					//		",",	A
	KEYPERIOD,					//		".",	B
	KEYSLASH,					//		"/",	E
	KEYYEN,						//		"\",	
	KEYMINUS,					//		"-",	[
	0x00
};
/******************************************************************************/
// HID L[R[h [shift]L[t 1byte L
const uint8_t kigou2[8] /*@ 0x3EBE*/ = {
	KEYMINUS,					//	"shift+-",	=
	KEYSLASH,					//	"shif+/",	H
	KEYHAT,						//	"shif+O",	`
	KEY_M8,						//	"shif+8",	i
	KEY_M9,						//	"shif+9",	j
	KEYYEN,						//	"shif+\",	b
	0x00,
	0x00
};
/******************************************************************************/
// HID L[R[h Spp 1byte L
const uint8_t kigou3[8] /*@ 0x3EC6*/ = {
	KEYSLASH,					//		"/",	^
	KEYMINUS,					//		"-",	|
	KEYLSB,						//		"[",	m
	KEYRSB,						//		"]",	n
	KEYCOMMA,					//		",",	C
	KEYPERIOD,					//		".",	D
	0x00,
	0x00
};

/******************************************************************************/
// ewVtg L[z (Vtg)
const uint8_t Non_Shift_Table[58] /*@ 0x3ECE*/ = {
	N_L,		// Reserve		0x00
	N_L,		// RollOver		0x01
	N_L,		// POSTFalt		0x02
	N_L,		// Error		0x03
	u__,		// [a]			0x04
	he_,		// [b]			0x05
	su_,		// [c]			0x06
	te_,		// [d]			0x07
	ta_,		// [e]			0x08
	ke_,		// [f]			0x09
	se_,		// [g]			0x0A
	ha_,		// [h]			0x0B
	ku_,		// [i]			0x0C
	to_,		// [j]			0x0D
	ki_,		// [k]			0x0E
	i__,		// [l]			0x0F
	so_,		// [m]			0x10
	me_,		// [n]			0x11
	tu_,		// [o]			0x12
	cmm,		// [p]			0x13
	owr,		// [q]			0x14
	ko_,		// [r]			0x15
	si_,		// [s]			0x16
	sa_,		// [t]			0x17
	ti_,		// [u]			0x18
	hu_,		// [v]			0x19
	ka_,		// [w]			0x1A
	hi_,		// [x]			0x1B
	ra_,		// [y]			0x1C
	dot,		// [z]			0x1D
	D_C,		// [1]			0x1E
	D_C,		// [2]			0x1F
	D_C,		// [3]			0x20
	D_C,		// [4]			0x21
	D_C,		// [5]			0x22
	D_C,		// [6]			0x23
	D_C,		// [7]			0x24
	D_C,		// [8]			0x25
	D_C,		// [9]			0x26
	D_C,		// [0]			0x27
	N_L,		// [ENTER]		0x28
	N_L,		// [ESC]		0x29
	N_L,		// [BS]			0x2A
	N_L,		// [TAB]		0x2B
	N_L,		// [SP]			0x2C
	mus,		// [-]			0x2D
	vln,		// [^]			0x2E
	kgr,		// [@]			0x2F
	N_C,		// [[]***		0x30
	N_C,		//				0x31
	N_C,		// []]			0x32
	nn_,		// [;]			0x33
	kgr,		// [:]			0x34
	N_L,		// [p/Sp]	0x35
	ne_,		// [,]			0x36
	ho_,		// [.]			0x37
	ten,		// [/]			0x38
	N_C,		// [_]			0x39
};

/******************************************************************************/
// ewVtg L[z (Vtg)
const uint8_t Left_Shift_Table[58] /*@ 0x3F08*/ = {
	N_L,		// Reserve		0x00
	N_L,		// RollOver		0x01
	N_L,		// POSTFalt		0x02
	N_L,		// Error		0x03
	wo_,		// [a]			0x04
	li_,		// [b]			0x05
	ro_,		// [c]			0x06
	na_,		// [d]			0x07
	ri_,		// [e]			0x08
	lyu,		// [f]			0x09
	mo_,		// [g]			0x0A
	ba_,		// [h]			0x0B
	gu_,		// [i]			0x0C
	do_,		// [j]			0x0D
	gi_,		// [k]			0x0E
	po_,		// [l]			0x0F
	zo_,		// [m]			0x10
	pu_,		// [n]			0x11
	du_,		// [o]			0x12
	pi_,		// [p]			0x13
	la_,		// [q]			0x14
	lya,		// [r]			0x15
	a__,		// [s]			0x16
	re_,		// [t]			0x17
	di_,		// [u]			0x18
	ya_,		// [v]			0x19
	e__,		// [w]			0x1A
	hyp,		// [x]			0x1B
	pa_,		// [y]			0x1C
	lu_,		// [z]			0x1D
	qus,		// [1]			0x1E
	slh,		// [2]			0x1F
	tld,		// [3]			0x20
	lkk,		// [4]			0x21
	rkk,		// [5]			0x22
	lsb,		// [6]			0x23
	rsb,		// [7]			0x24
	lbt,		// [8]			0x25
	rbt,		// [9]			0x26
	N_C,		// [0]***		0x27
	N_L,		// [ENTER]		0x28
	N_L,		// [ESC]		0x29
	N_L,		// [BS]			0x2A
	N_L,		// [TAB]		0x2B
	N_L,		// [SP]			0x2C
	N_C,		// [-]***		0x2D
	yen,		// [^]			0x2E
	N_C,		// [@]			0x2F
	N_C,		// [[]			0x30
	N_C,		//				0x31
	N_C,		// []]			0x32
	N_C,		// [;]			0x33
	N_C,		// [:]			0x34
	N_L,		// [p/Sp]	0x35
	pe_,		// [,]			0x36
	bo_,		// [.]			0x37
	N_C,		// [/]			0x38
	N_C,		// [_]			0x39
};

/******************************************************************************/
// ewVtg L[z (EVtg)
const uint8_t Right_Shift_Table[58] /*@ 0x3F42*/ = {
	N_L,		// Reserve		0x00
	N_L,		// RollOver		0x01
	N_L,		// POSTFalt		0x02
	N_L,		// Error		0x03
	vu_,		// [a]			0x04
	be_,		// [b]			0x05
	zu_,		// [c]			0x06
	de_,		// [d]			0x07
	da_,		// [e]			0x08
	ge_,		// [f]			0x09
	ze_,		// [g]			0x0A
	mi_,		// [h]			0x0B
	ru_,		// [i]			0x0C
	o__,		// [j]			0x0D
	no_,		// [k]			0x0E
	lyo,		// [l]			0x0F
	yu_,		// [m]			0x10
	nu_,		// [n]			0x11
	ma_,		// [o]			0x12
	le_,		// [p]			0x13
	N_C,		// [q]			0x14
	go_,		// [r]			0x15
	zi_,		// [s]			0x16
	za_,		// [t]			0x17
	ni_,		// [u]			0x18
	bu_,		// [v]			0x19
	ga_,		// [w]			0x1A
	bi_,		// [x]			0x1B
	yo_,		// [y]			0x1C
	N_C,		// [z]			0x1D
	qus,		// [1]			0x1E
	slh,		// [2]			0x1F
	tld,		// [3]			0x20
	lkk,		// [4]			0x21
	rkk,		// [5]			0x22
	lsb,		// [6]			0x23
	rsb,		// [7]			0x24
	lbt,		// [8]			0x25
	rbt,		// [9]			0x26
	N_C,		// [0]***		0x27
	N_L,		// [ENTER]		0x28
	N_L,		// [ESC]		0x29
	N_L,		// [BS]			0x2A
	N_L,		// [TAB]		0x2B
	N_L,		// [SP]			0x2C
	N_C,		// [-]***		0x2D
	yen,		// [^]			0x2E
	N_C,		// [@]			0x2F
	N_C,		// [[]***		0x30
	N_C,		//				0x31
	N_C,		// []]			0x32
	ltu,		// [;]			0x33
	N_C,		// [:]***		0x34
	N_L,		// [p/Sp]	0x35
	mu_,		// [,]			0x36
	wa_,		// [.]			0x37
	lo_,		// [/]			0x38
	N_C,		// [_]			0x39
};
/******************************************************************************/
// FMTUSBւ̕ϊe[u (11ɂȂ悤ɊtĂ܂)
// ʏR[h
const uint8_t FMT_to_USB_CodeTable[126] /*@ 0x3F7C*/ = {
	0x00,		// Key				FMT		OADG	USB
	KEYESC,		// ESC				01		110		29
	KEY_M1,		// 1				02		  2		1E
	KEY_M2,		// 2				03		  3		1F
	KEY_M3,		// 3				04		  4		20
	KEY_M4,		// 4				05		  5		21
	KEY_M5,		// 5				06		  6		22
	KEY_M6,		// 6				07		  7		23
	KEY_M7,		// 7				08		  8		24
	KEY_M8,		// 8				09		  9		25
	KEY_M9,		// 9				0A		 10		26
	KEY_M0,		// 0				0B		 11		27 (*)
	KEYMINUS,	// -				0C		 12		2D
	KEYHAT,		// ^				0D		 13		2E
	KEYYEN,		// \				0E		(14)	89
	KEY_BS,		// BS				0F		 15		2A
	KEYTAB,		// TAB				10		 16		2B
	KEY_Q,		// Q				11		 17		14
	KEY_W,		// W				12		 18		1A
	KEY_E,		// E				13		 19		08
	KEY_R,		// R				14		 20		15
	KEY_T,		// T				15		 21		17
	KEY_Y,		// Y				16		 22		1C
	KEY_U,		// U				17		 23		18
	KEY_I,		// I				18		 24		0C
	KEY_O,		// O				19		 25		12
	KEY_P,		// P				1A		 26		13
	KEY_ATT,	// [@](JIS)			1B		 27		2F
	KEYLSB,		// [				1C		 28		30
	KEYENTER,	// Enter			1D		 43		28
	KEY_A,		// A				1E		 31		04
	KEY_S,		// S				1F		 32		16
	KEY_D,		// D				20		 33		07
	KEY_F,		// F				21		 34		09
	KEY_G,		// G				22		 35		0A
	KEY_H,		// H				23		 36		0B
	KEY_J,		// J				24		 37		0D
	KEY_K,		// K				25		 38		0E
	KEY_L,		// L				26		 39		0F
	KEYSCLN,	// ;				27		 40		33
	KEYCLN,		// :				28		 41		34
	KEYRSB,		// ]				29		 42		32
	KEY_Z,		// Z				2A		 46		1D
	KEY_X,		// X				2B		 47		1B
	KEY_C,		// C				2C		 48		06
	KEY_V,		// V				2D		 49		19
	KEY_B,		// B				2E		 50		05
	KEY_N,		// N				2F		 51		11
	KEY_M,		// M				30		 52		10
	KEYCOMMA,	// ,				31		 53		36
	KEYPERIOD,	// .				32		 54		37
	KEYSLASH,	// /				33		 55		38
	KEYUDLN,	// _				34		 56		87
	KEY_SP,		// 				35		 61		2C
	KEY_TAST,	// T*				36		100		55
	KEY_TSLA,	// T/				37		 95		54
	KEY_TPLS,	// T+				38		106		57
	KEY_TNUS,	// T-				39		105		56
	KEY_T7,		// T7				3A		 91		5F
	KEY_T8,		// T8				3B		 96		60
	KEY_T9,		// T9				3C		101		61
	KEY_TEQU,	// T=				3D				67
	KEY_T4,		// T4				3E		 92		5C
	KEY_T5,		// T5				3F		 97		5D
	KEY_T6,		// T6				40		102		5E
	0x00,		// ()			41
	KEY_T1,		// T1				42		 93		59
	KEY_T2,		// T2				43		 98		5A
	KEY_T3,		// T3				44		103		5B
	KEY_TENT,	// TRET				45		108		58
	KEY_T0,		// T0				46		 99		62
	KEY_TCMA,	// T.				47	    107		63
	KEYINSERT,	// }				48		 75		49
	0x00,		// ()			49
	KEY_T000,	// T000				4A				B1
	KEYDELETE,	// 폜				4B		 76		4C
	0x00,		// ()			4C
	KEYUARROW,	// 				4D		 83		52
	KEYHOME,	// HOME				4E		 80		4A
	KEYLARROW,	// 				4F		 79		50
	KEYDARROW,	// 				50		 84		51
	KEYRARROW,	// E				51		 89		4F
	KEYLCTRL,	// CTRL()			52		 58		E0 
	KEYLSHIFT,	// SHIFT()		53		 44		E1
	0x00,		// ()			54
	KEYEISU,	// [CAPS](JIS)		55				39	[p]
	KEYHIRA,	// [Ђ炪](JIS)	56				93 (shift[Ђ/J^]88)
	KEYNFER,	// ϊ			57		131		8B
	KEYXFER,	// ϊ				58		132		8A
	KEY_F24,	// Ȋ[F24]	59				73
	KEYKATA,	// [J^Ji](JIS)	5A				92 (shiftL[Ђ/J^]88)
	KEY_F12,	// PF12				5B		123		45
	KEYLALT,	// ALT				5C		 60		E2
	KEY_F1,		// PF1				5D		112		3A
	KEY_F2,		// PF2				5E		113		3B
	KEY_F3,		// PF3				5F		114		3C
	KEY_F4,		// PF4				60		115		3D
	KEY_F5,		// PF5				61		116		3E
	KEY_F6,		// PF6				62		117		3F
	KEY_F7,		// PF7				63		118		40
	KEY_F8,		// PF8				64		119		41
	KEY_F9,		// PF9				65		120		42
	KEY_F10,	// PF10				66		121		43
	KEYOYAL,	// ew			67				8F
	KEYOYAR,	// ewE			68				8E
	KEY_F11,	// PF11				69		122		44
	KEYEISU,	// p(OYA)		6A		 30		39	[p]
	KEY_F21,	//  {F21]		6B				70 (Print Screen)
	KEY_F22,	//  [F22]		6C				71 (ScrllLock)
	KEY_F23,	// o^ [F23]		6D				72 (Pause/Brea)
	KEYPUP,		// Os				6E		 85		4B
	KEYHIKA,	// p			6F		 		88
	KEYPDOWN,	// s				70		 86		4E
	KEYHAZE,	// p/Sp		71		  1		35
	KEYESC,		// 	[Cancel]	72				9B	(ESC)
	KEY_TENT,	// s	[Execute]	73				74	(TRET)
	KEY_F13,	// PF13				74				68
	KEY_F14,	// PF14				75				69
	KEYSCRLOCK,	// PF15				76				6A	(ScrllLock)
	KEYNUMLOCK,	// PF16				77				6B	(NumLock)
	KEYEND,		// PF17				78				6C	(END)
	KEYLGUI,	// PF18				79				6D	(Windows right)
	KEYAPL,		// PF19				7A				6E	(Application)
	KEYLALT,	// PF20				7B				6F	(Alt)
	KEYPAUSE,	// PAUSE			7C		126		48	Pause/Break
	KEYCOPY		// COPY				7D		124		46	Print Screen
				//					7E		(gR[h)
				//					7F		(IR[h)
				//					80-FF	(Make/Break/̑)
};
// gR[h
const uint8_t EX_to_USB_CodeTable[6] /*@ 0x3FFA*/ = {
	KEYSYSREQ,	// SYSREQ			5D				9A
	KEYLGUI,	// EXT1				74				6D	(GUI)
	KEYAPL,		// EXT2				78				6E	(Application)
	KEYSCRLOCK,	// SCROLL LOCK		60				47
	KEYHOME,	// HOME				61				4A	(*)
	KEYEND		// END				62				4D
};

/******************************************************************************/
// USB ID - FMT ݕϊe[u
typedef struct _KEY_CODE {
	BYTE	usb;				// USB Usage ID
	CString	oadg;				// OADG 109L[{[h gbv
	BYTE	fmt;				// FMT L[R[h
	CString	name;				// FMT-KB207 L[{[h gbv
}KEY_CODE;

const KEY_CODE	KCDNON		= { 0x00, _T(""),				0x00, _T("") };
const KEY_CODE	KCD_A		= { KEY_A, _T("A"),					0x1E, _T("A") };
const KEY_CODE	KCD_B		= { KEY_B, _T("B"),					0x2E, _T("B") };
const KEY_CODE	KCD_C		= { KEY_C, _T("C"),					0x2C, _T("C") };
const KEY_CODE	KCD_D		= { KEY_D, _T("D"),					0x20, _T("D") };
const KEY_CODE	KCD_E		= { KEY_E, _T("E"),					0x13, _T("E") };
const KEY_CODE	KCD_F		= { KEY_F, _T("F"),					0x21, _T("F") };
const KEY_CODE	KCD_G		= { KEY_G, _T("G"),					0x22, _T("G") };
const KEY_CODE	KCD_H		= { KEY_H, _T("H"),					0x23, _T("H") };
const KEY_CODE	KCD_I		= { KEY_I, _T("I"),					0x18, _T("I") };
const KEY_CODE	KCD_J		= { KEY_J, _T("J"),					0x24, _T("J") };
const KEY_CODE	KCD_K		= { KEY_K, _T("K"),					0x25, _T("K") };
const KEY_CODE	KCD_L		= { KEY_L, _T("L"),					0x26, _T("L") };
const KEY_CODE	KCD_M		= { KEY_M, _T("M"),					0x30, _T("M") };
const KEY_CODE	KCD_N		= { KEY_N, _T("N"),					0x2F, _T("N") };
const KEY_CODE	KCD_O		= { KEY_O, _T("O"),					0x19, _T("O") };
const KEY_CODE	KCD_P		= { KEY_P, _T("P"),					0x1A, _T("P") };
const KEY_CODE	KCD_Q		= { KEY_Q, _T("Q"),					0x11, _T("Q") };
const KEY_CODE	KCD_R		= { KEY_R, _T("R"),					0x14, _T("R") };
const KEY_CODE	KCD_S		= { KEY_S, _T("S"),					0x1F, _T("S") };
const KEY_CODE	KCD_T		= { KEY_T, _T("T"),					0x15, _T("T") };
const KEY_CODE	KCD_U		= { KEY_U, _T("U"),					0x17, _T("U") };
const KEY_CODE	KCD_V		= { KEY_V, _T("V"),					0x2D, _T("V") };
const KEY_CODE	KCD_W		= { KEY_W, _T("W"),					0x12, _T("W") };
const KEY_CODE	KCD_X		= { KEY_X, _T("X"),					0x2B, _T("X") };
const KEY_CODE	KCD_Y		= { KEY_Y, _T("Y"),					0x16, _T("Y") };
const KEY_CODE	KCD_Z		= { KEY_Z, _T("Z"),					0x2A, _T("Z") };
const KEY_CODE	KCD_M1		= { KEY_M1, _T("1"),				0x02, _T("1") };
const KEY_CODE	KCD_M2		= { KEY_M2, _T("2"),				0x03, _T("2") };
const KEY_CODE	KCD_M3		= { KEY_M3, _T("3"),				0x04, _T("3") };
const KEY_CODE	KCD_M4		= { KEY_M4, _T("4"),				0x05, _T("4") };
const KEY_CODE	KCD_M5		= { KEY_M5, _T("5"),				0x06, _T("5") };
const KEY_CODE	KCD_M6		= { KEY_M6, _T("6"),				0x07, _T("6") };
const KEY_CODE	KCD_M7		= { KEY_M7, _T("7"),				0x08, _T("7") };
const KEY_CODE	KCD_M8		= { KEY_M8, _T("8"),				0x09, _T("8") };
const KEY_CODE	KCD_M9		= { KEY_M9, _T("9"),				0x0A, _T("9") };
const KEY_CODE	KCD_M0		= { KEY_M0, _T("0"),				0x0B, _T("0") };
const KEY_CODE	KCDENTER	= { KEYENTER, _T("Enter"),			0x1D, _T("ENTER") };
const KEY_CODE	KCDESC		= { KEYESC, _T("ESC"),				0x01, _T("ESC") };
const KEY_CODE	KCD_BS		= { KEY_BS, _T("Back Space"),		0x0F, _T("") };
const KEY_CODE	KCDTAB		= { KEYTAB, _T("Tab"),				0x10, _T("^u") };
const KEY_CODE	KCD_SP		= { KEY_SP, _T("Space"),			0x35, _T("") };
const KEY_CODE	KCDMINUS	= { KEYMINUS, _T("-"),				0x0C, _T("-") };
const KEY_CODE	KCDHAT		= { KEYHAT, _T("^"),				0x0D, _T("^") };
const KEY_CODE	KCD_ATT		= { KEY_ATT, _T("@"),				0x1B, _T("@") };
const KEY_CODE	KCDLSB		= { KEYLSB, _T("["),				0x1C, _T("[") };
//
const KEY_CODE	KCDRSB		= { KEYRSB, _T("]"),				0x29, _T("]") };
const KEY_CODE	KCDSCLN		= { KEYSCLN, _T(";"),				0x27, _T(";") };
const KEY_CODE	KCDCLN		= { KEYCLN, _T(":"),				0x28, _T(":") };
const KEY_CODE	KCDHAZE		= { KEYHAZE, _T("p / Sp"),		0x71, _T("p / Sp") };
const KEY_CODE	KCDCOMMA	= { KEYCOMMA, _T(","),				0x31, _T(",") };
const KEY_CODE	KCDPERIOD	= { KEYPERIOD, _T("."),				0x32, _T(".") };
const KEY_CODE	KCDSLASH	= { KEYSLASH, _T("/"),				0x33, _T("/") };
const KEY_CODE	KCDCAPS		= { KEYEISU, _T("p / Caps Lock"),0x55, _T("CAPS") };
const KEY_CODE	KCDEISU		= { KEYEISU, _T("p / Caps Lock"),0x6A, _T("p") };
const KEY_CODE	KCD_F1		= { KEY_F1, _T("F1"),				0x5D, _T("PF1") };
const KEY_CODE	KCD_F2		= { KEY_F2, _T("F2"),				0x5E, _T("PF2") };
const KEY_CODE	KCD_F3		= { KEY_F3, _T("F3"),				0x5F, _T("PF3") };
const KEY_CODE	KCD_F4		= { KEY_F4, _T("F4"),				0x60, _T("PF4") };
const KEY_CODE	KCD_F5		= { KEY_F5, _T("F5"),				0x61, _T("PF5") };
const KEY_CODE	KCD_F6		= { KEY_F6, _T("F6"),				0x62, _T("PF6") };
const KEY_CODE	KCD_F7		= { KEY_F7, _T("F7"),				0x63, _T("PF7") };
const KEY_CODE	KCD_F8		= { KEY_F8, _T("F8"),				0x64, _T("PF8") };
const KEY_CODE	KCD_F9		= { KEY_F9, _T("F9"),				0x65, _T("PF9") };
const KEY_CODE	KCD_F10		= { KEY_F10, _T("F10"),				0x66, _T("PF10") };
const KEY_CODE	KCD_F11		= { KEY_F11, _T("F11"),				0x69, _T("PF11") };
const KEY_CODE	KCD_F12		= { KEY_F12, _T("F12"),				0x5B, _T("PF12") };
const KEY_CODE	KCDCOPY		= { KEYCOPY, _T("Preint Screen"),	0x7D, _T("COPY") };
const KEY_CODE	KCDSCRLOCK	= { KEYSCRLOCK, _T("Scroll Lock"),	0x81, _T("SCROLL LOCK") };
const KEY_CODE	KCDPAUSE	= { KEYPAUSE, _T("Pause / SysReq"),	0x7C, _T("PAUSE") };
const KEY_CODE	KCDINSERT	= { KEYINSERT, _T("Insert"),		0x48, _T("}") };
const KEY_CODE	KCDHOME		= { KEYHOME, _T("Home"),			0x4E, _T("HOME") };
const KEY_CODE	KCDHOME2	= { KEYHOME, _T("Home"),			0x82, _T("HOME") };
const KEY_CODE	KCDPUP		= { KEYPUP, _T("Page Up"),			0x6E, _T("Os") };
const KEY_CODE	KCDDELETE	= { KEYDELETE, _T("Delete"),		0x4B, _T("폜") };
const KEY_CODE	KCDEND		= { KEYEND, _T("End"),				0x83, _T("END") };
const KEY_CODE	KCDPDOWN	= { KEYPDOWN, _T("Page Down"),		0x70, _T("s") };
const KEY_CODE	KCDRARROW	= { KEYRARROW, _T(""),			0x51, _T("") };
const KEY_CODE	KCDLARROW	= { KEYLARROW, _T(""),			0x4F, _T("") };
const KEY_CODE	KCDDARROW	= { KEYDARROW, _T(""),			0x50, _T("") };
const KEY_CODE	KCDUARROW	= { KEYUARROW, _T(""),			0x4D, _T("") };
const KEY_CODE	KCDNUMLOCK	= { KEYNUMLOCK, _T("Num Lock"),		0x00, _T("") };
const KEY_CODE	KCD_TSLA	= { KEY_TSLA, _T("T/"),				0x37, _T("T/") };
const KEY_CODE	KCD_TAST	= { KEY_TAST, _T("T*"),				0x36, _T("T*") };
const KEY_CODE	KCD_TNUS	= { KEY_TNUS, _T("T-"),				0x39, _T("T-") };
const KEY_CODE	KCD_TPLS	= { KEY_TPLS, _T("T+"),				0x38, _T("T+") };
const KEY_CODE	KCD_TENT	= { KEY_TENT, _T("T_Enter"),		0x45, _T("T ENTER") };
const KEY_CODE	KCD_T1		= { KEY_T1, _T("T1"),				0x42, _T("T1") };
const KEY_CODE	KCD_T2		= { KEY_T2, _T("T2"),				0x43, _T("T2") };
const KEY_CODE	KCD_T3		= { KEY_T3, _T("T3"),				0x44, _T("T3") };
const KEY_CODE	KCD_T4		= { KEY_T4, _T("T4"),				0x3E, _T("T4") };
const KEY_CODE	KCD_T5		= { KEY_T5, _T("T5"),				0x3F, _T("T5") };
const KEY_CODE	KCD_T6		= { KEY_T6, _T("T6"),				0x40, _T("T6") };
const KEY_CODE	KCD_T7		= { KEY_T7, _T("T7"),				0x3A, _T("T7") };
const KEY_CODE	KCD_T8		= { KEY_T8, _T("T8"),				0x3B, _T("T8") };
const KEY_CODE	KCD_T9		= { KEY_T9, _T("T9"),				0x3C, _T("T9") };
const KEY_CODE	KCD_T0		= { KEY_T0, _T("T0"),				0x46, _T("T0") };
const KEY_CODE	KCD_TCMA	= { KEY_TCMA, _T("T."),				0x47, _T("T.") };
//
const KEY_CODE	KCDAPL		= { KEYAPL, _T("Application"),		0x80, _T("EXT2") };
//
const KEY_CODE	KCD_TEQU	= { KEY_TEQU, _T("Clear (T=)"),		0x3D, _T("T=") };
const KEY_CODE	KCD_F13		= { KEY_F13, _T("F13"),				0x74, _T("PF13") };
const KEY_CODE	KCD_F14		= { KEY_F14, _T("F14"),				0x75, _T("PF14") };
const KEY_CODE	KCD_F15		= { KEY_F15, _T("F15"),				0x76, _T("PF15") };
const KEY_CODE	KCD_F16		= { KEY_F16, _T("F16"),				0x77, _T("PF16") };
const KEY_CODE	KCD_F17		= { KEY_F17, _T("F17"),				0x78, _T("PF17") };
const KEY_CODE	KCD_F18		= { KEY_F18, _T("F18"),				0x79, _T("PF18") };
const KEY_CODE	KCD_F19		= { KEY_F19, _T("F19"),				0x7A, _T("PF19") };
const KEY_CODE	KCD_F20		= { KEY_F20, _T("F20"),				0x7B, _T("PF20") };
const KEY_CODE	KCD_F21		= { KEY_F21, _T("F21"),				0x6B, _T("") };
const KEY_CODE	KCD_F22		= { KEY_F22, _T("F22"),				0x6C, _T("Pꖕ") };
const KEY_CODE	KCD_F23		= { KEY_F23, _T("F23"),				0x6D, _T("Po^") };
const KEY_CODE	KCD_F24		= { KEY_F24, _T("F24"),				0x59, _T("Ȋ") };
const KEY_CODE	KCDEXECUTE	= { KEYEXECUTE, _T("(Execute)"),	0x73, _T("s") };
//
const KEY_CODE	KCDUDLN		= { KEYUDLN, _T("_"),				0x34, _T("_") };
const KEY_CODE	KCDHIKA		= { KEYHIKA, _T("Ђ炪 / J^Ji"),	0x6F, _T("p") };
const KEY_CODE	KCDYEN		= { KEYYEN, _T("\\"),				0x0E, _T("\\") };
const KEY_CODE	KCDXFER		= { KEYXFER, _T("ϊ"),			0x58, _T("ϊ") };
const KEY_CODE	KCDNFER		= { KEYNFER, _T("ϊ"),			0x57, _T("ϊ") };
//
const KEY_CODE	KCDOYAR		= { KEYOYAR, _T("(FEP1)"),			0x68, _T("ewE") };
const KEY_CODE	KCDOYAL		= { KEYOYAL, _T("(FEP2)"),			0x67, _T("ew") };
//
const KEY_CODE	KCDKATA		= { KEYKATA, _T("(J^Ji)"),		0x5A, _T("J^Ji") };
const KEY_CODE	KCDHIRA		= { KEYHIRA, _T("(Ђ炪)"),		0x56, _T("Ђ炪") };
//
const KEY_CODE	KCDSYSREQ	= { KEYSYSREQ, _T("(System Request)"),	0x7E, _T("SYSREQ") };
const KEY_CODE	KCDCANCEL	= { KEYCANCEL, _T("(Cancel)"),		0x72, _T("") };
//
const KEY_CODE	KCD_T000	= { KEY_T000, _T("(T000)"),			0x4A, _T("T000") };
//
const KEY_CODE	KCDLCTRL	= { KEYLCTRL, _T("Ctrl"),			0x52, _T("CTRL") };
const KEY_CODE	KCDLSHIFT	= { KEYLSHIFT, _T("Shift"),			0x53, _T("SHIFT") };
const KEY_CODE	KCDLALT		= { KEYLALT, _T("Alt"),				0x5C, _T("ALT") };
const KEY_CODE	KCDLGUI		= { KEYLGUI, _T("Windows"),			0x7F, _T("EXT1") };
const KEY_CODE	KCDRCTRL	= { KEYRCTRL, _T("Ctrl"),			0x00, _T("") };
const KEY_CODE	KCDRSHIFT	= { KEYRSHIFT, _T("Shift"),			0x00, _T("") };
const KEY_CODE	KCDRALT		= { KEYRALT, _T("Alt"),				0x00, _T("") };
const KEY_CODE	KCDRGUI		= { KEYRGUI, _T("Windows"),			0x00, _T("") };


// /L|[}/R[hϊ
typedef struct _KANA_CODE {
	BYTE	code;				// /LR[h
	CString	moji;				// \
	BYTE	roma1;				// [}1
	BYTE	roma2;				// [}2
	BYTE	roma3;				// [}3
}KANA_CODE;

const KANA_CODE NxC = { N_C, _T(""), 0, 0, 0 };

const KANA_CODE D1C = { D_C, _T("P"), KEY_M1, 0, 0 };
const KANA_CODE D2C = { D_C, _T("Q"), KEY_M2, 0, 0 };
const KANA_CODE D3C = { D_C, _T("R"), KEY_M3, 0, 0 };
const KANA_CODE D4C = { D_C, _T("S"), KEY_M4, 0, 0 };
const KANA_CODE D5C = { D_C, _T("T"), KEY_M5, 0, 0 };
const KANA_CODE D6C = { D_C, _T("U"), KEY_M6, 0, 0 };
const KANA_CODE D7C = { D_C, _T("V"), KEY_M7, 0, 0 };
const KANA_CODE D8C = { D_C, _T("W"), KEY_M8, 0, 0 };
const KANA_CODE D9C = { D_C, _T("X"), KEY_M9, 0, 0 };
const KANA_CODE D0C = { D_C, _T("O"), KEY_M0, 0, 0 };

const KANA_CODE A__ = { a__, _T(""), KEY_A, 0, 0 };
const KANA_CODE I__ = { i__, _T(""), KEY_I, 0, 0 };
const KANA_CODE U__ = { u__, _T(""), KEY_U, 0, 0 };
const KANA_CODE E__ = { e__, _T(""), KEY_E, 0, 0 };
const KANA_CODE O__ = { o__, _T(""), KEY_O, 0, 0 };

const KANA_CODE KA_ = { ka_, _T(""), KEY_K, KEY_A, 0 };
const KANA_CODE KI_ = { ki_, _T(""), KEY_K, KEY_I, 0 };
const KANA_CODE KU_ = { ku_, _T(""), KEY_K, KEY_U, 0 };
const KANA_CODE KE_ = { ke_, _T(""), KEY_K, KEY_E, 0 };
const KANA_CODE KO_ = { ko_, _T(""), KEY_K, KEY_O, 0 };

const KANA_CODE SA_ = { sa_, _T(""), KEY_S, KEY_A, 0 };
const KANA_CODE SI_ = { si_, _T(""), KEY_S, KEY_I, 0 };
const KANA_CODE SU_ = { su_, _T(""), KEY_S, KEY_U, 0 };
const KANA_CODE SE_ = { se_, _T(""), KEY_S, KEY_E, 0 };
const KANA_CODE SO_ = { so_, _T(""), KEY_S, KEY_O, 0 };

const KANA_CODE TA_ = { ta_, _T(""), KEY_T, KEY_A, 0 };
const KANA_CODE TI_ = { ti_, _T(""), KEY_T, KEY_I, 0 };
const KANA_CODE TU_ = { tu_, _T(""), KEY_T, KEY_U, 0 };
const KANA_CODE TE_ = { te_, _T(""), KEY_T, KEY_E, 0 };
const KANA_CODE TO_ = { to_, _T(""), KEY_T, KEY_O, 0 };

const KANA_CODE NA_ = { na_, _T(""), KEY_N, KEY_A, 0 };
const KANA_CODE NI_ = { ni_, _T(""), KEY_N, KEY_I, 0 };
const KANA_CODE NU_ = { nu_, _T(""), KEY_N, KEY_U, 0 };
const KANA_CODE NE_ = { ne_, _T(""), KEY_N, KEY_E, 0 };
const KANA_CODE NO_ = { no_, _T(""), KEY_N, KEY_O, 0 };

const KANA_CODE HA_ = { ha_, _T(""), KEY_H, KEY_A, 0 };
const KANA_CODE HI_ = { hi_, _T(""), KEY_H, KEY_I, 0 };
const KANA_CODE HU_ = { hu_, _T(""), KEY_H, KEY_U, 0 };
const KANA_CODE HE_ = { he_, _T(""), KEY_H, KEY_E, 0 };
const KANA_CODE HO_ = { ho_, _T(""), KEY_H, KEY_O, 0 };

const KANA_CODE MA_ = { ma_, _T(""), KEY_M, KEY_A, 0 };
const KANA_CODE MI_ = { mi_, _T(""), KEY_M, KEY_I, 0 };
const KANA_CODE MU_ = { mu_, _T(""), KEY_M, KEY_U, 0 };
const KANA_CODE ME_ = { me_, _T(""), KEY_M, KEY_E, 0 };
const KANA_CODE MO_ = { mo_, _T(""), KEY_M, KEY_O, 0 };

const KANA_CODE YA_ = { ya_, _T(""), KEY_Y, KEY_A, 0 };
const KANA_CODE YU_ = { yu_, _T(""), KEY_Y, KEY_U, 0 };
const KANA_CODE YO_ = { yo_, _T(""), KEY_Y, KEY_O, 0 };

const KANA_CODE RA_ = { ra_, _T(""), KEY_R, KEY_A, 0 };
const KANA_CODE RI_ = { ri_, _T(""), KEY_R, KEY_I, 0 };
const KANA_CODE RU_ = { ru_, _T(""), KEY_R, KEY_U, 0 };
const KANA_CODE RE_ = { re_, _T(""), KEY_R, KEY_E, 0 };
const KANA_CODE RO_ = { ro_, _T(""), KEY_R, KEY_O, 0 };

const KANA_CODE WA_ = { wa_, _T(""), KEY_W, KEY_A, 0 };
const KANA_CODE WO_ = { wo_, _T(""), KEY_W, KEY_O, 0 };
const KANA_CODE NN_ = { nn_, _T(""), KEY_N, KEY_N, 0 };

const KANA_CODE GA_ = { ga_, _T(""), KEY_G, KEY_A, 0 };
const KANA_CODE GI_ = { gi_, _T(""), KEY_G, KEY_I, 0 };
const KANA_CODE GU_ = { gu_, _T(""), KEY_G, KEY_U, 0 };
const KANA_CODE GE_ = { ge_, _T(""), KEY_G, KEY_E, 0 };
const KANA_CODE GO_ = { go_, _T(""), KEY_G, KEY_O, 0 };

const KANA_CODE ZA_ = { za_, _T(""), KEY_Z, KEY_A, 0 };
const KANA_CODE ZI_ = { zi_, _T(""), KEY_Z, KEY_I, 0 };
const KANA_CODE ZU_ = { zu_, _T(""), KEY_Z, KEY_U, 0 };
const KANA_CODE ZE_ = { ze_, _T(""), KEY_Z, KEY_E, 0 };
const KANA_CODE ZO_ = { zo_, _T(""), KEY_Z, KEY_O, 0 };

const KANA_CODE DA_ = { da_, _T(""), KEY_D, KEY_A, 0 };
const KANA_CODE DI_ = { di_, _T(""), KEY_D, KEY_I, 0 };
const KANA_CODE DU_ = { du_, _T(""), KEY_D, KEY_U, 0 };
const KANA_CODE DE_ = { de_, _T(""), KEY_D, KEY_E, 0 };
const KANA_CODE DO_ = { do_, _T(""), KEY_D, KEY_O, 0 };

const KANA_CODE BA_ = { ba_, _T(""), KEY_B, KEY_A, 0 };
const KANA_CODE BI_ = { bi_, _T(""), KEY_B, KEY_I, 0 };
const KANA_CODE BU_ = { bu_, _T(""), KEY_B, KEY_U, 0 };
const KANA_CODE BE_ = { be_, _T(""), KEY_B, KEY_E, 0 };
const KANA_CODE BO_ = { bo_, _T(""), KEY_B, KEY_O, 0 };

const KANA_CODE PA_ = { pa_, _T(""), KEY_P, KEY_A, 0 };
const KANA_CODE PI_ = { pi_, _T(""), KEY_P, KEY_I, 0 };
const KANA_CODE PU_ = { pu_, _T(""), KEY_P, KEY_U, 0 };
const KANA_CODE PE_ = { pe_, _T(""), KEY_P, KEY_E, 0 };
const KANA_CODE PO_ = { po_, _T(""), KEY_P, KEY_O, 0 };

const KANA_CODE LA_ = { la_, _T(""), KEY_L, KEY_A, 0 };
const KANA_CODE LI_ = { li_, _T(""), KEY_L, KEY_I, 0 };
const KANA_CODE LU_ = { lu_, _T(""), KEY_L, KEY_U, 0 };
const KANA_CODE LE_ = { le_, _T(""), KEY_L, KEY_E, 0 };
const KANA_CODE LO_ = { lo_, _T(""), KEY_L, KEY_O, 0 };

const KANA_CODE VU_ = { vu_, _T(""), KEY_V, KEY_U, 0 };

const KANA_CODE LTU = { ltu, _T(""), KEY_L, KEY_T, KEY_U };

const KANA_CODE LYA = { lya, _T(""), KEY_L, KEY_Y, KEY_A };
const KANA_CODE LYU = { lyu, _T(""), KEY_L, KEY_Y, KEY_U };
const KANA_CODE LYO = { lyo, _T(""), KEY_L, KEY_Y, KEY_O };

const KANA_CODE LKA = { lka, _T(""), KEY_L, KEY_K, KEY_A };
const KANA_CODE LKE = { lke, _T(""), KEY_L, KEY_K, KEY_E };

const KANA_CODE LWA = { lwa, _T(""), KEY_L, KEY_W, KEY_A };
const KANA_CODE WYI = { wyi, _T(""), KEY_W, KEY_Y, KEY_I };
const KANA_CODE WYE = { wye, _T(""), KEY_W, KEY_Y, KEY_E };

const KANA_CODE LKK = { lkk, _T("u"), KEYLSB,		0, 0 };
const KANA_CODE RKK = { rkk, _T("v"), KEYRSB,		0, 0 };
const KANA_CODE KGR = { kgr, _T("A"), KEYCOMMA,	0, 0 };
const KANA_CODE OWR = { owr, _T("B"), KEYPERIOD,	0, 0 };
const KANA_CODE TEN = { ten, _T("E"), KEYSLASH,	0, 0 };
const KANA_CODE YEN = { yen, _T(""), KEYYEN,		0, 0 };
const KANA_CODE HYP = { hyp, _T("["), KEYMINUS,	0, 0 };

const KANA_CODE EQU = { equ, _T(""), KEYMINUS,	0, 0 };
const KANA_CODE QUS = { qus, _T("H"), KEYSLASH,	0, 0 };
const KANA_CODE TLD = { tld, _T("`"), KEYHAT,		0, 0 };
const KANA_CODE LBT = { lbt, _T("i"), KEY_M8,		0, 0 };
const KANA_CODE RBT = { rbt, _T("j"), KEY_M9,		0, 0 };
const KANA_CODE VLN = { vln, _T("b"), KEYYEN,		0, 0 };

const KANA_CODE SLH = { slh, _T("^"), KEYSLASH,	0, 0 };
const KANA_CODE MUS = { mus, _T("]"), KEYMINUS,	0, 0 };
const KANA_CODE LSB = { lsb, _T("m"), KEYLSB,		0, 0 };
const KANA_CODE RSB = { rsb, _T("n"), KEYRSB,		0, 0 };
const KANA_CODE CMM = { cmm, _T("C"), KEYCOMMA,	0, 0 };
const KANA_CODE DOT = { dot, _T("D"), KEYPERIOD,	0, 0 };



/******************************************************************************/
// L[R[hNX
class CKeyCode //: public CObject
{
protected:
/******************************************************************************/
// L[݌pXg
const KEY_CODE keycodelist[132] = {
	KCD_A,				// [A]L[
	KCD_B,				// [B]L[
	KCD_C,				// [C]L[
	KCD_D,				// [D]L[
	KCD_E,				// [E]L[
	KCD_F,				// [F]L[
	KCD_G,				// [G]L[
	KCD_H,				// [H]L[
	KCD_I,				// [I]L[
	KCD_J,				// [J]L[
	KCD_K,				// [K]L[
	KCD_L,				// [L]L[
	KCD_M,				// [M]L[
	KCD_N,				// [N]L[
	KCD_O,				// [O]L[
	KCD_P,				// [P]L[
	KCD_Q,				// [Q]L[
	KCD_R,				// [R]L[
	KCD_S,				// [S]L[
	KCD_T,				// [T]L[
	KCD_U,				// [U]L[
	KCD_V,				// [V]L[
	KCD_W,				// [W]L[
	KCD_X,				// [X]L[
	KCD_Y,				// [Y]L[
	KCD_Z,				// [Z]L[
	KCD_M1,				// [1]L[
	KCD_M2,				// [2]L[
	KCD_M3,				// [3]L[
	KCD_M4,				// [4]L[
	KCD_M5,				// [5]L[
	KCD_M6,				// [6]L[
	KCD_M7,				// [7]L[
	KCD_M8,				// [8]L[
	KCD_M9,				// [9]L[
	KCD_M0,				// [0]L[
	KCDENTER,			// [ENTER]L[
	KCDESC,				// [ESC]L[
	KCD_BS,				// []L[ (BackSpace)
	KCDTAB,				// [TAB]L[
	KCD_SP,				// []L[ (Spacebar)
	KCDMINUS,			// [-]L[
	KCDHAT,				// [^]L[
	KCD_ATT,			// [@]L[ *JIS
	KCDLSB,				// [[]L[
	KCDRSB,				// []]L[
	KCDSCLN,			// [;]L[
	KCDCLN,				// [:]L[
	KCDHAZE,			// [p/Sp]L[
	KCDCOMMA,			// [,]L[
	KCDPERIOD,			// [.]L[
	KCDSLASH,			// [/]L[
	KCDCAPS,			// [CAPS]L[ (p/CapsLock)
	KCDEISU,			// [p]L[ (p/CapsLock)
	KCD_F1,				// [F1]L[
	KCD_F2,				// [F2]L[
	KCD_F3,				// [F3]L[
	KCD_F4,				// [F4]L[
	KCD_F5,				// [F5]L[
	KCD_F6,				// [F6]L[
	KCD_F7,				// [F7]L[
	KCD_F8,				// [F8]L[
	KCD_F9,				// [F9]L[
	KCD_F10,			// [F10]L[
	KCD_F11,			// [F11]L[
	KCD_F12,			// [F12]L[
	KCDCOPY,			// [COPY]L[ (PreintScreen)
	KCDSCRLOCK,			// [ScrollLock]L[
	KCDPAUSE,			// [Pause]L[
	KCDINSERT,			// [}]L[ (Insert)
	KCDHOME,			// [Home]L[
	KCDHOME2,			// [Home]gL[
	KCDPUP,				// [Os]L[ (PageUp)
	KCDDELETE,			// [폜]L[ (Delete)
	KCDEND,				// [END]L[
	KCDPDOWN,			// [s]L[ (PageDown)
	KCDRARROW,			// []L[
	KCDLARROW,			// []L[
	KCDDARROW,			// []L[
	KCDUARROW,			// []L[
	KCDNUMLOCK,			// ([NumLock]L[)
	KCD_TSLA,			// [T/]L[
	KCD_TAST,			// [T*]L[
	KCD_TNUS,			// [T-]L[
	KCD_TPLS,			// [T+]L[
	KCD_TENT,			// [T Enter]L[
	KCD_T1,				// [T1]L[
	KCD_T2,				// [T2]L[
	KCD_T3,				// [T3]L[
	KCD_T4,				// [T4]L[
	KCD_T5,				// [T5]L[
	KCD_T6,				// [T6]L[
	KCD_T7,				// [T7]L[
	KCD_T8,				// [T8]L[
	KCD_T9,				// [T9]L[
	KCD_T0,				// [T0]L[
	KCD_TCMA,			// [T.]L[
	KCDAPL,				// [EXT2]L[ (Application)
	KCD_TEQU,			// [T=]L[
	KCD_F13,			// [F13]L[
	KCD_F14,			// [F14]L[
	KCD_F15,			// [F15]L[
	KCD_F16,			// [F16]L[
	KCD_F17,			// [F17]L[
	KCD_F18,			// [F18]L[
	KCD_F19,			// [F19]L[
	KCD_F20,			// [F20]L[
	KCD_F21,			// [F21]L[
	KCD_F22,			// [F22]L[
	KCD_F23,			// [F23]L[
	KCD_F24,			// [F24]L[
	KCDEXECUTE,			// [s]L[ (Execute)
	KCDUDLN,			// [_]L[
	KCDHIKA,			// [p]L[ (Ђ炪/J^Ji) *oya
	KCDYEN,				// [\]L[
	KCDXFER,			// [ϊ]L[
	KCDNFER,			// [ϊ]L[
	KCDOYAR,			// [ewE]L[
	KCDOYAL,			// [ew]L[
	KCDKATA,			// [J^Ji]L[ *JIS
	KCDHIRA,			// [Ђ炪]L[ *JIS
	KCDSYSREQ,			// [SYSREQ]L[ (SysReq/Attention)
	KCDCANCEL,			// []L[ (Cansel)
	KCD_T000,			// [T000]L[
	KCDLCTRL,			// [CTRL]L[()
	KCDLSHIFT,			// [SHIFT]L[()
	KCDLALT,			// [ALT]L[()
	KCDLGUI,			// [EXT1]L[() (GUI)
	KCDRCTRL,			//  ([CTRL]L[(E))
	KCDRSHIFT,			//  ([SHIFT]L[(E))
	KCDRALT,			//  ([ALT]L[(E))
	KCDRGUI,			//  ([GUI]L[(E))
};

// ȃR[hXg
const KANA_CODE kanacodelist[116] = {
	// l
	D1C, D2C, D3C, D4C, D5C, D6C, D7C, D8C, D9C, D0C,
	// 
	A__, I__, U__, E__, O__,	          VU_,          	LA_, LI_, LU_, LE_, LO_,
	KA_, KI_, KU_, KE_, KO_,	GA_, GI_, GU_, GE_, GO_,	LKA,           LKE,
	SA_, SI_, SU_, SE_, SO_,	ZA_, ZI_, ZU_, ZE_, ZO_,
	TA_, TI_, TU_, TE_, TO_,	DA_, DI_, DU_, DE_, DO_,	          LTU,
	NA_, NI_, NU_, NE_, NO_,
	HA_, HI_, HU_, HE_, HO_,	BA_, BI_, BU_, BE_, BO_,	PA_, PI_, PU_, PE_, PO_,
	MA_, MI_, MU_, ME_, MO_,
	YA_,      YU_,      YO_,								LYA,      LYU,      LYO,
	RA_, RI_, RU_, RE_, RO_,
 	WA_, WYI,      WYE, WO_,	NN_,						LWA,
	// L
	LKK, RKK, KGR, OWR, TEN, YEN, HYP,
	EQU, QUS, TLD, LBT, RBT, VLN,
	SLH, MUS, LSB, RSB, CMM, DOT,
	// 
	NxC
};

public:
	CKeyCode();
	~CKeyCode();
	void InitializeKeyMaps(BYTE* pMap);
	BYTE KB109NameToUsbCode(LPCTSTR name);
	CString UsbCodeToN109Name(BYTE code);
	CString KanaCodeToName(BYTE code);
	BYTE KanaNameToCode(LPCTSTR name);
};

