/********************************************************************
HidComm.h								Create Date	2013/06/25
USB  HID ɂĒʐMsȂׂ̃NXwb_łB
********************************************************************/
#pragma once

// R[obNt@NV
typedef	void(*FUNCTION)(LPVOID pParam, LPCTSTR lpBuffer);

// HID Mݒ
struct HID_READPARAM {
	HANDLE*			phReadHandle;
	int*			pReadBufLen;
	LPVOID			pParam;
	FUNCTION		Callback;
	bool*			bBinary;
	volatile bool	bExecute;
};

// HID Communication NX
class CHidComm
{
protected:
	// Hid.dll ̕Kvȕϐ
	typedef USHORT USAGE, *PUSAGE;
	typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
	typedef struct _HIDP_CAPS
	{
		USAGE    Usage;
		USAGE    UsagePage;
		USHORT   InputReportByteLength;
		USHORT   OutputReportByteLength;
		USHORT   FeatureReportByteLength;
		USHORT   Reserved[17];

		USHORT   NumberLinkCollectionNodes;

		USHORT   NumberInputButtonCaps;
		USHORT   NumberInputValueCaps;
		USHORT   NumberInputDataIndices;

		USHORT   NumberOutputButtonCaps;
		USHORT   NumberOutputValueCaps;
		USHORT   NumberOutputDataIndices;

		USHORT   NumberFeatureButtonCaps;
		USHORT   NumberFeatureValueCaps;
		USHORT   NumberFeatureDataIndices;
	} HIDP_CAPS, *PHIDP_CAPS;
	// Hid.dll ̕KvȊ֐
	typedef void(__stdcall *pHidD_GetHidGuid) (LPGUID HidGuid);
	pHidD_GetHidGuid HidD_GetHidGuid;
	typedef BOOL(__stdcall *pHidD_GetPreparsedData) (HANDLE HidDeviceObject, PHIDP_PREPARSED_DATA  * PreparsedData);
	pHidD_GetPreparsedData HidD_GetPreparsedData;
	typedef DWORD(__stdcall *pHidP_GetCaps) (PHIDP_PREPARSED_DATA PreparsedData, PHIDP_CAPS Capabilities);
	pHidP_GetCaps HidP_GetCaps;

protected:
	HINSTANCE		m_hHidDll;			// hid.dll nh
	HID_READPARAM	m_HidReadParam;		// M p[^
	HANDLE			m_hWrite;			// Mnh
	HANDLE			m_hRead;			// Mnh
	bool			m_bBinary;			// oCi[h

public:
	int				m_nWriteLength;		// Mobt@TCY
	int				m_nReadLength;		// Mobt@TCY

public:
	CHidComm(void);
	~CHidComm(void);
	void SetBinaryRead(bool bMode);
	int GetDeviceName(int nVendorID, int nProductID, CString* pDeviceName, int nCount);
	BOOL Open(LPCTSTR lpDeviceName, LPVOID pParam = NULL, LPVOID pCallback = NULL);
	void Close(void);
	BOOL Write(unsigned char* pBuffer, int nSize);
	BOOL Write(LPCTSTR lpBuffer);
	BOOL WritetoRead(unsigned char* pWbuf, int nWlen, unsigned char* pRbuf, int nRlen);
	BOOL WritetoRead(LPCTSTR lpWriteString, CString scReadString);
};
