#include "stdafx.h"
#include "KeyCode.h"


CKeyCode::CKeyCode()
{
}


CKeyCode::~CKeyCode()
{
}

// L[}bv (512byte)
void CKeyCode::InitializeKeyMaps(BYTE* pMap)
{
	if (pMap == nullptr) return;
	int i, adr = 0;
	// 1
	for (i = 0; i < 6; i++) {
		*(pMap + adr++) = kana1[i];
	}
	// 2
	for (i = 0; i < 73 * 2; i += 2) {
		*(pMap + adr++) = kana2[i][0];
		*(pMap + adr++) = kana2[i][1];
	}
	// 3
	for (i = 0; i < 10 * 3; i += 3) {
		*(pMap + adr++) = kana3[i][0];
		*(pMap + adr++) = kana3[i][1];
		*(pMap + adr++) = kana3[i][2];
	}
	// L1
	for (i = 0; i < 8; i++) {
		*(pMap + adr++) = kigou1[i];
	}
	// L2
	for (i = 0; i < 8; i++) {
		*(pMap + adr++) = kigou2[i];
	}
	// L3
	for (i = 0; i < 8; i++) {
		*(pMap + adr++) = kigou3[i];
	}
	// ewVtge[u(Vtg)
	for (i = 0; i < 58; i++) {
		*(pMap + adr++) = Non_Shift_Table[i];
	}
	// ewVtge[u(Vtg)
	for (i = 0; i < 58; i++) {
		*(pMap + adr++) = Left_Shift_Table[i];
	}
	// ewVtge[u(EVtg)
	for (i = 0; i < 58; i++) {
		*(pMap + adr++) = Right_Shift_Table[i];
	}
	// FMT-USBϊe[u(ʏ)
	for (i = 0; i < 126; i++) {
		*(pMap + adr++) = FMT_to_USB_CodeTable[i];
	}
	// FMT-USBϊe[u(g)
	for (i = 0; i < 6; i++) {
		*(pMap + adr++) = EX_to_USB_CodeTable[i];
	}
}

// OADG109L[{[h(USB)̃L[R[h擾
BYTE CKeyCode::KB109NameToUsbCode(LPCTSTR name)
{
	for (int i = 0; i<132; i++) {
		if (keycodelist[i].oadg == name) {
			return keycodelist[i].usb;
		}
	}
	return 0;
}

// R[hOADG109L[{[h(USB)̃L[擾
CString CKeyCode::UsbCodeToN109Name(BYTE code)
{
	for (int i = 0; i<132; i++) {
		if (keycodelist[i].usb == code) {
			return keycodelist[i].oadg;
		}
	}
	return _T("");
}


// R[h炩ȕ𓾂
CString CKeyCode::KanaCodeToName(BYTE code)
{
	for (int i = 0; i < 116; i++) {
		if (kanacodelist[i].code == code) {
			return kanacodelist[i].moji;
		}
	}
	return CString();
}

// ȕR[h𓾂
BYTE CKeyCode::KanaNameToCode(LPCTSTR name)
{
	for (int i = 0; i < 116; i++) {
		if (kanacodelist[i].moji == name) {
			return kanacodelist[i].code;
		}
	}
	return 0;
}
