/*******************************************************************
HidComm.cpp								Create Date	2013/06/25
Saka Softwares		Last Update 2015/03/23

USB  HID ɂĒʐMsȂׂ̃NXwb_łB

R[obNĂяoNXɓĎMsȂ܂B
ɂAfoCX牽łM\ɂȂ܂B
R[obN֐ .
static void _callback_xxx(LPVOID pParam, LPCTSTR lpBuffer);

ʐMIAMsXbh͖{̂̏Io
IlɕύX܂BȊM͕svɂȂ܂B

*******************************************************************/
#include "StdAfx.h"
#include "HidComm.h"

// USB HIDʐMpwb_
#include <setupapi.h>
#pragma comment(lib, "setupapi.lib")		// CuJɓ`
/*******************************************************************/
// HID Ms(ʃXbh)
static UINT _HidRecivieData(LPVOID pParam)
{
	HID_READPARAM *hr = (HID_READPARAM*)pParam;
	hr->bExecute = true;
	BOOL bResult = TRUE;
	unsigned char *pSbuf = new unsigned char[*(hr->pReadBufLen) + 5];
	DWORD dwNum, dwErrorCode;
	OVERLAPPED	ovlp;
	memset(&ovlp, 0, sizeof(OVERLAPPED));
	ovlp.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	while (*(hr->phReadHandle) != INVALID_HANDLE_VALUE) {
		if (bResult) {	// MJn
			bResult = ReadFile(*(hr->phReadHandle), pSbuf, *(hr->pReadBufLen) + 1, &dwNum, &ovlp);
		}
		else {			// M҂
			dwErrorCode = GetLastError();
			if (dwErrorCode == ERROR_IO_PENDING || dwErrorCode == ERROR_IO_INCOMPLETE) {
				bResult = GetOverlappedResult(*(hr->phReadHandle), &ovlp, &dwNum, FALSE);
			}
			else break;	// G[I
		}
		//Mf[^
		if (bResult && *(hr->phReadHandle) != INVALID_HANDLE_VALUE) {
			if (*(hr->bBinary)) {
				(hr->Callback)(hr->pParam, (LPCTSTR)(pSbuf + 1));
			}
			else {
#ifdef UNICODE
				TCHAR unicode[1025];
				MultiByteToWideChar(CP_ACP, 0, (LPCSTR)(pSbuf + 1), -1, unicode, *(hr->pReadBufLen));
				(hr->Callback)(hr->pParam, (LPCTSTR)unicode);
#else
				(hr->Callback)(hr->pParam, (LPCTSTR)(pSbuf + 1));
#endif
			}
		}
	}
	delete[] pSbuf;
	hr->bExecute = false;
	return 0;
}

/*******************************************************************/
// HID ʐM̐
CHidComm::CHidComm(void)
	: m_bBinary(false)
	, m_nWriteLength(0)
	, m_nReadLength(0)
{
	// hid.dlľĂяo
	m_hHidDll = LoadLibrary(_T("hid.dll"));
	// ֐̎擾
	HidD_GetHidGuid = (pHidD_GetHidGuid)GetProcAddress(m_hHidDll, "HidD_GetHidGuid");
	HidD_GetPreparsedData = (pHidD_GetPreparsedData)GetProcAddress(m_hHidDll, "HidD_GetPreparsedData");
	HidP_GetCaps = (pHidP_GetCaps)GetProcAddress(m_hHidDll, "HidP_GetCaps");
	// nh̏
	m_hWrite = INVALID_HANDLE_VALUE;
	m_hRead = INVALID_HANDLE_VALUE;
	// Mp[^ݒ
	m_HidReadParam.phReadHandle = &m_hRead;
	m_HidReadParam.pReadBufLen = &m_nReadLength;
	m_HidReadParam.bBinary = &m_bBinary;
}

// HID ʐM̏I
CHidComm::~CHidComm(void)
{
	// nhN[Y
	Close();
	// hid.dll̊J
	FreeLibrary(m_hHidDll);
}

// oCi[/M̐ݒ
void CHidComm::SetBinaryRead(bool bMode)
{
	m_bBinary = bMode;
}

// HID foCX̎擾
// foCXID/v_NgIDɊtꂽfoCXnCount擾B
int CHidComm::GetDeviceName(int nVendorID, int nProductID, CString* pDeviceName, int nCount)
{
	//	HIDGUID擾
	GUID InterfaceClassGuid;
	HidD_GetHidGuid(&InterfaceClassGuid); // hid.dll

	HDEVINFO hDev = INVALID_HANDLE_VALUE;
	DWORD dwIndex = 0;
	CString DeviceIDToFind;
	DeviceIDToFind.Format(_T("Vid_%04x&Pid_%04x"), nVendorID, nProductID);
	int nResult = 0;
	// HID Device Interface Class  ݑ݂foCX̃nh擾
	hDev = SetupDiGetClassDevs(&InterfaceClassGuid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);
	if (hDev == INVALID_HANDLE_VALUE) return nResult;
	// foCX
	while (true) {
		SP_DEVICE_INTERFACE_DATA			Info;
		PSP_DEVICE_INTERFACE_DETAIL_DATA	pDetail;
		SP_DEVINFO_DATA						DevInfo;

		DWORD dwRegType;
		DWORD dwRegSize;
		DWORD StructureSize = 0;
		PBYTE pBuffer;

		Info.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
		// foCXC^[tF[X 
		if (!SetupDiEnumDeviceInterfaces(hDev, NULL, &InterfaceClassGuid, dwIndex, &Info)) break;

		DevInfo.cbSize = sizeof(SP_DEVINFO_DATA);
		SetupDiEnumDeviceInfo(hDev, dwIndex, &DevInfo);

		SetupDiGetDeviceRegistryProperty(hDev, &DevInfo, SPDRP_HARDWAREID, &dwRegType, NULL, 0, &dwRegSize);

		if ((pBuffer = (BYTE *)malloc(dwRegSize)) == NULL) break;

		SetupDiGetDeviceRegistryProperty(hDev, &DevInfo, SPDRP_HARDWAREID, &dwRegType, pBuffer, dwRegSize, NULL);

#ifdef UNICODE
		CString DeviceIDFromRegistry = (wchar_t *)pBuffer;
#else
		CString DeviceIDFromRegistry = (char *)pBuffer;
#endif

		free(pBuffer);

		DeviceIDFromRegistry.MakeLower();
		DeviceIDToFind.MakeLower();

		if (DeviceIDFromRegistry.Find(DeviceIDToFind) != -1) {
			SetupDiGetDeviceInterfaceDetail(hDev, &Info, NULL, NULL, &StructureSize, NULL);

			if ((pDetail = (PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(StructureSize)) == NULL) break;

			pDetail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
			SetupDiGetDeviceInterfaceDetail(hDev, &Info, pDetail, StructureSize, NULL, NULL);

			*(pDeviceName + nResult) = pDetail->DevicePath; // foCX̎擾

			free(pDetail);

			if (++nResult >= nCount) break;
		}
		dwIndex++;
	}
	SetupDiDestroyDeviceInfoList(hDev);
	return nResult;
}

// HID foCX̃I[v
BOOL CHidComm::Open(LPCTSTR lpDeviceName, LPVOID pParam/*=NULL*/, LPVOID pCallback/*=NULL*/)
{
//	if (m_hWrite != INVALID_HANDLE_VALUE) Close();
	// Mnh擾
	m_hWrite = CreateFile(lpDeviceName, GENERIC_WRITE, FILE_SHARE_READ |
		FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
	if (m_hWrite!= INVALID_HANDLE_VALUE) {
		DWORD dwNum;
		WriteFile(m_hWrite, "\0\0", m_nWriteLength + 1, &dwNum, NULL);
	}
	// Mnh擾
	if (pParam != NULL && pCallback != NULL) {
		// 񓯊I/O
		m_hRead = CreateFile(lpDeviceName, GENERIC_READ, FILE_SHARE_READ |
			FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	}
	else {
		// I/O
		m_hRead = CreateFile(lpDeviceName, GENERIC_READ, FILE_SHARE_READ |
			FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
	}
	// nh擾mF
	if (m_hWrite == INVALID_HANDLE_VALUE ||
		m_hRead == INVALID_HANDLE_VALUE) {
		Close();
		return FALSE;
	}
	// obt@TCY̎擾
	PHIDP_PREPARSED_DATA pp;
	HIDP_CAPS caps;
	HidD_GetPreparsedData(m_hRead, &pp);		// hid.dll
	HidP_GetCaps(pp, &caps);					// hid.dll
	m_nWriteLength = caps.OutputReportByteLength - 1;
	m_nReadLength = caps.InputReportByteLength - 1;
	m_HidReadParam.bExecute = false;
	// MXbhN
	if (pParam != NULL && pCallback != NULL) {
		m_HidReadParam.pParam = pParam;
		m_HidReadParam.Callback = (FUNCTION)pCallback;
		::AfxBeginThread(_HidRecivieData, &m_HidReadParam, THREAD_PRIORITY_NORMAL, 0, 0, NULL);
	}
	return TRUE;
}

// HID foCX̃N[Y
void CHidComm::Close(void)
{
	if (m_hWrite != INVALID_HANDLE_VALUE) {
		CloseHandle(m_hWrite);
		m_hWrite = INVALID_HANDLE_VALUE;
		m_nWriteLength = 0;
	}
	if (m_hRead != INVALID_HANDLE_VALUE) {
		CloseHandle(m_hRead);
		m_hRead = INVALID_HANDLE_VALUE;
		m_nReadLength = 0;
		while (m_HidReadParam.bExecute);
	}
	while (	m_HidReadParam.bExecute );


}

// oCi[M
BOOL CHidComm::Write(unsigned char* pBuffer, int nSize)
{
	if (m_hWrite == INVALID_HANDLE_VALUE || nSize>m_nWriteLength) return FALSE;
	DWORD dwNum;
	unsigned char *pSbuf = new unsigned char[m_nWriteLength + 5];
	ZeroMemory(pSbuf, m_nWriteLength + 5);
	if (nSize>0) for (int i = 0; i<nSize; i++) *(pSbuf + i + 1) = *(pBuffer + i);
	BOOL bResult = WriteFile(m_hWrite, pSbuf, m_nWriteLength + 1, &dwNum, NULL);
	delete[] pSbuf;
	return bResult;
}

// 񑗐M
BOOL CHidComm::Write(LPCTSTR lpBuffer)
{
	if (m_hWrite == INVALID_HANDLE_VALUE) return FALSE;
	DWORD dwNum;
	unsigned char *pSbuf = new unsigned char[m_nWriteLength + 5];
	ZeroMemory(pSbuf, m_nWriteLength + 5);
	*pSbuf = '1';
	// 񏈗
#ifdef UNICODE
	WideCharToMultiByte(CP_ACP, 0, (const wchar_t*)lpBuffer, -1, (LPSTR)(pSbuf + 1),
		m_nWriteLength, NULL, NULL);
#else
	for (int i = 0; i<m_nWriteLength; i++) {
		if (*(lpBuffer + i) == _T('\0')) break;
		*(pSbuf + i + 1) = *(lpBuffer + i);
	}
#endif
	*pSbuf = '\0';
	BOOL bResult = WriteFile(m_hWrite, pSbuf, m_nWriteLength + 1, &dwNum, NULL);
	delete[] pSbuf;
	return bResult;
}

// oCi[M
BOOL CHidComm::WritetoRead(unsigned char* pWbuf, int nWlen, unsigned char* pRbuf, int nRlen)
{
	if (m_hRead == INVALID_HANDLE_VALUE || nRlen>m_nReadLength) return FALSE;
	BOOL bResult = FALSE;
	if (Write(pWbuf, nWlen)) {
		DWORD dwNum;
		unsigned char *pSbuf = new unsigned char[m_nReadLength + 5];
		ZeroMemory(pSbuf, m_nReadLength + 5);
		if (ReadFile(m_hRead, pSbuf, m_nReadLength + 1, &dwNum, NULL)) {
			if (pRbuf != NULL && nRlen > 0) {
				for (int i = 0; i<nRlen; i++) *(pRbuf + i) = *(pSbuf + i + 1);
			}
			bResult = TRUE;
		}
		delete[] pSbuf;
	}
	return bResult;
}

// 񑗎M
BOOL CHidComm::WritetoRead(LPCTSTR lpWriteString, CString scReadString)
{
	if (m_hRead == INVALID_HANDLE_VALUE) return FALSE;
	BOOL bResult = FALSE;
	if (Write(lpWriteString)) {
		DWORD dwNum;
		unsigned char *pSbuf = new unsigned char[m_nReadLength + 5];
		ZeroMemory(pSbuf, m_nReadLength + 5);
		if (ReadFile(m_hRead, pSbuf, m_nReadLength + 1, &dwNum, NULL)) {
#ifdef UNICODE
			MultiByteToWideChar(CP_ACP, 0, (LPCSTR)(pSbuf + 1), -1,
				scReadString.GetBufferSetLength(m_nReadLength), m_nReadLength);
#else
			scReadString = pSbuf;
#endif
			bResult = TRUE;
		}
		delete[] pSbuf;
	}
	return bResult;
}
