/******************************************************************************
 * 7Seg 3column display for pic16f1827				Create Date	2017/03/11
 * File Name	: disp.h
 * Complier		: XC8 Ver 1.41
 ******************************************************************************/
#ifndef	_7SEG_3COL_5LEDs_
#define	_7SEG_3COL_5LEDs_
/******************************************************************************
 * 内部16MHz/Timer0の128uS周期割り込み動作を想定して作っています。
 * 文字表示は、3桁で0.00～99.9まで表示できます。
 * 固定小数点でデータを受け下位2桁が小数点以下になります。
 * 表示できない部分は四捨五入されます。(例 1235 -> 12.4)
 */
/** Setup *********************************************************************/
// 使用ピン設定
#define	DP1		LATAbits.LATA0
#define	DP1TR	TRISAbits.TRISA0
#define	DP2		LATAbits.LATA1
#define	DP2TR	TRISAbits.TRISA1
#define	DP3		LATAbits.LATA7
#define	DP3TR	TRISAbits.TRISA7
#define	LEDs	LATAbits.LATA6
#define	LEDsTR	TRISAbits.TRISA6
#define	SEGs	LATB
#define	SEGsTR	TRISB

// 7Segの共通ピン（アノード又はカソードを一つ選択します）
#define	COMMON_ANODE
//#define COMMON_CATHODE

// 表示LED
#define LED1	0	// (m) mA/mW/mWh用
#define LED2	1	// (V)
#define LED3	2	// (A))
#define LED4	3	// (W)
#define LED5	4	// (Wh))

/** Function ******************************************************************/
void InitializeDisp(void);
void PostDisp(void);
void ClearDisp(void);
void InterruptDisp (void);
void DispBright(uint8_t dp, uint8_t led);
bool DispNumber(int16_t num, bool blank);
bool DispFixedPoint(uint16_t num);
void DispUnit(uint8_t num);

#endif
/**	end of file	***************************************************************/
